/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.CopyRowsOperation;
import org.apache.derby.impl.store.raw.data.DeleteOperation;
import org.apache.derby.impl.store.raw.data.InitPageOperation;
import org.apache.derby.impl.store.raw.data.InsertOperation;
import org.apache.derby.impl.store.raw.data.InvalidatePageOperation;
import org.apache.derby.impl.store.raw.data.PageActions;
import org.apache.derby.impl.store.raw.data.PageBasicOperation;
import org.apache.derby.impl.store.raw.data.PurgeOperation;
import org.apache.derby.impl.store.raw.data.SetReservedSpaceOperation;
import org.apache.derby.impl.store.raw.data.UpdateFieldOperation;
import org.apache.derby.impl.store.raw.data.UpdateOperation;
import org.apache.derby.shared.common.sanity.SanityManager;

public class LoggableActions
implements PageActions {
    @Override
    public void actionDelete(RawTransaction t, BasePage page, int slot, int recordId, boolean delete, LogicalUndo undo) throws StandardException {
        DeleteOperation lop = new DeleteOperation(t, page, slot, recordId, delete, undo);
        this.doAction(t, page, lop);
    }

    @Override
    public int actionUpdate(RawTransaction t, BasePage page, int slot, int recordId, Object[] row, FormatableBitSet validColumns, int realStartColumn, DynamicByteArrayOutputStream logBuffer, int realSpaceOnPage, RecordHandle headRowHandle) throws StandardException {
        UpdateOperation lop = new UpdateOperation(t, page, slot, recordId, row, validColumns, realStartColumn, logBuffer, realSpaceOnPage, headRowHandle);
        this.doAction(t, page, lop);
        return lop.getNextStartColumn();
    }

    @Override
    public void actionPurge(RawTransaction t, BasePage page, int slot, int num_rows, int[] recordIds, boolean logData) throws StandardException {
        PurgeOperation lop = new PurgeOperation(t, page, slot, num_rows, recordIds, logData);
        this.doAction(t, page, lop);
    }

    @Override
    public void actionUpdateField(RawTransaction t, BasePage page, int slot, int recordId, int fieldId, Object newValue, LogicalUndo undo) throws StandardException {
        UpdateFieldOperation lop = new UpdateFieldOperation(t, page, slot, recordId, fieldId, newValue, undo);
        this.doAction(t, page, lop);
    }

    @Override
    public int actionInsert(RawTransaction t, BasePage page, int slot, int recordId, Object[] row, FormatableBitSet validColumns, LogicalUndo undo, byte insertFlag, int startColumn, boolean isLongColumn, int realStartColumn, DynamicByteArrayOutputStream logBuffer, int realSpaceOnPage, int overflowThreshold) throws StandardException {
        InsertOperation lop = new InsertOperation(t, page, slot, recordId, row, validColumns, undo, insertFlag, startColumn, isLongColumn, realStartColumn, logBuffer, realSpaceOnPage, overflowThreshold);
        this.doAction(t, page, lop);
        return lop.getNextStartColumn();
    }

    @Override
    public void actionCopyRows(RawTransaction t, BasePage destPage, BasePage srcPage, int srcSlot, int numRows, int destSlot, int[] recordIds) throws StandardException {
        CopyRowsOperation lop = new CopyRowsOperation(t, destPage, srcPage, srcSlot, numRows, destSlot, recordIds);
        this.doAction(t, destPage, lop);
    }

    @Override
    public void actionInvalidatePage(RawTransaction t, BasePage page) throws StandardException {
        InvalidatePageOperation lop = new InvalidatePageOperation(page);
        this.doAction(t, page, lop);
    }

    @Override
    public void actionInitPage(RawTransaction t, BasePage page, int initFlag, int pageFormatId, long pageOffset) throws StandardException {
        InitPageOperation lop = new InitPageOperation(page, initFlag, pageFormatId, pageOffset);
        this.doAction(t, page, lop);
    }

    @Override
    public void actionShrinkReservedSpace(RawTransaction t, BasePage page, int slot, int recordId, int newValue, int oldValue) throws StandardException {
        SetReservedSpaceOperation lop = new SetReservedSpaceOperation(page, slot, recordId, newValue, oldValue);
        this.doAction(t, page, lop);
    }

    private void doAction(RawTransaction t, BasePage page, Loggable lop) throws StandardException {
        long oldversion = 0L;
        LogInstant oldLogInstant = null;
        oldLogInstant = page.getLastLogInstant();
        oldversion = page.getPageVersion();
        page.preDirty();
        t.logAndDo(lop);
        if (oldLogInstant != null && page.getLastLogInstant() != null && !oldLogInstant.lessThan(page.getLastLogInstant())) {
            SanityManager.THROWASSERT("old log instant = " + oldLogInstant + " lastlog = " + page.getLastLogInstant());
        }
        SanityManager.ASSERT(oldversion == ((PageBasicOperation)lop).getPageVersion());
        SanityManager.ASSERT(page.getPageVersion() > oldversion);
    }
}

