/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTreeRowPosition;
import org.apache.derby.impl.store.access.btree.BTreeScan;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.shared.common.sanity.SanityManager;

public class BTreeForwardScan
extends BTreeScan {
    @Override
    protected void positionAtStartPosition(BTreeRowPosition pos) throws StandardException {
        this.positionAtStartForForwardScan(pos);
    }

    @Override
    protected int fetchRows(BTreeRowPosition pos, DataValueDescriptor[][] row_array, RowLocation[] rowloc_array, BackingStoreHashtable hash_table, long max_rowcnt, int[] key_column_numbers) throws StandardException {
        SanityManager.ASSERT(hash_table == null || !hash_table.includeRowLocations());
        int ret_row_count = 0;
        Object[] fetch_row = null;
        if (max_rowcnt == -1L) {
            max_rowcnt = Long.MAX_VALUE;
        }
        if (this.scan_state == 2) {
            if (!this.reposition(pos, true)) {
                SanityManager.THROWASSERT("can not fail with 2nd param true.");
            }
        } else if (this.scan_state == 1) {
            this.positionAtStartPosition(pos);
        } else if (this.scan_state == 5) {
            this.reopen();
            this.scan_state = 2;
            SanityManager.ASSERT(this.scan_position.current_positionKey != null);
            if (!this.reposition(pos, true)) {
                SanityManager.THROWASSERT("can not fail with 2nd param true.");
            }
        } else if (this.scan_state == 4) {
            this.reopen();
            this.positionAtStartForForwardScan(this.scan_position);
        } else {
            SanityManager.ASSERT(this.scan_state == 3);
            return 0;
        }
        SanityManager.ASSERT(this.init_template != null, "init_template is null");
        SanityManager.ASSERT(this.container != null, "BTreeScan.next() called on a closed scan.");
        if (row_array != null) {
            SanityManager.ASSERT(row_array[0] != null, "first array slot in fetchNextGroup() must be non-null.");
        }
        if (rowloc_array != null) {
            throw StandardException.newException("XSCB3.S", new Object[0]);
        }
        while (pos.current_leaf != null) {
            block1: while (pos.current_slot + 1 < pos.current_leaf.page.recordCount()) {
                boolean doneWithGroup;
                if (pos.current_rh != null) {
                    this.getLockingPolicy().unlockScanRecordAfterRead(pos, this.init_forUpdate);
                    pos.current_rh = null;
                }
                if (fetch_row == null) {
                    if (hash_table == null) {
                        if (row_array[ret_row_count] == null) {
                            row_array[ret_row_count] = this.runtime_mem.get_row_for_export(this.getRawTran());
                        }
                        fetch_row = row_array[ret_row_count];
                    } else {
                        fetch_row = this.runtime_mem.get_row_for_export(this.getRawTran());
                    }
                }
                ++pos.current_slot;
                ++this.stat_numrows_visited;
                RecordHandle rh = pos.current_leaf.page.fetchFromSlot(null, pos.current_slot, fetch_row, this.init_fetchDesc, true);
                pos.current_rh_qualified = true;
                if (this.init_stopKeyValue != null) {
                    int ret = ControlRow.compareIndexRowToKey((DataValueDescriptor[])fetch_row, this.init_stopKeyValue, fetch_row.length, 0, this.getConglomerate().ascDescInfo);
                    if (ret == 0 && this.init_stopSearchOperator == 1) {
                        ret = 1;
                    }
                    if (ret > 0) {
                        pos.current_leaf.release();
                        pos.current_leaf = null;
                        this.positionAtDoneScan(pos);
                        return ret_row_count;
                    }
                }
                boolean latch_released = !this.getLockingPolicy().lockScanRow(this, pos, this.init_lock_fetch_desc, pos.current_lock_template, pos.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
                latch_released = BTreeForwardScan.test_errors(this, "BTreeScan_fetchNextGroup", pos, this.getLockingPolicy(), pos.current_leaf, latch_released);
                pos.current_rh = rh;
                while (latch_released) {
                    if (!this.reposition(pos, false)) {
                        if (this.reposition(pos, true)) continue block1;
                        SanityManager.THROWASSERT("Cannot fail with 2nd param true");
                        continue block1;
                    }
                    latch_released = false;
                    if (!this.getConglomerate().isUnique()) continue;
                    pos.current_leaf.page.fetchFromSlot(null, pos.current_slot, fetch_row, this.init_fetchDesc, true);
                    latch_released = !this.getLockingPolicy().lockScanRow(this, pos, this.init_lock_fetch_desc, pos.current_lock_template, pos.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
                }
                if (pos.current_leaf.page.isDeletedAtSlot(pos.current_slot)) {
                    ++this.stat_numdeleted_rows_visited;
                    pos.current_rh_qualified = false;
                } else if (this.init_qualifier != null) {
                    pos.current_rh_qualified = this.process_qualifier((DataValueDescriptor[])fetch_row);
                }
                if (!pos.current_rh_qualified) continue;
                SanityManager.ASSERT(pos.current_leaf.page.getSlotNumber(pos.current_rh) == pos.current_slot);
                ++this.stat_numrows_qualified;
                boolean bl = doneWithGroup = max_rowcnt <= (long)(++ret_row_count);
                if (doneWithGroup) {
                    SanityManager.ASSERT(pos == this.scan_position);
                    int[] vcols = this.init_fetchDesc.getValidColumnsArray();
                    this.savePositionAndReleasePage((DataValueDescriptor[])fetch_row, vcols);
                }
                if (hash_table != null) {
                    if (hash_table.putRow(false, (DataValueDescriptor[])fetch_row, null)) {
                        fetch_row = null;
                    }
                } else {
                    fetch_row = null;
                }
                if (!doneWithGroup) continue;
                return ret_row_count;
            }
            this.positionAtNextPage(pos);
            ++this.stat_numpages_visited;
        }
        this.positionAtDoneScan(pos);
        --this.stat_numpages_visited;
        return ret_row_count;
    }
}

