/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.InputStream;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NoRowsResultSetImpl;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.UpdatableVTIConstantAction;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class DMLWriteResultSet
extends NoRowsResultSetImpl {
    protected WriteCursorConstantAction constantAction;
    protected int[] baseRowReadMap;
    protected int[] streamStorableHeapColIds;
    protected DynamicCompiledOpenConglomInfo heapDCOCI;
    protected DynamicCompiledOpenConglomInfo[] indexDCOCIs;
    private boolean needToObjectifyStream;
    public long rowCount;
    protected ResultDescription resultDescription;
    protected DataValueDescriptor[] cachedDestinations;

    DMLWriteResultSet(Activation activation) throws StandardException {
        this(activation, activation.getConstantAction());
    }

    DMLWriteResultSet(Activation activation, ConstantAction constantAction) throws StandardException {
        super(activation);
        this.constantAction = (WriteCursorConstantAction)constantAction;
        this.baseRowReadMap = this.constantAction.getBaseRowReadMap();
        this.streamStorableHeapColIds = this.constantAction.getStreamStorableHeapColIds();
        TransactionController tc = activation.getTransactionController();
        if (!(constantAction instanceof UpdatableVTIConstantAction)) {
            this.heapDCOCI = tc.getDynamicCompiledConglomInfo(this.constantAction.conglomId);
            if (this.constantAction.indexCIDS.length != 0) {
                this.indexDCOCIs = new DynamicCompiledOpenConglomInfo[this.constantAction.indexCIDS.length];
                for (int index = 0; index < this.constantAction.indexCIDS.length; ++index) {
                    this.indexDCOCIs[index] = tc.getDynamicCompiledConglomInfo(this.constantAction.indexCIDS[index]);
                }
            }
        }
        this.needToObjectifyStream = this.constantAction.getTriggerInfo() != null;
    }

    @Override
    public final long modifiedRowCount() {
        return this.rowCount + RowUtil.getRowCountBase();
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    protected ExecRow getNextRowCore(NoPutResultSet source) throws StandardException {
        ExecRow row = source.getNextRowCore();
        if (this.needToObjectifyStream) {
            this.objectifyStreams(row);
        }
        return row;
    }

    private void objectifyStreams(ExecRow row) throws StandardException {
        if (row != null && this.streamStorableHeapColIds != null) {
            for (int ix = 0; ix < this.streamStorableHeapColIds.length; ++ix) {
                int heapIx = this.streamStorableHeapColIds[ix];
                int readIx = this.baseRowReadMap == null ? heapIx : this.baseRowReadMap[heapIx];
                DataValueDescriptor col = row.getColumn(readIx + 1);
                if (col == null) continue;
                InputStream stream = ((StreamStorable)((Object)col)).returnStream();
                ((StreamStorable)((Object)col)).loadStream();
                if (stream == null) continue;
                for (int i = 1; i <= row.nColumns(); ++i) {
                    DataValueDescriptor c = row.getColumn(i);
                    if (!(c instanceof StreamStorable) || ((StreamStorable)((Object)c)).returnStream() != stream) continue;
                    row.setColumn(i, col.cloneValue(false));
                }
            }
        }
    }

    protected ExecRow makeDeferredSparseRow(ExecRow deferredBaseRow, FormatableBitSet baseRowReadList, LanguageConnectionContext lcc) throws StandardException {
        ExecRow deferredSparseRow;
        if (baseRowReadList == null) {
            deferredSparseRow = deferredBaseRow;
        } else {
            deferredSparseRow = RowUtil.getEmptyValueRow(baseRowReadList.getLength() - 1, lcc);
            int fromPosition = 1;
            for (int i = 1; i <= deferredSparseRow.nColumns(); ++i) {
                if (!baseRowReadList.isSet(i)) continue;
                deferredSparseRow.setColumn(i, deferredBaseRow.getColumn(fromPosition++));
            }
        }
        return deferredSparseRow;
    }

    int decodeLockMode(int lockMode) {
        SanityManager.ASSERT(!this.isClosed());
        if (lockMode >>> 16 == 0) {
            return lockMode;
        }
        int isolationLevel = this.lcc.getCurrentIsolationLevel();
        if (isolationLevel == 4) {
            return lockMode >>> 16;
        }
        return lockMode & 0xFF;
    }

    String getIndexNameFromCID(long indexCID) {
        return this.constantAction.getIndexNameFromCID(indexCID);
    }

    protected ExecRow normalizeRow(NoPutResultSet sourceResultSet, ExecRow row) throws StandardException {
        int position;
        int i;
        int count = this.resultDescription.getColumnCount();
        if (this.cachedDestinations == null) {
            this.cachedDestinations = new DataValueDescriptor[count];
            for (i = 0; i < count; ++i) {
                position = i + 1;
                ResultColumnDescriptor colDesc = this.resultDescription.getColumnDescriptor(position);
                this.cachedDestinations[i] = colDesc.getType().getNull();
            }
        }
        for (i = 0; i < count; ++i) {
            position = i + 1;
            DataTypeDescriptor dtd = this.resultDescription.getColumnDescriptor(position).getType();
            if (row.getColumn(position) == null) {
                row.setColumn(position, dtd.getNull());
            }
            row.setColumn(position, NormalizeResultSet.normalizeColumn(dtd, row, position, this.cachedDestinations[i], this.resultDescription));
        }
        this.activation.setCurrentRow(row, sourceResultSet.resultSetNumber());
        return row;
    }

    public void rememberConstraint(UUID cid) throws StandardException {
        SanityManager.NOTREACHED();
    }
}

