/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class CreateSequenceConstantAction
extends DDLConstantAction {
    private String _sequenceName;
    private String _schemaName;
    private DataTypeDescriptor _dataType;
    private long _initialValue;
    private long _stepValue;
    private long _maxValue;
    private long _minValue;
    private boolean _cycle;

    public CreateSequenceConstantAction(String schemaName, String sequenceName, DataTypeDescriptor dataType, long initialValue, long stepValue, long maxValue, long minValue, boolean cycle) {
        this._schemaName = schemaName;
        this._sequenceName = sequenceName;
        this._dataType = dataType;
        this._initialValue = initialValue;
        this._stepValue = stepValue;
        this._maxValue = maxValue;
        this._minValue = minValue;
        this._cycle = cycle;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        dd.startWriting(lcc);
        SchemaDescriptor schemaDescriptor = DDLConstantAction.getSchemaDescriptorForCreate(dd, activation, this._schemaName);
        SequenceDescriptor seqDef = dd.getSequenceDescriptor(schemaDescriptor, this._sequenceName);
        if (seqDef != null) {
            throw StandardException.newException("X0Y68.S", seqDef.getDescriptorType(), this._sequenceName);
        }
        seqDef = ddg.newSequenceDescriptor(schemaDescriptor, dd.getUUIDFactory().createUUID(), this._sequenceName, this._dataType, this._initialValue, this._initialValue, this._minValue, this._maxValue, this._stepValue, this._cycle);
        dd.addDescriptor(seqDef, null, 20, false, tc);
    }

    public String toString() {
        return "CREATE SEQUENCE " + this._sequenceName;
    }
}

