/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.sql.dictionary.ConsInfo;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class ConstraintInfo
implements ConsInfo {
    private String tableName;
    private SchemaDescriptor tableSd;
    private UUID tableSchemaId;
    private String[] columnNames;
    private int raDeleteRule;
    private int raUpdateRule;

    public ConstraintInfo() {
    }

    public ConstraintInfo(String tableName, SchemaDescriptor tableSd, String[] columnNames, int raDeleteRule, int raUpdateRule) {
        this.tableName = tableName;
        this.tableSd = tableSd;
        this.columnNames = ArrayUtil.copy(columnNames);
        this.raDeleteRule = raDeleteRule;
        this.raUpdateRule = raUpdateRule;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tableName);
        if (this.tableSd == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.tableSd.getUUID());
        }
        if (this.columnNames == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            ArrayUtil.writeArrayLength(out, this.columnNames);
            ArrayUtil.writeArrayItems(out, this.columnNames);
        }
        out.writeInt(this.raDeleteRule);
        out.writeInt(this.raUpdateRule);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tableName = (String)in.readObject();
        if (in.readBoolean()) {
            this.tableSchemaId = (UUID)in.readObject();
        }
        if (in.readBoolean()) {
            this.columnNames = new String[ArrayUtil.readArrayLength(in)];
            ArrayUtil.readArrayItems(in, this.columnNames);
        }
        this.raDeleteRule = in.readInt();
        this.raUpdateRule = in.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 278;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Referencing ");
        str.append(this.tableName);
        if (this.columnNames != null) {
            str.append("(");
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(this.columnNames[i]);
            }
            str.append(")");
        }
        return str.toString();
    }

    @Override
    public SchemaDescriptor getReferencedTableSchemaDescriptor(DataDictionary dd) throws StandardException {
        if (this.tableSd != null) {
            return this.tableSd;
        }
        return dd.getSchemaDescriptor(this.tableSchemaId, null);
    }

    @Override
    public TableDescriptor getReferencedTableDescriptor(DataDictionary dd) throws StandardException {
        if (this.tableName == null) {
            return null;
        }
        return dd.getTableDescriptor(this.tableName, this.getReferencedTableSchemaDescriptor(dd), null);
    }

    @Override
    public String[] getReferencedColumnNames() {
        return ArrayUtil.copy(this.columnNames);
    }

    @Override
    public String getReferencedTableName() {
        return this.tableName;
    }

    @Override
    public int getReferentialActionUpdateRule() {
        return this.raUpdateRule;
    }

    @Override
    public int getReferentialActionDeleteRule() {
        return this.raDeleteRule;
    }
}

