/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.sanity.SanityManager;

final class AutoPositioningStream
extends BinaryToRawStream {
    private final ConnectionChild conChild;
    private long pos;
    private final PositionedStoreStream positionedStream;

    AutoPositioningStream(ConnectionChild conChild, InputStream in, Object parent) throws IOException {
        super(in, parent);
        SanityManager.ASSERT(in instanceof PositionedStoreStream, "Unexpected stream");
        this.positionedStream = (PositionedStoreStream)in;
        this.pos = this.positionedStream.getPosition();
        this.conChild = conChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.conChild.getConnectionSynchronization();
        synchronized (object) {
            try {
                this.setPosition();
            }
            catch (EOFException e) {
                return -1;
            }
            int ret = this.positionedStream.read();
            if (ret >= 0) {
                ++this.pos;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Object object = this.conChild.getConnectionSynchronization();
        synchronized (object) {
            try {
                this.setPosition();
            }
            catch (EOFException e) {
                return -1;
            }
            int ret = this.positionedStream.read(b, off, len);
            if (ret > 0) {
                this.pos += (long)ret;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        Object object = this.conChild.getConnectionSynchronization();
        synchronized (object) {
            this.setPosition();
            long ret = this.positionedStream.skip(n);
            this.pos += ret;
            return ret;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void setPosition() throws IOException {
        try {
            if (this.pos != this.positionedStream.getPosition()) {
                this.positionedStream.reposition(this.pos);
            }
        }
        catch (StandardException se) {
            throw Util.newIOException(se);
        }
    }
}

