/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.harness;

import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiIterations;

public abstract class T_MultiThreadedIterations
extends T_MultiIterations
implements Runnable {
    protected int threadNumber = 0;
    static volatile boolean inError = false;
    static int numThreads = 1;
    static int iterations = 1;
    Throwable error = null;
    static Thread[] TestThreads;
    static T_MultiThreadedIterations[] TestObjects;

    protected T_MultiThreadedIterations() {
    }

    @Override
    protected void runTests() throws T_Fail {
        String myClass = this.getClass().getName();
        String noPackage = myClass.substring(myClass.lastIndexOf(46) + 1);
        String propertyName = "derby." + noPackage + ".numThreads";
        String nthread = PropertyUtil.getSystemProperty((String)propertyName);
        if (nthread != null) {
            try {
                numThreads = Integer.parseInt(nthread);
            }
            catch (NumberFormatException nfe) {
                numThreads = 1;
            }
            if (numThreads <= 0) {
                numThreads = 1;
            }
        }
        if (numThreads == 1) {
            super.runTests();
        } else {
            int i;
            int i2;
            TestThreads = new Thread[numThreads];
            TestObjects = new T_MultiThreadedIterations[numThreads];
            inError = false;
            for (i2 = 0; i2 < numThreads; ++i2) {
                T_MultiThreadedIterations.TestObjects[i2] = this.newTestObject();
                T_MultiThreadedIterations.TestObjects[i2].out = this.out;
                T_MultiThreadedIterations.TestThreads[i2] = new Thread((Runnable)TestObjects[i2], "Thread_" + i2);
            }
            TestObjects[0].setupTest();
            T_MultiThreadedIterations.TestObjects[0].threadNumber = 0;
            for (i2 = 1; i2 < numThreads; ++i2) {
                T_MultiThreadedIterations.TestObjects[i2].threadNumber = i2;
                TestObjects[i2].joinSetupTest();
            }
            propertyName = "derby." + noPackage + ".iterations";
            String iter = PropertyUtil.getSystemProperty((String)propertyName);
            if (iter != null) {
                try {
                    iterations = Integer.parseInt(iter);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (iterations <= 0) {
                    iterations = 1;
                }
            }
            for (i = 0; i < numThreads; ++i) {
                TestThreads[i].start();
            }
            try {
                for (i = 0; i < numThreads; ++i) {
                    TestThreads[i].join();
                }
            }
            catch (InterruptedException ie) {
                throw T_Fail.exceptionFail(ie);
            }
            for (i = 0; i < numThreads; ++i) {
                if (T_MultiThreadedIterations.TestObjects[i].error == null) continue;
                throw T_Fail.exceptionFail(T_MultiThreadedIterations.TestObjects[i].error);
            }
        }
    }

    @Override
    public void run() {
        int i;
        String threadName = "[" + Thread.currentThread().getName() + "] ";
        this.out.println(threadName + "started");
        try {
            for (i = 0; i < iterations; ++i) {
                Runtime.getRuntime().gc();
                long btm = Runtime.getRuntime().totalMemory();
                long bfm = Runtime.getRuntime().freeMemory();
                long bum = btm - bfm;
                long start = System.currentTimeMillis();
                this.runTestSet();
                long end = System.currentTimeMillis();
                Runtime.getRuntime().gc();
                long atm = Runtime.getRuntime().totalMemory();
                long afm = Runtime.getRuntime().freeMemory();
                long aum = atm - afm;
                this.out.println(threadName + "Iteration " + i + " took " + (end - start) + "ms");
                this.out.println(threadName + "Total memory increased by " + (atm - btm) + " is " + atm);
                this.out.println(threadName + "Used  memory increased by " + (aum - bum) + " is " + aum);
            }
        }
        catch (ThreadDeath death) {
            this.out.println(threadName + "caught thread death, printing stack");
            death.printStackTrace(this.out.getPrintWriter());
            Thread.dumpStack();
            throw death;
        }
        catch (Throwable t) {
            this.error = t;
        }
        if (this.error == null) {
            this.out.println(threadName + "finished with no error");
        } else if (!inError) {
            inError = true;
            this.error.printStackTrace(this.out.getPrintWriter());
            for (i = 0; i < numThreads; ++i) {
                if (this == TestObjects[i]) continue;
                TestThreads[i].interrupt();
            }
        }
    }

    protected abstract void joinSetupTest() throws T_Fail;

    protected abstract T_MultiThreadedIterations newTestObject();

    protected int getNumThreads() {
        return numThreads;
    }
}

