/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;

public class DeadlockWatchdog
implements Runnable {
    private boolean stopped = false;
    private long timeout;

    public DeadlockWatchdog(long timeout) {
        this.timeout = timeout;
    }

    public synchronized void start() {
        this.stopped = false;
        Thread t = new Thread((Runnable)this, "WATCHDOG");
        t.setDaemon(true);
        t.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    @Override
    public synchronized void run() {
        long now;
        long until = System.currentTimeMillis() + this.timeout;
        while (!this.stopped && until > (now = System.currentTimeMillis())) {
            try {
                this.wait(until - now);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.stopped) {
            try {
                boolean res = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws IOException, MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException {
                        return DeadlockWatchdog.this.checkForDeadlock();
                    }
                });
                if (res) {
                    System.err.println("Deadlock detected");
                    System.exit(1);
                }
            }
            catch (Exception x) {
                System.err.println("Watchdog failed: " + x.toString());
                System.exit(1);
            }
        }
    }

    boolean checkForDeadlock() throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] findDeadlockedThreads = bean.findDeadlockedThreads();
        return null != findDeadlockedThreads && 0 != findDeadlockedThreads.length;
    }
}

