/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class MadhareTest
extends BaseJDBCTestCase {
    public MadhareTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("MadhareTest Test");
        return TestConfiguration.defaultSuite(MadhareTest.class);
    }

    public void testBasicMadhare() throws SQLException {
        this.setAutoCommit(false);
        Statement st = this.createStatement();
        st.executeUpdate("create table t( i int )");
        st.executeUpdate("insert into t(i) values (1956)");
        ResultSet rs = st.executeQuery("select i from t");
        JDBC.assertFullResultSet(rs, new String[][]{{"1956"}});
        st.executeUpdate("create table s (i int, n int, t int, e int, g int, r int)");
        st.executeUpdate("insert into s (i,r,t,n,g,e) values (1,6,3,2,5,4)");
        st.executeUpdate("insert into s values (10,11,12,13,14,15)");
        rs = st.executeQuery("select i from s");
        String[][] expectedResultSet = new String[][]{{"1"}, {"10"}};
        JDBC.assertFullResultSet(rs, expectedResultSet);
        rs = st.executeQuery("select n,e,r,i,t,g from s");
        expectedResultSet = new String[][]{{"2", "4", "6", "1", "3", "5"}, {"11", "13", "15", "10", "12", "14"}};
        JDBC.assertFullResultSet(rs, expectedResultSet);
        rs = st.executeQuery("select 20,n,22,e,24,r from s");
        expectedResultSet = new String[][]{{"20", "2", "22", "4", "24", "6"}, {"20", "11", "22", "13", "24", "15"}};
        JDBC.assertFullResultSet(rs, expectedResultSet);
        PreparedStatement pst = this.prepareStatement("select i,n,t,e,g,r from s");
        rs = pst.executeQuery();
        expectedResultSet = new String[][]{{"1", "2", "3", "4", "5", "6"}, {"10", "11", "12", "13", "14", "15"}};
        JDBC.assertFullResultSet(rs, expectedResultSet);
        rs = pst.executeQuery();
        JDBC.assertFullResultSet(rs, expectedResultSet);
        pst.close();
        st.executeUpdate("create table r(s smallint, i int)");
        st.executeUpdate("insert into r values (23,2)");
        rs = st.executeQuery("select s,i from r");
        JDBC.assertFullResultSet(rs, new String[][]{{"23", "2"}});
        st.executeUpdate("drop table r");
        st.executeUpdate("drop table s");
        st.executeUpdate("drop table t");
        st.close();
    }
}

