/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobReclamationTest
extends BaseJDBCTestCase {
    private static final int NUM_THREADS = 2;
    private static int expectedNumAllocated = 5;

    public ClobReclamationTest(String name) {
        super(name);
    }

    public void testMultiThreadedUpdate(final boolean lockTable, boolean updateSingleRow) throws SQLException, InterruptedException {
        int i;
        Connection conn = this.getConnection();
        final String updateString = Formatters.repeatChar("a", 33000);
        Thread[] threads = new Thread[2];
        for (i = 0; i < 2; ++i) {
            final int key = updateSingleRow ? 1 : i + 1;
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        Connection conn = ClobReclamationTest.this.openDefaultConnection();
                        conn.setAutoCommit(false);
                        ClobReclamationTest.fiveHundredUpdates(conn, updateString, key, lockTable);
                    }
                    catch (SQLException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
            };
        }
        for (i = 0; i < 2; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 2; ++i) {
            threads[i].join();
        }
        this.checkNumAllocatedPages("CLOBTAB", expectedNumAllocated, false);
    }

    private void checkNumAllocatedPages(String table, int expectedAlloc, boolean retry_with_sleeps) throws SQLException {
        PreparedStatement ps = this.prepareStatement("SELECT NUMALLOCATEDPAGES FROM  new org.apache.derby.diag.SpaceTable('APP',?) t WHERE CONGLOMERATENAME = ?");
        ps.setString(1, table);
        ps.setString(2, table);
        int previous_alloc_count = Integer.MAX_VALUE;
        int num_retries = 0;
        while (true) {
            ResultSet rs = ps.executeQuery();
            rs.next();
            int num_allocated_pages = rs.getInt(1);
            if (num_allocated_pages == expectedAlloc) break;
            if (retry_with_sleeps) {
                block9: {
                    if (num_allocated_pages < previous_alloc_count) {
                        ++num_retries;
                        try {
                            if (num_retries <= 1) {
                                Thread.sleep(10000L);
                                break block9;
                            }
                            Thread.sleep(60000 * num_retries);
                        }
                        catch (Exception exception) {}
                    } else {
                        ClobReclamationTest.assertTrue((String)("Fail with retries -- num_allocated_pages:" + num_allocated_pages + " == expectedAlloc: " + expectedAlloc + " previous_alloc_count: " + previous_alloc_count + " num_retries: " + num_retries), (num_allocated_pages == expectedAlloc ? 1 : 0) != 0);
                    }
                }
                if (num_retries > 1) {
                    previous_alloc_count = num_allocated_pages;
                }
            } else {
                ClobReclamationTest.assertTrue((String)("Fail, no retries -- num_allocated_pages:" + num_allocated_pages + " > expectedAlloc: " + expectedAlloc), (num_allocated_pages == expectedAlloc ? 1 : 0) != 0);
            }
            rs.close();
        }
    }

    private void checkNumFreePages(String table, int expectedFree) throws SQLException {
        PreparedStatement ps = this.prepareStatement("SELECT NUMFREEPAGES FROM  new org.apache.derby.diag.SpaceTable('APP',?) t WHERE CONGLOMERATENAME = ?");
        ps.setString(1, table);
        ps.setString(2, table);
        ResultSet rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"" + expectedFree}});
    }

    private void checkNumFreePagesMax(String table, int expectedFreeMax) throws SQLException {
        PreparedStatement ps = this.prepareStatement("SELECT NUMFREEPAGES FROM  new org.apache.derby.diag.SpaceTable('APP',?) t WHERE CONGLOMERATENAME = ?");
        ps.setString(1, table);
        ps.setString(2, table);
        ResultSet rs = ps.executeQuery();
        rs.next();
        int numfreerows = rs.getInt(1);
        ClobReclamationTest.assertTrue((String)("Fail -- numfreerows:" + numfreerows + " > expectedFreeMax: " + expectedFreeMax), (numfreerows < expectedFreeMax ? 1 : 0) != 0);
        rs.close();
        ps.close();
    }

    private static void fiveHundredUpdates(Connection conn, String updateString, int key, boolean lockTable) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("UPDATE CLOBTAB SET C = ? WHERE I = ?");
        for (int i = 0; i < 500; ++i) {
            if (lockTable) {
                Statement s = conn.createStatement();
                s.executeUpdate("LOCK TABLE CLOBTAB IN EXCLUSIVE MODE");
            }
            ps.setString(1, updateString);
            ps.setInt(2, key);
            ps.executeUpdate();
            conn.commit();
        }
    }

    public void testMultiThreadedUpdateRowLocking() throws SQLException, InterruptedException {
        this.testMultiThreadedUpdate(false, false);
    }

    public void xtestMultiThreadedUpdateTableLocking() throws SQLException, InterruptedException {
        this.testMultiThreadedUpdate(true, false);
    }

    public void xtestMultiThreadUpdateSingleRow() throws SQLException, InterruptedException {
        this.testMultiThreadedUpdate(false, true);
    }

    public void testReclamationOnRollback() throws SQLException {
        this.setAutoCommit(false);
        String insertString = Formatters.repeatChar("a", 33000);
        PreparedStatement ps = this.prepareStatement("INSERT INTO CLOBTAB2 VALUES(?,?)");
        for (int i = 0; i < 500; ++i) {
            ps.setInt(1, i);
            ps.setString(2, insertString);
            ps.executeUpdate();
            this.rollback();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkNumAllocatedPages("CLOBTAB2", 1, true);
    }

    public void testBlobLinkedListReclamationOnRollback() throws SQLException {
        this.setAutoCommit(false);
        int clob_length = 200000;
        String insertString = Formatters.repeatChar("a", 200000);
        PreparedStatement ps = this.prepareStatement("INSERT INTO CLOBTAB3 VALUES(?,?)");
        int numrows = 500;
        for (int i = 0; i < numrows; ++i) {
            ps.setInt(1, i);
            ps.setString(2, insertString);
            ps.executeUpdate();
            this.rollback();
        }
        ps.close();
        this.checkNumAllocatedPages("CLOBTAB3", 1, true);
        CallableStatement call_compress = this.prepareCall("CALL SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, 1, 1, 1)");
        call_compress.setString(1, "APP");
        call_compress.setString(2, "CLOBTAB3");
        call_compress.executeUpdate();
        this.checkNumAllocatedPages("CLOBTAB3", 1, false);
        this.checkNumFreePages("CLOBTAB3", 0);
        this.commit();
    }

    public static Test suite() {
        Test suite = TestConfiguration.embeddedSuite(ClobReclamationTest.class);
        return new CleanDatabaseTestSetup(suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                SanityManager.DEBUG_SET((String)"DaemonTrace");
                SanityManager.DEBUG_SET((String)"verbose_heap_post_commit");
                Connection conn = s.getConnection();
                s.executeUpdate("CREATE TABLE CLOBTAB (I INT  PRIMARY KEY NOT NULL, c CLOB)");
                PreparedStatement ps = conn.prepareStatement("INSERT INTO CLOBTAB VALUES(?,?)");
                String insertString = "hello";
                for (int i = 1; i <= 2; ++i) {
                    ps.setInt(1, i);
                    ps.setString(2, insertString);
                    ps.executeUpdate();
                }
                s.executeUpdate("CREATE TABLE CLOBTAB2 (I INT, C CLOB)");
                s.executeUpdate("CREATE TABLE CLOBTAB3 (I INT, C CLOB)");
            }

            @Override
            protected void tearDown() throws Exception {
                SanityManager.DEBUG_CLEAR((String)"DaemonTrace");
                super.tearDown();
            }
        };
    }
}

