/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public class BackupRestoreTest
extends BaseJDBCTestCase {
    public BackupRestoreTest(String name) {
        super(name);
    }

    public void testDerby3875() throws SQLException, IOException {
        BackupRestoreTest.println("Creating database");
        this.getConnection();
        BackupRestoreTest.println("Backing up database");
        String dbBackup = SupportFilesSetup.getReadWrite("dbbackup").getPath();
        CallableStatement cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        cs.setString(1, dbBackup);
        cs.execute();
        cs.close();
        this.getTestConfiguration().shutdownEngine();
        File dataDir = new File("system/" + this.getTestConfiguration().getDefaultDatabaseName(), "seg0");
        File df = new File(dataDir, "c10.dat");
        BackupRestoreTest.assertTrue((String)("File to corrupt doesn't exist: " + df.getPath()), (boolean)PrivilegedFileOpsForTests.exists(df));
        BackupRestoreTest.println("Corrupting data file");
        byte[] zeros = new byte[(int)PrivilegedFileOpsForTests.length(df)];
        FileOutputStream fout = PrivilegedFileOpsForTests.getFileOutputStream(df);
        fout.write(zeros);
        fout.flush();
        fout.close();
        try {
            BackupRestoreTest.println("Rebooting corrupted database");
            this.getConnection();
            BackupRestoreTest.fail((String)"Reboot of currupted database should have failed");
        }
        catch (SQLException sqle) {
            BackupRestoreTest.assertSQLState("XJ040", sqle);
        }
        BackupRestoreTest.println("Restoring database");
        String[] tmp = Utilities.split(this.getTestConfiguration().getDefaultDatabaseName(), '/');
        String dbName = tmp[tmp.length - 1];
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "restoreFrom=" + dbBackup + "/" + dbName);
        BackupRestoreTest.assertNotNull((Object)ds.getConnection());
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite(BackupRestoreTest.class);
        return new SupportFilesSetup((Test)TestConfiguration.singleUseDatabaseDecorator((Test)suite));
    }
}

