/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;

public class BackupPathTests {
    public static void main(String[] argv) throws Throwable {
        try {
            ij.getPropertyArg((String[])argv);
            Connection conn = ij.startJBMS();
            conn.setAutoCommit(true);
            Statement stmt = conn.createStatement();
            stmt.execute("call sqlj.install_jar('extin/brtestjar.jar', 'math_routines', 0)");
            stmt.close();
            BackupPathTests.logMsg("Begin Backup Path Tests");
            String derbyHome = System.getProperty("derby.system.home");
            String dbHome = derbyHome + File.separator + "wombat";
            BackupPathTests.logMsg("case1 : try Backup with backup path as database dir");
            try {
                BackupPathTests.performBackup(conn, dbHome);
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState() != null && sqle.getSQLState().equals("XSRSC")) {
                    BackupPathTests.logMsg("Backup in to a database dir failed");
                }
                throw sqle;
            }
            BackupPathTests.logMsg("End test case1");
            BackupPathTests.logMsg("case2 : Backup with backup path as database jar dir");
            String jarDir = dbHome + File.separator + "jar";
            BackupPathTests.performBackup(conn, jarDir);
            BackupPathTests.logMsg("End test case 2");
            BackupPathTests.logMsg("case 3: Backup again into the same db jar dir location");
            BackupPathTests.performBackup(conn, jarDir);
            BackupPathTests.logMsg("End test case 3");
            BackupPathTests.logMsg("case 4: Backup using an absolute path");
            String absBackupPath = new File("extinout/backupPathTests").getAbsolutePath();
            BackupPathTests.performBackup(conn, absBackupPath);
            BackupPathTests.logMsg("End test case 4");
            conn.close();
            BackupPathTests.logMsg("End Backup Path Tests");
        }
        catch (SQLException sqle) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
            sqle.printStackTrace(System.out);
        }
    }

    private static void performBackup(Connection conn, String backupPath) throws SQLException {
        CallableStatement backupStmt = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        backupStmt.setString(1, backupPath);
        backupStmt.execute();
        backupStmt.close();
    }

    private static void logMsg(String str) {
        System.out.println(str);
    }
}

