/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UDTPermsTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String FRANK = "FRANK";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH", "FRANK"};

    public UDTPermsTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = (BaseTestSuite)TestConfiguration.embeddedSuite(UDTPermsTest.class);
        CleanDatabaseTestSetup cleanTest = new CleanDatabaseTestSetup((Test)suite);
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthentication((Test)cleanTest, LEGAL_USERS, "udtPermissions");
        Test authorizedTest = TestConfiguration.sqlAuthorizationDecorator(authenticatedTest);
        return authorizedTest;
    }

    public void test_001_basicGrant() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        Connection aliceConnection = this.openUserConnection(ALICE);
        this.goodStatement(ruthConnection, "create type price_ruth_01_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(ruthConnection, "create function makePrice_ruth_01( )\nreturns price_ruth_01_a\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        this.goodStatement(ruthConnection, "create table t_ruth_01( a price_ruth_01_a )\n");
        this.goodStatement(ruthConnection, "insert into t_ruth_01( a ) values ( makePrice_ruth_01() )\n");
        this.goodStatement(ruthConnection, "grant select on t_ruth_01 to public\n");
        this.goodStatement(ruthConnection, "grant execute on function makePrice_ruth_01 to public\n");
        this.goodStatement(ruthConnection, "select * from ruth.t_ruth_01\n");
        this.goodStatement(ruthConnection, "values( ruth.makePrice_ruth_01() )\n");
        this.expectExecutionError(aliceConnection, "42504", "create table t_alice_01( a ruth.price_ruth_01_a )\n");
        this.expectExecutionError(aliceConnection, "42504", "create function makePrice_alice_01_a( )\nreturns ruth.price_ruth_01_a\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        this.expectExecutionError(aliceConnection, "42504", "create function makePrice_alice_01_b( a ruth.price_ruth_01_a )\nreturns int\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        this.assertResults(dboConnection, "select * from ruth.t_ruth_01", new String[][]{{"Price( USD, 1, XXX )"}}, false);
        this.assertResults(dboConnection, "values( ruth.makePrice_ruth_01() )\n", new String[][]{{"Price( USD, 1, XXX )"}}, false);
        this.goodStatement(dboConnection, "create table t_dbo_01( a ruth.price_ruth_01_a )\n");
        this.goodStatement(dboConnection, "insert into t_dbo_01( a ) values ( ruth.makePrice_ruth_01() )\n");
        this.assertResults(dboConnection, "select * from t_dbo_01\n", new String[][]{{"Price( USD, 1, XXX )"}}, false);
        this.goodStatement(dboConnection, "drop table t_dbo_01\n");
        this.goodStatement(ruthConnection, "grant usage on type price_ruth_01_a to public\n");
        this.assertResults(aliceConnection, "select * from ruth.t_ruth_01", new String[][]{{"Price( USD, 1, XXX )"}}, false);
        this.goodStatement(aliceConnection, "create table t_alice_01( a ruth.price_ruth_01_a )\n");
        this.goodStatement(aliceConnection, "insert into t_alice_01( a ) values ( ruth.makePrice_ruth_01() )\n");
        this.assertResults(aliceConnection, "select * from t_alice_01\n", new String[][]{{"Price( USD, 1, XXX )"}}, false);
    }

    public void test_002_basicRevoke() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        Connection aliceConnection = this.openUserConnection(ALICE);
        this.goodStatement(ruthConnection, "create type price_ruth_02_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.expectCompilationError(ruthConnection, "42X01", "revoke usage on type price_ruth_02_a from ruth\n");
        this.expectCompilationError(ruthConnection, "42509", "revoke usage on type price_ruth_02_a from ruth restrict\n");
        String grantUsage = "grant usage on type price_ruth_02_a to alice\n";
        String revokeUsage = "revoke usage on type price_ruth_02_a from alice restrict\n";
        String createStatement = "create function makePrice_alice_02( )\nreturns ruth.price_ruth_02_a\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n";
        String dropStatement = "drop function makePrice_alice_02\n";
        String badRevokeSQLState = "X0Y30";
        this.verifyRevokePrivilege(ruthConnection, aliceConnection, grantUsage, revokeUsage, createStatement, dropStatement, badRevokeSQLState);
        createStatement = "create table t_alice_02( a ruth.price_ruth_02_a )\n";
        dropStatement = "drop table t_alice_02\n";
        badRevokeSQLState = "X0Y29";
        this.verifyRevokePrivilege(ruthConnection, aliceConnection, grantUsage, revokeUsage, createStatement, dropStatement, badRevokeSQLState);
        createStatement = "create view v_alice_02( a ) as select cast (null as ruth.price_ruth_02_a ) from sys.systables\n";
        dropStatement = "drop view v_alice_02\n";
        badRevokeSQLState = "X0Y23";
        this.verifyRevokePrivilege(ruthConnection, aliceConnection, grantUsage, revokeUsage, createStatement, dropStatement, badRevokeSQLState);
        this.goodStatement(aliceConnection, "create table t_03_a( a int )\n");
        this.goodStatement(aliceConnection, "create table t_03_b( a int )\n");
        createStatement = "create trigger trig_03_a after insert on t_03_a\n  insert into t_03_b( a ) select a from t_03_a where ( cast( null as ruth.price_ruth_02_a ) ) is not null\n";
        dropStatement = "drop trigger trig_03_a\n";
        badRevokeSQLState = "X0Y25";
        this.verifyRevokePrivilege(ruthConnection, aliceConnection, grantUsage, revokeUsage, createStatement, dropStatement, badRevokeSQLState);
    }

    public void test_003_dropSchema() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection frankConnection = this.openUserConnection(FRANK);
        this.goodStatement(frankConnection, "create function f_frank_03( a int ) returns int language java parameter style java no sql external name 'foo.bar.Wibble'\n");
        this.expectExecutionError(dboConnection, "X0Y54", "drop schema frank restrict\n");
        this.goodStatement(frankConnection, "drop function f_frank_03\n");
        this.goodStatement(frankConnection, "create type price_frank_03_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.expectExecutionError(dboConnection, "X0Y54", "drop schema frank restrict\n");
        this.goodStatement(frankConnection, "drop type price_frank_03_a restrict\n");
        this.goodStatement(dboConnection, "drop schema frank restrict\n");
    }
}

