/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;

public class SelectivityTest
extends BaseJDBCTestCase {
    public SelectivityTest(String name) {
        super(name);
    }

    public static Test suite() {
        Properties props = new Properties();
        props.setProperty("derby.storage.indexStats.auto", "false");
        props.setProperty("derby.language.statementCacheSize", "0");
        DatabasePropertyTestSetup test = new DatabasePropertyTestSetup((Test)new BaseTestSuite(SelectivityTest.class), props, true);
        return new CleanDatabaseTestSetup((Test)test){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("create table two (x int)");
                s.executeUpdate("insert into two values (1),(2)");
                s.executeUpdate("create table ten (x int)");
                s.executeUpdate("insert into ten values (1),(2),(3),(4),(5),(6),(7),(8),(9),(10)");
                s.executeUpdate("create table twenty (x int)");
                s.executeUpdate("insert into twenty values (1),(2),(3),(4),(5),(6),(7),(8),(9),(10),(11),(12),(13),(14),(15),(16),(17),(18),(19),(20)");
                s.executeUpdate("create table hundred (x int generated always as identity, dc int)");
                s.executeUpdate("insert into hundred (dc) select t1.x from ten t1, ten t2");
                s.executeUpdate("create table template (id int not null generated always as identity, two int, twenty int, hundred int)");
                s.executeUpdate("insert into template (two, twenty, hundred) select two.x, twenty.x, hundred.x from two, twenty, hundred");
                s.executeUpdate("create index template_two on template(two)");
                s.executeUpdate("create index template_twenty on template(twenty)");
                s.executeUpdate("create index template_22 on template(twenty,two)");
                s.executeUpdate("create unique index template_id on template(id)");
                s.executeUpdate("create index template_102 on template(hundred,two)");
                s.executeUpdate("create table test (id int, two int, twenty int, hundred int)");
                s.executeUpdate("create index test_id on test(id)");
                s.executeUpdate("insert into test select * from template");
                s.executeUpdate("create view showstats as select cast (conglomeratename as varchar(20)) indexname, cast (statistics as varchar(40)) stats, creationtimestamp createtime, colcount ncols from sys.sysstatistics, sys.sysconglomerates where conglomerateid = referenceid");
                ResultSet statsrs = s.executeQuery("select indexname, stats, ncols from showstats order by indexname, stats, createtime, ncols");
                JDBC.assertFullResultSet(statsrs, new String[][]{{"TEMPLATE_102", "numunique= 100 numrows= 4000", "1"}, {"TEMPLATE_102", "numunique= 200 numrows= 4000", "2"}, {"TEMPLATE_22", "numunique= 20 numrows= 4000", "1"}, {"TEMPLATE_22", "numunique= 40 numrows= 4000", "2"}, {"TEMPLATE_TWENTY", "numunique= 20 numrows= 4000", "1"}, {"TEMPLATE_TWO", "numunique= 2 numrows= 4000", "1"}});
                s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEMPLATE',null)");
                s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST',null)");
                statsrs = s.executeQuery("select indexname, stats, ncols from showstats order by indexname, stats, createtime, ncols");
                JDBC.assertFullResultSet(statsrs, new String[][]{{"TEMPLATE_102", "numunique= 100 numrows= 4000", "1"}, {"TEMPLATE_102", "numunique= 200 numrows= 4000", "2"}, {"TEMPLATE_22", "numunique= 20 numrows= 4000", "1"}, {"TEMPLATE_22", "numunique= 40 numrows= 4000", "2"}, {"TEMPLATE_TWENTY", "numunique= 20 numrows= 4000", "1"}, {"TEMPLATE_TWO", "numunique= 2 numrows= 4000", "1"}, {"TEST_ID", "numunique= 4000 numrows= 4000", "1"}});
                s.executeUpdate("create table t1 (id int generated always as identity, two int, twenty int, hundred varchar(3))");
                s.executeUpdate("insert into t1 (hundred, twenty, two) select CAST(CHAR(hundred.x) AS VARCHAR(3)), twenty.x, two.x from hundred, twenty, two");
                s.executeUpdate("create table t2 (id int generated always as identity, two int, twenty int, hundred varchar(3))");
                s.executeUpdate("insert into t2 (hundred, twenty, two) select CAST(CHAR(hundred.x) AS VARCHAR(3)) , twenty.x, two.x from hundred, twenty, two");
                s.executeUpdate("create table t3 (id int generated always as identity, two int, twenty int, hundred varchar(3))");
                s.executeUpdate("insert into t3 (hundred, twenty, two) select CAST(CHAR(hundred.x) AS VARCHAR(3)), twenty.x, two.x from hundred, twenty, two");
                s.executeUpdate("create index t1_hundred on t1(hundred)");
                s.executeUpdate("create index t1_two_twenty on t1(two,twenty)");
                s.executeUpdate("create index t1_twenty_hundred on t1(twenty, hundred)");
                s.executeUpdate("create index t2_hundred on t2(hundred)");
                s.executeUpdate("create index t2_two_twenty on t2(two,twenty)");
                s.executeUpdate("create index t2_twenty_hundred on t2(twenty, hundred)");
                s.executeUpdate("create index t3_hundred on t3(hundred)");
                s.executeUpdate("create index t3_two_twenty on t3(two,twenty)");
                s.executeUpdate("create index t3_twenty_hundred on t3(twenty, hundred)");
                s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',null)");
                s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T2',null)");
                s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T3',null)");
                statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'T1%' order by indexname, stats");
                JDBC.assertFullResultSet(statsrs, new String[][]{{"T1_HUNDRED", "numunique= 100 numrows= 4000", "1"}, {"T1_TWENTY_HUNDRED", "numunique= 20 numrows= 4000", "1"}, {"T1_TWENTY_HUNDRED", "numunique= 2000 numrows= 4000", "2"}, {"T1_TWO_TWENTY", "numunique= 2 numrows= 4000", "1"}, {"T1_TWO_TWENTY", "numunique= 40 numrows= 4000", "2"}});
                statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'T2%' order by indexname, stats");
                JDBC.assertFullResultSet(statsrs, new String[][]{{"T2_HUNDRED", "numunique= 100 numrows= 4000", "1"}, {"T2_TWENTY_HUNDRED", "numunique= 20 numrows= 4000", "1"}, {"T2_TWENTY_HUNDRED", "numunique= 2000 numrows= 4000", "2"}, {"T2_TWO_TWENTY", "numunique= 2 numrows= 4000", "1"}, {"T2_TWO_TWENTY", "numunique= 40 numrows= 4000", "2"}});
                statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'T3%' order by indexname, stats");
                JDBC.assertFullResultSet(statsrs, new String[][]{{"T3_HUNDRED", "numunique= 100 numrows= 4000", "1"}, {"T3_TWENTY_HUNDRED", "numunique= 20 numrows= 4000", "1"}, {"T3_TWENTY_HUNDRED", "numunique= 2000 numrows= 4000", "2"}, {"T3_TWO_TWENTY", "numunique= 2 numrows= 4000", "1"}, {"T3_TWO_TWENTY", "numunique= 40 numrows= 4000", "2"}});
                s.executeUpdate("create table scratch_table(id int, two int, twenty int, hundred int)");
                s.executeUpdate("insert into scratch_table select id, two, twenty, CAST(CHAR(hundred) AS INTEGER) from t1");
                s.executeUpdate("create index st_all on scratch_table(two, twenty, hundred)");
                s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','SCRATCH_TABLE',null)");
                s.executeUpdate("create table complex(id int generated always as identity, two int, twenty int, hundred int, a int, b int)");
                s.executeUpdate("insert into complex (two, twenty, hundred, a, b) select two.x, twenty.x, hundred.x, two.x, twenty.x from two, twenty, hundred");
                s.executeUpdate("create index complexind on complex(two, twenty, hundred, a, b)");
                s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','COMPLEX',null)");
            }
        };
    }

    public void testSingleColumnSelectivity() throws SQLException {
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEMPLATE',NULL)");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST',NULL)");
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed\ntest, template where test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 8020012.5);
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=hash \nwhere test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 8020012.5);
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedHashJoin());
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 8020012.5);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertFalse((boolean)rtsp.usedHashJoin());
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_two \nwhere test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 8020012.5);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWO"));
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_twenty \nwhere test.twenty = template.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 802001.25);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWENTY"));
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_22 \nwhere test.twenty = template.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 802001.25);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_22"));
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.twenty = template.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 802001.25);
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_102 \nwhere test.hundred = template.hundred and test.id <= 100").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3924.9);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEST", "TEST_ID"));
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_102"));
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.hundred = template.hundred and test.id <= 100").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3924.9);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEST", "TEST_ID"));
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=hash, index=null \nwhere test.hundred = template.hundred and test.id <= 100").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3924.9);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedHashJoin());
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEST", "TEST_ID"));
    }

    public void testMultiPredicate() throws SQLException {
        this.setAutoCommit(false);
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST',NULL)");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEMPLATE',NULL)");
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=hash, index=null \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 401000.625);
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedHashJoin());
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_two \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 401000.625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWO"));
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_twenty \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 401000.625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWENTY"));
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_22 \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 401000.625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_22"));
        s.executeUpdate("drop index template_22");
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=hash, index=null \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 401000.625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedHashJoin());
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_two \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 401000.625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWO"));
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_twenty \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 401000.625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWENTY"));
        s.executeUpdate("drop index template_two");
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 80200.12500000001);
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_twenty \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 80200.12500000001);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWENTY"));
        s.executeUpdate("drop index template_twenty");
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.twenty = template.twenty and test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 160400.25000000003);
        this.rollback();
    }

    public void testTwoWayJoins() throws SQLException {
        this.setAutoCommit(false);
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEMPLATE',NULL)");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST',NULL)");
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.hundred = template.hundred and 1 = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 80200.125);
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_102 \nwhere test.hundred = template.hundred and 1 = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 80200.125);
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_102"));
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=null \nwhere test.hundred = template.hundred and 1 = template.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 8020.0125);
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed \ntest, template --DERBY-PROPERTIES joinStrategy=nestedLoop, index=template_102 \nwhere test.hundred = template.hundred and 1 = template.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 8020.0125);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_102"));
    }

    public void testThreeWayJoins() throws SQLException {
        this.setAutoCommit(false);
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',NULL)");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T2',NULL)");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T3',NULL)");
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2, t3 where t1.hundred = t2.hundred and t1.twenty = t2.twenty and t2.two = t3.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 1.606007503125E7);
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 2, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 2, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T3 using index T3_TWO_TWENTY", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2, t3 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3212015.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2, t3 --DERBY-PROPERTIES joinStrategy=hash \nwhere t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3212015.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2, t3 --DERBY-PROPERTIES joinStrategy=nestedLoop \nwhere t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3212015.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T3", "T3_HUNDRED"));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched=All", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2 --DERBY-PROPERTIES joinStrategy=hash \n, t3 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3212015.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2 --DERBY-PROPERTIES joinStrategy=hash \n, t3 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3212015.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt2, t3, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3212015.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt3, t2, t1 --DERBY-PROPERTIES joinStrategy=hash \nwhere t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3212015.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt3, t2, t1 --DERBY-PROPERTIES joinStrategy=nestedLoop \nwhere t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3212015.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T1", "T1_HUNDRED"));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched=All", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt2, t3 --DERBY-PROPERTIES joinStrategy=nestedLoop \n, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3212015.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T3", "T3_HUNDRED"));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched=All", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt3, t2 --DERBY-PROPERTIES joinStrategy=hash \n, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3212015.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt2, t3, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred and t1.hundred='1'").close();
        SelectivityTest.checkEstimatedRowCount(conn, 30458.025);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T2", "T2_HUNDRED"));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched=All", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T1", "T1_HUNDRED"));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched=All", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt2, t3, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t1.hundred = t3.hundred and t2.hundred = t3.hundred").close();
        SelectivityTest.checkEstimatedRowCount(conn, 3212015.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T3", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt2, t3, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 1.606007503125E7);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 2, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T3 using index T3_TWO_TWENTY", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 1}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t2, t3 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 1.606007503125E7);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 2, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T3 using index T3_TWO_TWENTY", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 1}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt2, t1, t3 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 1.606007503125E7);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 2, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T3 using index T3_TWO_TWENTY", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 1}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, t3, t2 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 1.606007503125E7);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T3", "T3_TWO_TWENTY"));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 1}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 2, 3}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt3, t2, t1 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 1.606007503125E7);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T3", "T3_TWO_TWENTY"));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 1}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 2, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES joinOrder=fixed \nt3, t1, t2 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 1.606007503125E7);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T3", "T3_TWO_TWENTY"));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 1}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 2, 3}", 1));
        s.executeQuery("select t1.id from --DERBY-PROPERTIES useStatistics=false, joinOrder=fixed \nt3, t1, t2 where t1.hundred = t2.hundred and t2.two = t3.two and t2.twenty = t3.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 6.4240300125000015E7);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T3", "T3_TWO_TWENTY"));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 1}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Table Scan ResultSet for T1", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={0, 3}", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T2", 1));
        SelectivityTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched={1, 2, 3}", 1));
    }

    public void testScratch() throws SQLException {
        this.setAutoCommit(false);
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',NULL)");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','SCRATCH_TABLE',NULL)");
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        s.executeQuery("select s.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, scratch_table s where t1.two = s.two and s.hundred = CAST(CHAR(t1.hundred) AS INTEGER)").close();
        SelectivityTest.checkEstimatedRowCount(conn, 802001.25);
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedHashJoin());
        s.executeQuery("select s.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, scratch_table s where t1.twenty = s.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 1604002.5);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T1", "T1_TWO_TWENTY"));
        SelectivityTest.assertTrue((boolean)rtsp.usedHashJoin());
        s.executeQuery("select s.id from --DERBY-PROPERTIES joinOrder=fixed \nt1, scratch_table s where t1.twenty = s.twenty and s.hundred = CAST(CHAR(t1.hundred) AS INTEGER)").close();
        SelectivityTest.checkEstimatedRowCount(conn, 160400.25);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T1", "T1_TWENTY_HUNDRED"));
        SelectivityTest.assertTrue((boolean)rtsp.usedHashJoin());
    }

    public void testStatMatcher() throws SQLException {
        this.setAutoCommit(false);
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',NULL)");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T2',NULL)");
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        s.executeQuery("select t1.id from t1, t2 where t1.two = t2.two and t1.twenty = t2.twenty and t1.hundred = t2.hundred").close();
        SelectivityTest.checkEstimatedRowCount(conn, 4010.00625);
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedHashJoin());
        s.executeQuery("select t1.id from t1, t2 where t1.two = t2.two and t1.hundred = t2.hundred and t1.twenty = t2.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 4010.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedHashJoin());
        s.executeQuery("select t1.id from t1, t2 where t1.hundred = t2.hundred and t1.twenty = t2.twenty and t1.two = t2.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 4010.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedHashJoin());
        s.executeQuery("select t1.id from t1, t2 where t1.hundred = t2.hundred and t1.two = t2.two and t1.twenty = t2.twenty").close();
        SelectivityTest.checkEstimatedRowCount(conn, 4010.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedHashJoin());
        s.executeQuery("select t1.id from t1, t2 where t1.twenty = t2.twenty and t1.hundred = t2.hundred and t1.two = t2.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 4010.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedHashJoin());
        s.executeQuery("select t1.id from t1, t2 where t1.twenty = t2.twenty and t1.two = t2.two and t1.hundred = t2.hundred").close();
        SelectivityTest.checkEstimatedRowCount(conn, 4010.00625);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedHashJoin());
    }

    public void testBeetle4321() throws SQLException {
        this.setAutoCommit(false);
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','COMPLEX',NULL)");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEMPLATE',NULL)");
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        s.executeQuery("select t10.two from complex t10, template t20 where t10.two = 1 and t10.hundred = 2 and t10.a = 2 and t10.b = 2").close();
        SelectivityTest.checkEstimatedRowCount(conn, 7945.92);
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("COMPLEX", "COMPLEXIND"));
        SelectivityTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TEMPLATE", "TEMPLATE_TWO"));
    }

    public void testBasic() throws SQLException {
        int i;
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        s.executeUpdate("create table tbasic1 (c1 int generated always as identity, c2 int, c3 int)");
        for (int i2 = 1; i2 < 5; ++i2) {
            for (int j = 1; j < 3; ++j) {
                for (int c = 0; c < 2; ++c) {
                    s.executeUpdate("insert into tbasic1 values (default, " + i2 + ", " + j + ")");
                }
            }
        }
        s.executeUpdate("create index t1_c1c2 on tbasic1 (c1, c2)");
        ResultSet statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'T1_C1C2%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"T1_C1C2", "numunique= 16 numrows= 16", "1"}, {"T1_C1C2", "numunique= 16 numrows= 16", "2"}});
        s.executeUpdate("drop index t1_c1c2");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'T1_C1C2%' order by indexname");
        JDBC.assertEmpty(statsrs);
        s.executeUpdate("create table tbasic2 (i int not null, vc varchar(32) not null, dt date, ch char(20), constraint pk primary key (i, vc))");
        s.executeUpdate("create index tbasic2_i on tbasic2(i)");
        s.executeUpdate("create index tbasic2_ch_dt on tbasic2(ch, dt)");
        s.executeUpdate("create index tbasic2_dt_vc on tbasic2(dt, vc)");
        s.executeUpdate("insert into tbasic2 values (1, 'one', '2001-01-01', 'one')");
        s.executeUpdate("insert into tbasic2 values (2, 'two', '2001-01-02', 'two')");
        s.executeUpdate("insert into tbasic2 values (3, 'three', '2001-01-03', 'three')");
        s.executeUpdate("insert into tbasic2 values (1, 'two', '2001-01-02', 'one')");
        s.executeUpdate("insert into tbasic2 values (1, 'three', '2001-01-03', 'one')");
        s.executeUpdate("insert into tbasic2 values (2, 'one', '2001-01-01', 'two')");
        statsrs = s.executeQuery("select conglomeratename from sys.sysconglomerates where conglomeratename like 'SQL%'");
        statsrs.next();
        String backIndName = statsrs.getString("conglomeratename");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC2','" + backIndName + "')");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'SQL%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{backIndName, "numunique= 3 numrows= 6", "1"}, {backIndName, "numunique= 6 numrows= 6", "2"}});
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC2','TBASIC2_I')");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname = 'TBASIC2_I' order by indexname");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"TBASIC2_I", "numunique= 3 numrows= 6", "1"}});
        s.executeUpdate("insert into tbasic2 values(2, 'three', '2001-01-03', 'two')");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC2',null)");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname = 'TBASIC2_I' order by indexname");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"TBASIC2_I", "numunique= 3 numrows= 7", "1"}});
        statsrs = s.executeQuery("select count(*) from (select distinct i from tbasic2) t");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"3"}});
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname = 'TBASIC2_CH_DT' order by indexname, stats");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"TBASIC2_CH_DT", "numunique= 3 numrows= 7", "1"}, {"TBASIC2_CH_DT", "numunique= 7 numrows= 7", "2"}});
        statsrs = s.executeQuery("select count(*) from (select distinct ch from tbasic2) t");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"3"}});
        statsrs = s.executeQuery("select count(*) from (select distinct ch, dt from tbasic2) t");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"7"}});
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname = 'TBASIC2_DT_VC' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"TBASIC2_DT_VC", "numunique= 3 numrows= 7", "1"}, {"TBASIC2_DT_VC", "numunique= 3 numrows= 7", "2"}});
        statsrs = s.executeQuery("select count(*) from (select distinct dt from tbasic2) t");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"3"}});
        statsrs = s.executeQuery("select count(*) from (select distinct dt, vc from tbasic2) t");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"3"}});
        statsrs = s.executeQuery("select stats, ncols from showstats where indexname like 'SQL%' order by stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"numunique= 3 numrows= 7", "1"}, {"numunique= 7 numrows= 7", "2"}});
        SelectivityTest.assertUpdateCount(s, 7, "delete from tbasic2");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC2%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"TBASIC2_CH_DT", "numunique= 3 numrows= 7", "1"}, {"TBASIC2_CH_DT", "numunique= 7 numrows= 7", "2"}, {"TBASIC2_DT_VC", "numunique= 3 numrows= 7", "1"}, {"TBASIC2_DT_VC", "numunique= 3 numrows= 7", "2"}, {"TBASIC2_I", "numunique= 3 numrows= 7", "1"}});
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC2',null)");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC2%' order by indexname, stats, ncols");
        JDBC.assertEmpty(statsrs);
        s.executeUpdate("drop table tbasic2");
        s.executeUpdate("create table tbasic3 (x int not null generated always as identity, y int not null, z int)");
        s.executeUpdate("insert into tbasic3 (y,z) values (1,1),(1,2),(1,3),(1,null),(2,1),(2,2),(2,3),(2,null)");
        s.executeUpdate("alter table tbasic3 add constraint pk_tbasic3 primary key (x,y)");
        statsrs = s.executeQuery("select conglomeratename from sys.sysconglomerates where conglomeratename like 'SQL%'");
        statsrs.next();
        backIndName = statsrs.getString("conglomeratename");
        statsrs = s.executeQuery("select stats, ncols from showstats where indexname like '" + backIndName + "' order by stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"numunique= 8 numrows= 8", "1"}, {"numunique= 8 numrows= 8", "2"}});
        s.executeUpdate("alter table tbasic3 drop constraint pk_tbasic3");
        statsrs = s.executeQuery("select stats, ncols from showstats where indexname like '" + backIndName + "' order by stats, ncols");
        JDBC.assertEmpty(statsrs);
        for (int i3 = 0; i3 < 9; ++i3) {
            s.executeUpdate("insert into tbasic3(y,z) select y,z from tbasic3");
        }
        statsrs = s.executeQuery("select count(*) from tbasic3");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"4096"}});
        s.executeUpdate("create index tbasic3_xy on tbasic3(x,y)");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC3_XY%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"TBASIC3_XY", "numunique= 4096 numrows= 4096", "1"}, {"TBASIC3_XY", "numunique= 4096 numrows= 4096", "2"}});
        s.executeUpdate("delete from tbasic3 where z is null");
        s.executeUpdate("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'TBASIC3', 0)");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC3_XY%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"TBASIC3_XY", "numunique= 3072 numrows= 3072", "1"}, {"TBASIC3_XY", "numunique= 3072 numrows= 3072", "2"}});
        s.executeUpdate("drop table tbasic3");
        s.executeUpdate("create table tbasic4 (x int, y int, z int)");
        s.executeUpdate("insert into tbasic4 values (1,1,1)");
        s.executeUpdate("insert into tbasic4 values (1,2,1)");
        s.executeUpdate("insert into tbasic4 values (1,1,2)");
        s.executeUpdate("create index tbasic4_x on tbasic4(x)");
        s.executeUpdate("create index tbasic4_xy on tbasic4(x,y)");
        s.executeUpdate("create index tbasic4_yz on tbasic4(y,z)");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC4%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"TBASIC4_X", "numunique= 1 numrows= 3", "1"}, {"TBASIC4_XY", "numunique= 1 numrows= 3", "1"}, {"TBASIC4_XY", "numunique= 2 numrows= 3", "2"}, {"TBASIC4_YZ", "numunique= 2 numrows= 3", "1"}, {"TBASIC4_YZ", "numunique= 3 numrows= 3", "2"}});
        s.executeUpdate("alter table tbasic4 drop column x");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC4%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"TBASIC4_XY", "numunique= 2 numrows= 3", "1"}, {"TBASIC4_YZ", "numunique= 2 numrows= 3", "1"}, {"TBASIC4_YZ", "numunique= 3 numrows= 3", "2"}});
        s.executeUpdate("drop table tbasic4");
        s.executeUpdate("create table tbasic6 (i int generated always as identity, j varchar(10))");
        s.executeUpdate("create index tbasic6_i on tbasic6(i)");
        s.executeUpdate("create index tbasic6_j on tbasic6(j)");
        s.executeUpdate("create index tbasic6_ji on tbasic6(j,i)");
        char[] alphabet = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i'};
        for (i = 0; i < alphabet.length - 1; ++i) {
            s.executeUpdate("insert into tbasic6 values (default, '" + alphabet[i] + "')");
        }
        for (i = 0; i < alphabet.length; ++i) {
            s.executeUpdate("insert into tbasic6 values (default, '" + alphabet[i] + "')");
        }
        for (i = 0; i < alphabet.length - 1; ++i) {
            s.executeUpdate("insert into tbasic6 values (default, '" + alphabet[i] + "')");
        }
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC6','TBASIC6_J')");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC6',NULL)");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC6%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"TBASIC6_I", "numunique= 25 numrows= 25", "1"}, {"TBASIC6_J", "numunique= 9 numrows= 25", "1"}, {"TBASIC6_JI", "numunique= 25 numrows= 25", "2"}, {"TBASIC6_JI", "numunique= 9 numrows= 25", "1"}});
        s.executeUpdate("delete from TBASIC6");
        for (i = 0; i < 17; ++i) {
            s.executeUpdate("insert into tbasic6 values (default, 'a')");
        }
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TBASIC6',NULL)");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'TBASIC6%' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"TBASIC6_I", "numunique= 17 numrows= 17", "1"}, {"TBASIC6_J", "numunique= 1 numrows= 17", "1"}, {"TBASIC6_JI", "numunique= 1 numrows= 17", "1"}, {"TBASIC6_JI", "numunique= 17 numrows= 17", "2"}});
        s.executeUpdate("drop table tbasic6");
        s.executeUpdate("create table et (x int, y int)");
        s.executeUpdate("create index etx on et(x)");
        s.executeUpdate("create index ety on et(y)");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','ET','ETX')");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','ET',NULL)");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname like 'ET%' order by indexname, stats, ncols");
        JDBC.assertEmpty(statsrs);
        s.executeUpdate("drop table et");
        s.executeUpdate("create table null_table (x int, y varchar(2))");
        s.executeUpdate("create index nt_x on null_table(x desc)");
        for (i = 1; i < 4; ++i) {
            s.executeUpdate("insert into null_table values (" + i + ", '" + alphabet[i - 1] + "')");
        }
        for (int c = 0; c < 2; ++c) {
            for (int i4 = 1; i4 < 4; ++i4) {
                s.executeUpdate("insert into null_table values (null, '" + alphabet[i4 - 1] + "')");
            }
        }
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','NULL_TABLE',NULL)");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname = 'NT_X' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"NT_X", "numunique= 9 numrows= 9", "1"}});
        s.executeUpdate("drop index nt_x");
        s.executeUpdate("create index nt_yx on null_table(y,x)");
        statsrs = s.executeQuery("select indexname, stats, ncols from showstats where indexname = 'NT_YX' order by indexname, stats, ncols");
        JDBC.assertFullResultSet(statsrs, new String[][]{{"NT_YX", "numunique= 3 numrows= 9", "1"}, {"NT_YX", "numunique= 9 numrows= 9", "2"}});
    }

    @Override
    protected void tearDown() throws Exception {
        Statement s = this.createStatement();
        try {
            s.execute("drop table tbasic1");
            s.execute("drop table tbasic2");
            s.execute("drop table tbasic3");
            s.execute("drop table tbasic4");
            s.execute("drop table tbasic6");
            s.execute("drop table et");
            s.execute("drop table null_table");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        s.close();
        super.tearDown();
    }
}

