/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PredicateTest
extends BaseJDBCTestCase {
    public PredicateTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(PredicateTest.class);
    }

    public void testTransitiveClosureWithConstantsOnLeftSide() throws SQLException, IOException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t1 (i int)");
        s.execute("create table t2 (j int)");
        s.execute("insert into t1 values 1, 5, 7, 11, 13, 17, 19");
        s.execute("insert into t2 values 23, 29, 31, 37, 43, 47, 53");
        s.execute("insert into t1 select 23 * i from t1 where i < 19");
        s.execute("insert into t2 select 23 * j from t2 where j < 55");
        s.execute("call syscs_util.syscs_set_runtimestatistics(1)");
        JDBC.assertSingleValueResultSet(s.executeQuery("select i from t1, t2 where t1.i = t2.j and t1.i >= 23 and t2.j <= 30"), "23");
        List<String> expectedOperators = Arrays.asList("Operator: <", "Operator: <=", "Operator: <", "Operator: <=", "Operator: =");
        PredicateTest.assertEquals(expectedOperators, this.extractOperators(this.getStatistics()));
        JDBC.assertSingleValueResultSet(s.executeQuery("select i from t1, t2 where t1.i = t2.j and 23 <= t1.i and 30 >= t2.j"), "23");
        PredicateTest.assertEquals(expectedOperators, this.extractOperators(this.getStatistics()));
        PreparedStatement paramRight = this.prepareStatement("select i from t1, t2 where t1.i = t2.j and t1.i >= ? and t2.j <= ?");
        paramRight.setInt(1, 23);
        paramRight.setInt(2, 30);
        JDBC.assertSingleValueResultSet(paramRight.executeQuery(), "23");
        PredicateTest.assertEquals(expectedOperators, this.extractOperators(this.getStatistics()));
        PreparedStatement paramLeft = this.prepareStatement("select i from t1, t2 where t1.i = t2.j and ? <= t1.i and ? >= t2.j");
        paramLeft.setInt(1, 23);
        paramLeft.setInt(2, 30);
        JDBC.assertSingleValueResultSet(paramLeft.executeQuery(), "23");
        PredicateTest.assertEquals(expectedOperators, this.extractOperators(this.getStatistics()));
    }

    private String getStatistics() throws SQLException {
        ResultSet rs = this.createStatement().executeQuery("values syscs_util.syscs_get_runtimestatistics()");
        rs.next();
        String stats = rs.getString(1);
        JDBC.assertEmpty(rs);
        return stats;
    }

    private List<String> extractOperators(String stats) throws IOException {
        String line;
        ArrayList<String> ops = new ArrayList<String>();
        BufferedReader r = new BufferedReader(new StringReader(stats));
        while ((line = r.readLine()) != null) {
            if (!(line = line.trim()).startsWith("Operator: ")) continue;
            ops.add(line);
        }
        return ops;
    }
}

