/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class ForeignKeysNonSpsTest
extends BaseJDBCTestCase {
    private static final int WAIT_TIMEOUT_DURATION = 4;

    public ForeignKeysNonSpsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ForeignKeysNonSpsTest.class);
    }

    public void testForeignKeys() throws Exception {
        Statement st = this.createStatement();
        int initialCardSysDepends = this.numberOfRowsInSysdepends(st);
        st.executeUpdate("CREATE PROCEDURE WAIT_FOR_POST_COMMIT() DYNAMIC RESULT SETS 0 LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA");
        st.executeUpdate(" create table p (c1 char(1), y int not null, c2 char(1), x int not null, constraint pk primary key (x,y))");
        st.executeUpdate(" create table f (x int not null, s smallint, y int not null, constraint fk foreign key (x,y) references p)");
        st.executeUpdate("insert into p values ('1',1,'1',1)");
        st.executeUpdate("insert into f values \t(1,1,1),\t(1,1,1),\t(1,1,1),\t\t(1,1,1),\t(1, 0, 1),\t(1,1,1),\t(1,0,1),\t(1, 0, 1)");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 8, "delete from f");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, " insert into f values \t(1,1,1),\t(1,1,1),\t(1,1,1),\t\t(1,1,1),\t(1, 1, 1),\t(2,1,666),\t(1,1,0),\t(0, 1, 0)");
        st.executeUpdate("drop table f");
        this.waitForPostCommit();
        st.executeUpdate("create table f (c1 char(1), y int, c2 char(1), x int, constraint fk foreign key (x,y) references p)");
        st.executeUpdate("insert into f select * from p where 1 = 2");
        st.executeUpdate("drop table f");
        st.executeUpdate("drop table p");
        this.waitForPostCommit();
        st.executeUpdate("create table s (x int not null primary key, y int references s, z int references s)");
        st.executeUpdate("insert into s values \t(1,1,1),\t(2,1,1),\t(10,2,1),\t\t(11,1,2),\t(12,4,4),\t(4,1,1),\t(13,null,null),\t(14,1,2),\t(15,null, 1)");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 9, "delete from s");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "insert into s values \t(1,1,1),\t(2,1,1),\t(10,2,1),\t\t(11,1,2),\t(12,4,4),\t(4,1,1),\t(13,null,null),\t(14,1,2),\t(15,666, 1)");
        st.executeUpdate("create table x (x int not null, y int, constraint pk primary key (x))");
        st.executeUpdate(" create table y (x int , y int, constraint fk foreign key (x) references x)");
        PreparedStatement pStIx = this.prepareStatement("insert into x\tvalues(0,0),(1,1),(2,2)");
        PreparedStatement pStIx2 = this.prepareStatement("insert into x values(3,3),(4,4)");
        PreparedStatement pStIy = this.prepareStatement("insert into y values(0,0),(1,1),(2,2)");
        PreparedStatement dy = this.prepareStatement("delete from y where x = 1");
        PreparedStatement dx = this.prepareStatement("delete from x where x = 1");
        ForeignKeysNonSpsTest.assertUpdateCount(pStIx, 3);
        this.setAutoCommit(false);
        this.commit();
        ForeignKeysNonSpsTest.assertUpdateCount(dy, 0);
        ForeignKeysNonSpsTest.assertUpdateCount(dx, 1);
        ForeignKeysNonSpsTest.assertStatementError("23503", pStIy);
        this.rollback();
        ForeignKeysNonSpsTest.assertUpdateCount(pStIy, 3);
        ForeignKeysNonSpsTest.assertUpdateCount(dy, 1);
        ForeignKeysNonSpsTest.assertUpdateCount(dx, 1);
        pStIx.close();
        pStIx2.close();
        pStIy.close();
        dy.close();
        dx.close();
        st.executeUpdate("drop table y");
        st.executeUpdate("drop table x");
        st.executeUpdate("drop table s");
        this.setAutoCommit(true);
        this.waitForPostCommit();
        st.executeUpdate("create table p1 (x int not null, constraint pk1 primary key(x))");
        st.executeUpdate(" create table u1 (x int not null unique)");
        st.executeUpdate("create table p2 (x int not null, y dec(5,2) not null, constraint pk2 primary key (x,y))");
        st.executeUpdate(" create table u2 (x int not null, y dec(5,2) not null, constraint uk2 unique (x,y))");
        st.executeUpdate(" create table p3 (x char(10) not null, constraint pk3 primary key (x))");
        st.executeUpdate("create schema otherschema");
        st.executeUpdate(" create table otherschema.p1 (x int not null primary key)");
        ForeignKeysNonSpsTest.assertStatementError("X0Y46", st, "create table f (x int, constraint fk foreign key (x) references notthere)");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, "create table f (x int, constraint fk foreign key (x) references p1(notthere))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, "create table f (x int, constraint fk foreign key (x) references p2(y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, "create table f (x smallint, constraint fk foreign key (x) references p1(x))");
        ForeignKeysNonSpsTest.assertStatementError("42Y08", st, "create table f (x char(36), constraint fk foreign key (x) references sys.sysforeignkeys(constraintid))");
        ForeignKeysNonSpsTest.assertStatementError("42Y07", st, "create table f (x char(36), constraint fk foreign key (x) references badschema.x)");
        ForeignKeysNonSpsTest.assertStatementError("42X93", st, "create table f (x dec(5,2), y int, constraint fk foreign key (x,z) references p2(x,y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, "create table f (x dec(5,2), y int, constraint fk foreign key (x) references p2(x,y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, " create table f (x dec(5,2), y int, constraint fk foreign key (x,y) references p2(x))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y46", st, "create table f (x int references notthere)");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, "create table f (x int references p1(notthere))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, "create table f (x int references p2(y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, "create table f (x smallint references p1(x))");
        ForeignKeysNonSpsTest.assertStatementError("42Y08", st, "create table f (x char(36) references sys.sysforeignkeys(constraintid))");
        ForeignKeysNonSpsTest.assertStatementError("42Y07", st, "create table f (x char(36) references badschema.x)");
        st.executeUpdate("create table f (d dec(5,2), i int, constraint fk foreign key (i,d) references p2(x,y))");
        st.executeUpdate(" drop table f");
        this.waitForPostCommit();
        st.executeUpdate(" create table f (i int, d dec(5,2), constraint fk foreign key (i,d) references p2(x,y))");
        st.executeUpdate("drop table f");
        this.waitForPostCommit();
        st.executeUpdate(" create table f (d dec(5,2), i int, constraint fk foreign key (i,d) references u2(x,y))");
        st.executeUpdate("drop table f");
        this.waitForPostCommit();
        st.executeUpdate(" create table f (i int, d dec(5,2), constraint fk foreign key (i,d) references u2(x,y))");
        st.executeUpdate("drop table f");
        this.waitForPostCommit();
        st.executeUpdate(" create table f (c char(10) references p3(x))");
        st.executeUpdate("drop table f");
        this.waitForPostCommit();
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, "create table f (i int, d dec(5,1), constraint fk foreign key (i,d) references p2(x,y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, " create table f (i int, d dec(4,2), constraint fk foreign key (i,d) references p2(x,y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, " create table f (i int, d dec(4,2), constraint fk foreign key (i,d) references p2(x,y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, " create table f (i int, d numeric(5,2), constraint fk foreign key (i,d) references p2(x,y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, " create table f (c char(11) references p3(x))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, " create table f (c varchar(10) references p3(x))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", st, "create table f (d dec(5,2), i int, constraint fk foreign key (d,i) references p2(x,y))");
        st.executeUpdate("create table f (x int, constraint fk foreign key (x) references p1)");
        ResultSet rs = st.executeQuery(" select constraintname, referencecount \tfrom sys.sysconstraints c, sys.sysforeignkeys fk\twhere fk.keyconstraintid = c.constraintid order by constraintname");
        Object[][] expRS = new String[][]{{"PK1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate(" create table f2 (x int, constraint fk2 foreign key (x) references p1(x))");
        st.executeUpdate(" create table f3 (x int, constraint fk3 foreign key (x) references p1(x))");
        st.executeUpdate(" create table f4 (x int, constraint fk4 foreign key (x) references p1(x))");
        rs = st.executeQuery(" select distinct constraintname, referencecount \tfrom sys.sysconstraints c, sys.sysforeignkeys fk\twhere fk.keyconstraintid = c.constraintid order by constraintname");
        expRS = new String[][]{{"PK1", "4"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery(" select constraintname \tfrom sys.sysconstraints c, sys.sysforeignkeys fk\twhere fk.constraintid = c.constraintid\torder by 1");
        expRS = new String[][]{{"FK"}, {"FK2"}, {"FK3"}, {"FK4"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        ForeignKeysNonSpsTest.assertStatementError("X0Y25", st, "alter table p1 drop constraint pk1");
        ForeignKeysNonSpsTest.assertStatementError("X0Y25", st, "drop table p1");
        this.waitForPostCommit();
        st.executeUpdate("drop table f2");
        st.executeUpdate("drop table f3");
        st.executeUpdate("drop table f4");
        this.waitForPostCommit();
        rs = st.executeQuery(" select constraintname, referencecount \tfrom sys.sysconstraints c, sys.sysforeignkeys fk\twhere fk.keyconstraintid = c.constraintid order by constraintname");
        expRS = new String[][]{{"PK1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate(" alter table f drop constraint fk");
        this.waitForPostCommit();
        st.executeUpdate("alter table p1 drop constraint pk1");
        this.waitForPostCommit();
        ForeignKeysNonSpsTest.assertStatementError("X0Y41", st, "alter table f add constraint fk foreign key (x) references p1");
        st.executeUpdate("alter table p1 add constraint pk1 primary key (x)");
        st.executeUpdate(" create table f2 (x int, constraint fk2 foreign key (x) references p1(x))");
        st.executeUpdate(" create table f3 (x int, constraint fk3 foreign key (x) references p1(x))");
        st.executeUpdate(" create table f4 (x int, constraint fk4 foreign key (x) references p1(x))");
        st.executeUpdate("alter table f4 drop constraint fk4");
        st.executeUpdate("alter table f3 drop constraint fk3");
        st.executeUpdate("alter table f2 drop constraint fk2");
        st.executeUpdate("alter table p1 drop constraint pk1");
        this.waitForPostCommit();
        rs = st.executeQuery("select constraintname \tfrom sys.sysconstraints c, sys.sysforeignkeys fk\twhere fk.constraintid = c.constraintid order by constraintname");
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("drop table p1");
        st.executeUpdate("drop table p2");
        st.executeUpdate("drop table u1");
        st.executeUpdate("drop table u2");
        st.executeUpdate("drop table otherschema.p1");
        st.executeUpdate("drop schema otherschema restrict");
        this.waitForPostCommit();
        st.executeUpdate("create table default_sysdepends_count(a int)");
        st.executeUpdate(" insert into default_sysdepends_count select count(*) from sys.sysdepends");
        rs = st.executeQuery(" select * from default_sysdepends_count");
        expRS = new String[][]{{Integer.toString(initialCardSysDepends)}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("create table selfref (p char(10) not null primary key, \t\tf char(10) references selfref)");
        st.executeUpdate("drop table selfref");
        this.waitForPostCommit();
        st.executeUpdate("create table selfref (p char(10) not null, \t\tf char(10) references selfref, \t\tconstraint pk primary key (p))");
        st.executeUpdate("drop table selfref");
        this.waitForPostCommit();
        st.executeUpdate("create table selfref (p char(10) not null, f char(10), \t\tconstraint f foreign key (f) references selfref(p), \t\tconstraint pk primary key (p))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y25", st, "alter table selfref drop constraint pk");
        this.waitForPostCommit();
        st.executeUpdate("alter table selfref drop constraint f");
        st.executeUpdate(" alter table selfref drop constraint pk");
        st.executeUpdate("drop table selfref");
        this.waitForPostCommit();
        st.executeUpdate("create table pr1(x int not null, \t\tconstraint pkr1 primary key (x))");
        st.executeUpdate(" create table pr2(x int not null, \t\tconstraint pkr2 primary key(x), \t\tconstraint fpkr2 foreign key (x) references pr1)");
        st.executeUpdate(" create table pr3(x int not null, \t\tconstraint pkr3 primary key(x), \t\tconstraint fpkr3 foreign key (x) references pr2)");
        rs = st.executeQuery(" select constraintname, referencecount from sys.sysconstraints order by constraintname");
        expRS = new String[][]{{"FPKR2", "0"}, {"FPKR3", "0"}, {"PK3", "0"}, {"PKR1", "1"}, {"PKR2", "1"}, {"PKR3", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("alter table pr2 drop constraint fpkr2");
        st.executeUpdate(" alter table pr1 drop constraint pkr1");
        this.waitForPostCommit();
        rs = st.executeQuery("select constraintname, referencecount from sys.sysconstraints order by constraintname");
        expRS = new String[][]{{"FPKR3", "0"}, {"PK3", "0"}, {"PKR2", "1"}, {"PKR3", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop table pr3");
        st.executeUpdate("drop table pr2");
        st.executeUpdate("drop table pr1");
        this.waitForPostCommit();
        st.executeUpdate("create table default_sysdepends_count2(a int)");
        st.executeUpdate(" insert into default_sysdepends_count2 select count(*) from sys.sysdepends");
        rs = st.executeQuery(" select default_sysdepends_count2.a - default_sysdepends_count.a    from default_sysdepends_count2, default_sysdepends_count");
        expRS = new String[][]{{"0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("create table x (x int not null primary key, y int, constraint xfk foreign key (y) references x)");
        st.executeUpdate(" create table y (x int, constraint yfk foreign key (x) references x)");
        PreparedStatement ss = this.prepareStatement("select * from x");
        PreparedStatement si = this.prepareStatement("insert into x values (1,1)");
        PreparedStatement su = this.prepareStatement("update x set x = x+1, y=y+1");
        st.executeUpdate(" alter table x drop constraint xfk");
        this.waitForPostCommit();
        this.setAutoCommit(false);
        st.executeUpdate("alter table y drop constraint yfk");
        this.commit();
        this.waitForPostCommit();
        st.executeUpdate("drop table y");
        this.commit();
        this.waitForPostCommit();
        st.executeUpdate("drop table x");
        ss.close();
        si.close();
        su.close();
        st.executeUpdate("drop table f3");
        st.executeUpdate("drop table f2");
        st.executeUpdate("drop table f");
        this.commit();
        this.waitForPostCommit();
        st.executeUpdate("create table default_sysdepends_count3(a int)");
        st.executeUpdate(" insert into default_sysdepends_count3 select count(*) from sys.sysdepends");
        rs = st.executeQuery(" select default_sysdepends_count3.a - default_sysdepends_count.a    from default_sysdepends_count3, default_sysdepends_count");
        expRS = new String[][]{{"0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.setAutoCommit(true);
        ForeignKeysNonSpsTest.assertStatementError("42Y55", st, "drop table s");
        ForeignKeysNonSpsTest.assertStatementError("42Y55", st, "drop table f3");
        ForeignKeysNonSpsTest.assertStatementError("42Y55", st, "drop table f2");
        ForeignKeysNonSpsTest.assertStatementError("42Y55", st, "drop table f");
        ForeignKeysNonSpsTest.assertStatementError("42Y55", st, "drop table p");
        this.waitForPostCommit();
        st.executeUpdate(" create table p (x int not null, y int not null, constraint pk primary key (x,y))");
        st.executeUpdate(" create table f (x int, y int, constraint fk foreign key (x,y) references p)");
        st.executeUpdate(" insert into p values (1,1)");
        st.executeUpdate("insert into f values (1,1)");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "insert into f values (2,1)");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, " insert into f values (1,2)");
        st.executeUpdate("insert into f values (1,null)");
        st.executeUpdate("insert into f values (null,null)");
        st.executeUpdate("insert into f values (1,null)");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update p set x = 2");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update p set y = 2");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update p set x = 1, y = 2");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update p set x = 2, y = 1");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update p set x = 2, y = 2");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "update p set x = 1, y = 1");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "delete from p");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 4, "delete from f");
        st.executeUpdate("insert into f values (1,1)");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update f set x = 2");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update f set y = 2");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update f set x = 1, y = 2");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update f set x = 2, y = 1");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "update f set x = 1, y = 1");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "update f set x = null, y = 1");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "update f set x = 1, y = null");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "update f set x = null, y = null");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "delete from f");
        st.executeUpdate("insert into f values (1,1)");
        st.executeUpdate("insert into p values (2,2)");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "update f set x = x+1, y = y+1");
        rs = st.executeQuery("select * from f");
        expRS = new String[][]{{"2", "2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from p");
        expRS = new String[][]{{"1", "1"}, {"2", "2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        ForeignKeysNonSpsTest.assertUpdateCount(st, 2, "update p set x = x+1, y = y+1");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update p set x = x+1, y = y+1");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "delete from f");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 2, "delete from p");
        st.executeUpdate("insert into f select * from f");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 0, "delete from p where x = 9999");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 0, "update p set x = x+1, y=y+1 where x = 999");
        st.executeUpdate("insert into p values (1,1)");
        st.executeUpdate("insert into f values (1,1)");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 0, "update p set x = x+1, y=y+1 where x = 999");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 0, "delete from p where x = 9999");
        st.executeUpdate("insert into f select * from f");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 2, "delete from f");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "delete from p");
        st.executeUpdate("insert into p values (1,1)");
        st.executeUpdate("insert into f values (1,1)");
        this.setAutoCommit(false);
        Statement uS = this.createStatement(1003, 1008);
        ResultSet r = uS.executeQuery("select * from p for update of x");
        r.next();
        ForeignKeysNonSpsTest.assertEquals((String)r.getString(1), (String)"1");
        ForeignKeysNonSpsTest.assertEquals((String)r.getString(2), (String)"1");
        try {
            r.updateInt("X", 666);
        }
        catch (SQLException e) {
            ForeignKeysNonSpsTest.assertSQLState("23503", e);
        }
        r.close();
        r = uS.executeQuery("select * from f for update of x");
        r.next();
        ForeignKeysNonSpsTest.assertEquals((String)r.getString(1), (String)"1");
        ForeignKeysNonSpsTest.assertEquals((String)r.getString(2), (String)"1");
        try {
            r.updateInt("X", 666);
        }
        catch (SQLException e) {
            ForeignKeysNonSpsTest.assertSQLState("23503", e);
        }
        r.close();
        this.commit();
        this.setAutoCommit(true);
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "delete from f");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "delete from p");
        st.executeUpdate("insert into p values (0,0), (1,1), (2,2), (3,3), (4,4)");
        st.executeUpdate("insert into f values (1,1)");
        st.executeUpdate("create table f2 (x int, y int, constraint fk2 foreign key (x,y) references p)");
        st.executeUpdate("insert into f2 values (2,2)");
        st.executeUpdate(" create table f3 (x int, y int, constraint fk3 foreign key (x,y) references p)");
        st.executeUpdate("insert into f3 values (3,3)");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 5, "update p set x = x+1, y = y+1");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update p set x = x+1");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update p set y = y+1");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update p set x = x+1, y = y+1");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update p set y = 666 where y = 3");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update p set x = 666 where x = 2");
        st.executeUpdate("drop table f");
        st.executeUpdate("drop table f2");
        st.executeUpdate("drop table f3");
        st.executeUpdate("drop table p");
        this.waitForPostCommit();
        st.executeUpdate("create table s (x int not null primary key, y int references s, z int references s)");
        st.executeUpdate("insert into s values (1,null,null)");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "update s set y = 1");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update s set z = 2");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "update s set z = 1");
        st.executeUpdate("insert into s values (2, 1, 1)");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "update s set x = 666 where x = 2");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 2, "update s set x = x+1, y = y+1, z = z+1");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 2, "delete from s");
        st.executeUpdate("insert into s values (1,null,null)");
        st.executeUpdate("insert into s values (2,null,null)");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "update s set y = 2 where x = 1");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "update s set z = 1 where x = 2");
        rs = st.executeQuery("select * from s");
        expRS = new String[][]{{"1", "2", null}, {"2", null, "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "update s set x = 0 where x = 1");
        st.executeUpdate("create table p (c1 char(1), y int not null, c2 char(1), x int not null, constraint pk primary key (x,y))");
        st.executeUpdate(" create table f (x int, s smallint, y int, constraint fk foreign key (x,y) references p)");
        st.executeUpdate(" insert into p values ('1',1,'1',1)");
        st.executeUpdate("insert into f values (1,1,1)");
        st.executeUpdate("insert into p values ('0',0,'0',0)");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 2, "update p set x = x+1, y=y+1");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "delete from p where y = 1");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "insert into f values (1,1,4)");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 1, "delete from f");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 2, "delete from p");
        st.executeUpdate("insert into p values ('1',1,'1',1)");
        st.executeUpdate("insert into f values (1,1,1)");
        st.executeUpdate("insert into p values ('0',0,'0',0)");
        ForeignKeysNonSpsTest.assertUpdateCount(st, 2, "update p set x = x+1, y=y+1 where x < (select max(x)+10000 from p)");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "delete from p where y = 1 and y in (select y from p)");
        st.executeUpdate("create table f2 (x int, t smallint, y int)");
        st.executeUpdate("insert into f2 values (1,1,4)");
        ForeignKeysNonSpsTest.assertStatementError("23503", st, "insert into f select * from f2");
        st.executeUpdate("insert into f2 values (1,1,1)");
        st.executeUpdate("insert into f select * from f2 where y = 1");
        st.executeUpdate("drop table f2");
        st.executeUpdate("drop table f");
        st.executeUpdate("drop table p");
        this.waitForPostCommit();
        ForeignKeysNonSpsTest.assertStatementError("42Y55", st, "drop table f");
        ForeignKeysNonSpsTest.assertStatementError("42Y55", st, "drop table p");
        this.waitForPostCommit();
        PreparedStatement pSt = this.prepareStatement("create table p (w int not null primary key, x int references p, y int not null, z int not null, constraint uyz unique (y,z))");
        ForeignKeysNonSpsTest.assertUpdateCount(pSt, 0);
        pSt = this.prepareStatement("create table f (w int references p, x int, y int, z int, constraint fk foreign key (y,z) references p (y,z))");
        ForeignKeysNonSpsTest.assertUpdateCount(pSt, 0);
        pSt = this.prepareStatement("alter table f drop constraint fk");
        ForeignKeysNonSpsTest.assertUpdateCount(pSt, 0);
        this.waitForPostCommit();
        pSt = this.prepareStatement("alter table f add constraint fk foreign key (y,z) references p (y,z)");
        ForeignKeysNonSpsTest.assertUpdateCount(pSt, 0);
        PreparedStatement sf = this.prepareStatement("insert into f values (1,1,1,1)");
        PreparedStatement sp = this.prepareStatement("insert into p values (1,1,1,1)");
        ForeignKeysNonSpsTest.assertStatementError("23503", sf);
        ForeignKeysNonSpsTest.assertUpdateCount(sp, 1);
        ForeignKeysNonSpsTest.assertUpdateCount(sf, 1);
        st.executeUpdate(" insert into p values (2,2,2,2)");
        pSt = this.prepareStatement("update f set w=w+1, x = x+1, y=y+1, z=z+1");
        ForeignKeysNonSpsTest.assertUpdateCount(pSt, 1);
        pSt = this.prepareStatement("update p set w=w+1, x = x+1, y=y+1, z=z+1");
        ForeignKeysNonSpsTest.assertUpdateCount(pSt, 2);
        pSt = this.prepareStatement("delete from p where x =1");
        ForeignKeysNonSpsTest.assertUpdateCount(pSt, 0);
        st.executeUpdate("drop table f");
        st.executeUpdate("drop table p");
        this.waitForPostCommit();
        st.executeUpdate("drop procedure WAIT_FOR_POST_COMMIT");
        this.rollback();
        st.close();
    }

    private int numberOfRowsInSysdepends(Statement st) throws SQLException {
        ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM SYS.SYSDEPENDS");
        rs.next();
        int result = rs.getInt(1);
        rs.close();
        return result;
    }

    private void waitForPostCommit() throws SQLException {
        CallableStatement s = this.prepareCall("CALL WAIT_FOR_POST_COMMIT()");
        ForeignKeysNonSpsTest.assertUpdateCount(s, 0);
        s.close();
    }
}

