/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Barrier;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class ErrorMessageTest
extends BaseJDBCTestCase {
    public ErrorMessageTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("ErrorMessageTest");
        if (JDBC.vmSupportsJSR169()) {
            return suite;
        }
        suite.addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new ErrorMessageTest("testWaitTimeout"), 1, 2));
        suite.addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new ErrorMessageTest("testDeadlockTimeout"), 1, 60));
        Test test = DatabasePropertyTestSetup.singleProperty((Test)suite, "derby.locks.deadlockTrace", "true");
        return new CleanDatabaseTestSetup(test){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("create table t (id int primary key, text varchar(10))");
                s.executeUpdate("insert into t (id) values 1, 2");
            }
        };
    }

    public void testWaitTimeout() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        ErrorMessageTest.assertUpdateCount(s, 1, "update t set text='xxx' where id=1");
        Connection c2 = this.openDefaultConnection();
        Statement s2 = c2.createStatement();
        try {
            JDBC.assertDrainResults(s2.executeQuery("select * from t where id=1"));
            ErrorMessageTest.fail((String)"Expected lock timeout");
        }
        catch (SQLException e) {
            ErrorMessageTest.assertSQLState("Not a timeout", "40XL1", e);
            String[] msg = e.getMessage().split("\n");
            ErrorMessageTest.assertEquals((String)"*** The following row is the victim ***", (String)msg[4]);
            ErrorMessageTest.assertEquals((String)"*** The above row is the victim ***", (String)msg[6]);
            String[] victim = msg[5].split(" *\\|");
            ErrorMessageTest.assertTrue((String)("Invalid XID string: " + victim[0]), (boolean)victim[0].matches("\\d+"));
            ErrorMessageTest.assertEquals((String)"Victim should be a row lock", (String)"ROW", (String)victim[1]);
            ErrorMessageTest.assertEquals((String)"Victim should be a shared lock", (String)"S", (String)victim[2]);
            ErrorMessageTest.assertEquals((String)"Victim should be waiting", (String)"WAIT", (String)victim[5]);
            boolean locksDumped = false;
            for (int i = 7; i < msg.length - 1; ++i) {
                String[] tokens = msg[i].split(" *\\|");
                ErrorMessageTest.assertTrue((String)("Invalid XID string: " + tokens[0]), (boolean)tokens[0].matches("\\d+"));
                ErrorMessageTest.assertTrue((String)("Unexpected lock type: " + tokens[1]), (boolean)tokens[1].matches("ROW|TABLE"));
                ErrorMessageTest.assertTrue((String)("Unexpected lock mode: " + tokens[2]), (boolean)tokens[2].matches("S|X|IX|IS"));
                ErrorMessageTest.assertEquals((String)"Expected lock to be granted", (String)"GRANT", (String)tokens[5]);
                locksDumped = true;
            }
            ErrorMessageTest.assertTrue((String)"No locks dumped", (boolean)locksDumped);
        }
        s.close();
        s2.close();
        c2.close();
    }

    public void testDeadlockTimeout() throws SQLException, InterruptedException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        ErrorMessageTest.assertUpdateCount(s, 1, "update t set text='xxx' where id=1");
        Connection c2 = this.openDefaultConnection();
        c2.setAutoCommit(false);
        Statement s2 = c2.createStatement();
        ErrorMessageTest.assertUpdateCount(s2, 1, "update t set text='yyy' where id=2");
        PreparedStatement ps1 = this.prepareStatement("select * from t where id=2");
        final PreparedStatement ps2 = c2.prepareStatement("select * from t where id=1");
        final Barrier barrier = new Barrier(2);
        final SQLException[] holder = new SQLException[2];
        final Throwable[] unexpected = new Throwable[1];
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    JDBC.assertDrainResults(ps2.executeQuery());
                }
                catch (SQLException e) {
                    holder[0] = e;
                }
                catch (Throwable t) {
                    unexpected[0] = t;
                }
            }
        });
        t.start();
        barrier.await();
        try {
            JDBC.assertDrainResults(ps1.executeQuery());
        }
        catch (SQLException e) {
            holder[1] = e;
        }
        t.join();
        if (unexpected[0] != null) {
            ErrorMessageTest.fail("Helper thread failed unexpectedly", unexpected[0]);
        }
        ErrorMessageTest.assertFalse((String)"No deadlock", (holder[0] == null && holder[1] == null ? 1 : 0) != 0);
        if (holder[0] != null && holder[1] != null) {
            ErrorMessageTest.printStackTrace(holder[0]);
            ErrorMessageTest.printStackTrace(holder[1]);
            ErrorMessageTest.fail((String)"Only one of the waiters should be aborted");
        }
        SQLException deadlock = holder[0] == null ? holder[1] : holder[0];
        ErrorMessageTest.assertSQLState("Not a deadlock", "40001", deadlock);
        String[] lines = deadlock.getMessage().split("\n");
        ErrorMessageTest.assertEquals((String)"Unexpected number of lines in message", (int)8, (int)lines.length);
        Pattern[] patterns = new Pattern[]{Pattern.compile("Lock : ROW, T, \\(\\d+,\\d+\\)"), Pattern.compile(" *Waiting XID : \\{\\d+, S\\} , APP, select \\* from t where id=(1|2)"), Pattern.compile(" *Granted XID : \\{\\d+, X\\} *")};
        for (int i = 0; i < patterns.length * 2; ++i) {
            String line = lines[i + 1];
            Matcher m = patterns[i % patterns.length].matcher(line);
            ErrorMessageTest.assertTrue((String)("mismatch: " + line), (boolean)m.matches());
        }
        s.close();
        s2.close();
        c2.rollback();
        c2.close();
    }
}

