/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.LogicalPreparedStatement;
import org.apache.derby.iapi.jdbc.EngineStatement;

public class Wrapper41Statement {
    private EngineStatement _engineStatement;
    private ClientStatement _netStatement;
    private LogicalPreparedStatement _logicalStatement;

    public Wrapper41Statement(Object wrapped) throws Exception {
        if (wrapped instanceof EngineStatement) {
            this._engineStatement = (EngineStatement)wrapped;
        } else if (wrapped instanceof ClientStatement) {
            this._netStatement = (ClientStatement)wrapped;
        } else if (wrapped instanceof LogicalPreparedStatement) {
            this._logicalStatement = (LogicalPreparedStatement)wrapped;
        } else {
            throw this.nothingWrapped();
        }
    }

    public void closeOnCompletion() throws SQLException {
        if (this._engineStatement != null) {
            this._engineStatement.closeOnCompletion();
        } else if (this._netStatement != null) {
            this._netStatement.closeOnCompletion();
        } else if (this._logicalStatement != null) {
            this._logicalStatement.closeOnCompletion();
        } else {
            throw this.nothingWrapped();
        }
    }

    public boolean isCloseOnCompletion() throws SQLException {
        if (this._engineStatement != null) {
            return this._engineStatement.isCloseOnCompletion();
        }
        if (this._netStatement != null) {
            return this._netStatement.isCloseOnCompletion();
        }
        if (this._logicalStatement != null) {
            return this._logicalStatement.isCloseOnCompletion();
        }
        throw this.nothingWrapped();
    }

    public Statement getWrappedObject() throws SQLException {
        if (this._engineStatement != null) {
            return this._engineStatement;
        }
        if (this._netStatement != null) {
            return this._netStatement;
        }
        if (this._logicalStatement != null) {
            return this._logicalStatement;
        }
        throw this.nothingWrapped();
    }

    public boolean isClosed() throws Exception {
        Statement stmt = this.getWrappedObject();
        Method method = stmt.getClass().getMethod("isClosed", null);
        return (Boolean)method.invoke((Object)stmt, null);
    }

    private SQLException nothingWrapped() {
        return new SQLException("Nothing wrapped!");
    }
}

