/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ResultSetMetaDataTest
extends BaseJDBCTestCase {
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private ResultSetMetaData rsmd = null;

    public ResultSetMetaDataTest(String name) {
        super(name);
    }

    protected void setUp() throws SQLException {
        this.ps = this.prepareStatement("select count(*) from sys.systables");
        this.rs = this.ps.executeQuery();
        this.rsmd = this.rs.getMetaData();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.rs != null && !this.rs.isClosed()) {
            this.rs.close();
        }
        if (this.ps != null && !this.ps.isClosed()) {
            this.ps.close();
        }
        this.ps = null;
        this.rs = null;
        this.rsmd = null;
        super.tearDown();
    }

    public void testIsWrapperForResultSetMetaData() throws SQLException {
        ResultSetMetaDataTest.assertTrue((boolean)this.rsmd.isWrapperFor(ResultSetMetaData.class));
    }

    public void testUnwrapResultSetMetaData() throws SQLException {
        ResultSetMetaData rsmd2 = this.rsmd.unwrap(ResultSetMetaData.class);
        ResultSetMetaDataTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.rsmd, (Object)rsmd2);
    }

    public void testIsWrapperForResultSet() throws SQLException {
        ResultSetMetaDataTest.assertFalse((boolean)this.rsmd.isWrapperFor(ResultSet.class));
    }

    public void testUnwrapResultSet() {
        try {
            ResultSet rs = this.rsmd.unwrap(ResultSet.class);
            ResultSetMetaDataTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            ResultSetMetaDataTest.assertSQLState("XJ128", e);
        }
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ResultSetMetaDataTest.class);
    }
}

