/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.Derby2017LayerATest;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby2017LayerBTest
extends BaseJDBCTestCase {
    public Derby2017LayerBTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(Derby2017LayerBTest.class);
    }

    public void testStreamInsertCharBufferBoundary() throws IOException, SQLException {
        int[] lengths = new int[]{1, 16383, 0, 32756, 36383, 16384, 196608};
        this.rollback();
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("create table t2017_len (len int, c clob)");
        }
        catch (SQLException sqle) {
            Derby2017LayerBTest.assertSQLState("X0Y32", sqle);
            stmt.executeUpdate("delete from t2017_len");
        }
        this.commit();
        this.setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into t2017_len values (?,?)");
        for (int length : lengths) {
            ps.setInt(1, length);
            ps.setCharacterStream(2, new LoopingAlphabetReader(length));
            ps.executeUpdate();
        }
        ResultSet rs = stmt.executeQuery("select len, c from t2017_len");
        int rows = 0;
        while (rs.next()) {
            ++rows;
            int length = rs.getInt(1);
            Derby2017LayerBTest.assertEquals(new LoopingAlphabetReader(length), rs.getCharacterStream(2));
        }
        Derby2017LayerBTest.assertEquals((int)lengths.length, (int)rows);
    }

    public void testFailedStreamInsertCharBufferBoundariesImpl() throws IOException, SQLException {
        int[] lengths = new int[]{1, 16383, 0, 32756, 36383, 16384, 196608};
        this.rollback();
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("create table t2017_len (len int, c clob)");
        }
        catch (SQLException sqle) {
            Derby2017LayerBTest.assertSQLState("X0Y32", sqle);
            stmt.executeUpdate("delete from t2017_len");
        }
        this.commit();
        this.setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into t2017_len values (?,?)");
        for (int length : lengths) {
            ps.setInt(1, length);
            ps.setCharacterStream(2, new Derby2017LayerATest.FailingReader(length, -1L));
            try {
                ps.executeUpdate();
                Derby2017LayerBTest.fail((String)("Should have failed (length=" + length + ")"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        for (int length : lengths) {
            ps.setInt(1, length);
            ps.setCharacterStream(2, new Derby2017LayerATest.FailingReader(length, length / 2));
            try {
                ps.executeUpdate();
                Derby2017LayerBTest.fail((String)("Should have failed (length=" + length + ")"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        for (int length : lengths) {
            ps.setInt(1, length);
            ps.setCharacterStream(2, new Derby2017LayerATest.FailingReader(length, length - 1));
            try {
                ps.executeUpdate();
                Derby2017LayerBTest.fail((String)("Should have failed (length=" + length + ")"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        ResultSet rs = stmt.executeQuery("select count(*) from t2017_len");
        rs.next();
        Derby2017LayerBTest.assertEquals((int)0, (int)rs.getInt(1));
    }

    public void testFailedStreamInsertChar() throws IOException, SQLException {
        String[] INSERT = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] MASTER = new String[][]{{"This is row 1"}, {"This is row 2"}, {"This is row 3"}, {"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(INSERT, MASTER, false, false);
    }

    public void testFailedStreamInsertCharAutoCommit() throws IOException, SQLException {
        String[] INSERT = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] MASTER = new String[][]{{"This is row 1"}, {"This is row 2"}, {"This is row 3"}, {"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(INSERT, MASTER, true, false);
    }

    public void testFailedStreamInsertCharRollbackOnError() throws IOException, SQLException {
        String[] INSERT = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] MASTER = new String[][]{{"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(INSERT, MASTER, false, true);
    }

    public void testFailedStreamInsertCharAutoCommitRollbackOnError() throws IOException, SQLException {
        String[] INSERT = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] MASTER = new String[][]{{"This is row 1"}, {"This is row 2"}, {"This is row 3"}, {"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(INSERT, MASTER, true, true);
    }

    public void testFailedStreamInsertBinary() throws IOException, SQLException {
        byte[][] INSERT = Derby2017LayerATest.generateDefaultInsert();
        String[][] MASTER = Derby2017LayerATest.generateMaster(INSERT, new int[]{3, 4});
        this.doInsertTest(INSERT, MASTER, false, false);
    }

    public void testFailedStreamInsertBinaryAutoCommit() throws IOException, SQLException {
        byte[][] INSERT = Derby2017LayerATest.generateDefaultInsert();
        String[][] MASTER = Derby2017LayerATest.generateMaster(INSERT, new int[]{3, 4});
        this.doInsertTest(INSERT, MASTER, true, false);
    }

    public void testFailedStreamInsertBinaryRollbackOnError() throws IOException, SQLException {
        byte[][] INSERT = Derby2017LayerATest.generateDefaultInsert();
        String[][] MASTER = Derby2017LayerATest.generateMaster(INSERT, new int[]{0, 1, 2, 3, 4});
        this.doInsertTest(INSERT, MASTER, false, true);
    }

    public void testFailedStreamInsertBinaryAutoCommitRollbackOnError() throws IOException, SQLException {
        byte[][] INSERT = Derby2017LayerATest.generateDefaultInsert();
        String[][] MASTER = Derby2017LayerATest.generateMaster(INSERT, new int[]{3, 4});
        this.doInsertTest(INSERT, MASTER, true, true);
    }

    private void doInsertTest(String[] INSERT, String[][] MASTER, boolean autoCommit, boolean rollbackOnError) throws IOException, SQLException {
        PreparedStatement ps;
        Statement stmt;
        block10: {
            block9: {
                Derby2017LayerBTest.assertEquals((String)"Expects 7 rows", (int)7, (int)INSERT.length);
                Derby2017LayerBTest.assertTrue((MASTER.length < INSERT.length ? 1 : 0) != 0);
                this.rollback();
                stmt = this.createStatement();
                try {
                    stmt.executeUpdate("create table t2017 (c clob)");
                }
                catch (SQLException sqle) {
                    Derby2017LayerBTest.assertSQLState("X0Y32", sqle);
                    stmt.executeUpdate("delete from t2017");
                }
                this.commit();
                this.setAutoCommit(autoCommit);
                ps = this.prepareStatement("insert into t2017 values (?)");
                for (int i = 0; i < 3; ++i) {
                    ps.setCharacterStream(1, new StringReader(INSERT[i]));
                    Derby2017LayerBTest.assertEquals((int)1, (int)ps.executeUpdate());
                }
                Derby2017LayerATest.FailingReader r4 = new Derby2017LayerATest.FailingReader(10L, 3L);
                ps.setCharacterStream(1, r4);
                try {
                    ps.executeUpdate();
                    Derby2017LayerBTest.fail((String)"Insert should have failed");
                }
                catch (SQLException sqle) {
                    if (!rollbackOnError) break block9;
                    this.rollback();
                }
            }
            Derby2017LayerATest.FailingReader r5 = new Derby2017LayerATest.FailingReader(35002L, 35001L);
            ps.setCharacterStream(1, r5);
            try {
                ps.executeUpdate();
                Derby2017LayerBTest.fail((String)"Insert should have failed");
            }
            catch (SQLException sqle) {
                if (!rollbackOnError) break block10;
                this.rollback();
            }
        }
        for (int i = 5; i < INSERT.length; ++i) {
            ps.setCharacterStream(1, new StringReader(INSERT[i]));
            Derby2017LayerBTest.assertEquals((int)1, (int)ps.executeUpdate());
        }
        if (!autoCommit) {
            this.commit();
        }
        ResultSet rs = stmt.executeQuery("select * from t2017");
        JDBC.assertUnorderedResultSet(rs, MASTER);
    }

    private void doInsertTest(byte[][] INSERT, String[][] MASTER, boolean autoCommit, boolean rollbackOnError) throws IOException, SQLException {
        PreparedStatement ps;
        Statement stmt;
        block10: {
            block9: {
                Derby2017LayerBTest.assertEquals((String)"Expects 7 rows", (int)7, (int)INSERT.length);
                Derby2017LayerBTest.assertTrue((MASTER.length < INSERT.length ? 1 : 0) != 0);
                this.rollback();
                stmt = this.createStatement();
                try {
                    stmt.executeUpdate("create table t2017_binary (b blob)");
                }
                catch (SQLException sqle) {
                    Derby2017LayerBTest.assertSQLState("X0Y32", sqle);
                    stmt.executeUpdate("delete from t2017_binary");
                }
                this.commit();
                this.setAutoCommit(autoCommit);
                ps = this.prepareStatement("insert into t2017_binary values (?)");
                for (int i = 0; i < 3; ++i) {
                    ps.setBinaryStream(1, new ByteArrayInputStream(INSERT[i]));
                    Derby2017LayerBTest.assertEquals((int)1, (int)ps.executeUpdate());
                }
                FailingInputStream r4 = new FailingInputStream(new Derby2017LayerATest.FailingReader(10L, 3L));
                ps.setBinaryStream(1, r4);
                try {
                    ps.executeUpdate();
                    Derby2017LayerBTest.fail((String)"Insert should have failed");
                }
                catch (SQLException sqle) {
                    if (!rollbackOnError) break block9;
                    this.rollback();
                }
            }
            FailingInputStream r5 = new FailingInputStream(new Derby2017LayerATest.FailingReader(35002L, 35001L));
            ps.setBinaryStream(1, r5);
            try {
                ps.executeUpdate();
                Derby2017LayerBTest.fail((String)"Insert should have failed");
            }
            catch (SQLException sqle) {
                if (!rollbackOnError) break block10;
                this.rollback();
            }
        }
        for (int i = 5; i < INSERT.length; ++i) {
            ps.setBinaryStream(1, new ByteArrayInputStream(INSERT[i]));
            Derby2017LayerBTest.assertEquals((int)1, (int)ps.executeUpdate());
        }
        if (!autoCommit) {
            this.commit();
        }
        ResultSet rs = stmt.executeQuery("select * from t2017_binary");
        JDBC.assertUnorderedResultSet(rs, MASTER);
    }

    private static class FailingInputStream
    extends InputStream {
        private final Derby2017LayerATest.FailingReader in;

        public FailingInputStream(Derby2017LayerATest.FailingReader in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            int c = this.in.read();
            return (byte)c;
        }
    }
}

