/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DerbyNetNewServerTest
extends BaseJDBCTestCase {
    public DerbyNetNewServerTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC3() && Derby.hasServer()) {
            return new BaseTestSuite(DerbyNetNewServerTest.class);
        }
        return new BaseTestSuite("DerbyNetNewServerTest.empty");
    }

    protected void setUp() throws Exception {
        NetworkServerTestSetup.waitForAvailablePort();
    }

    public void testStartWithPrintWriter() throws UnknownHostException, Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(10240);
        PrintWriter writer = new PrintWriter(bos);
        NetworkServerControl server = new NetworkServerControl(InetAddress.getByName(TestConfiguration.getCurrent().getHostName()), TestConfiguration.getCurrent().getPort());
        DerbyNetNewServerTest.assertEquals((String)"No log initially", (int)0, (int)bos.size());
        server.start(writer);
        NetworkServerTestSetup.waitForServerStart(server);
        int sizeAfterPing = bos.size();
        DerbyNetNewServerTest.assertTrue((String)"Create log with start message", (0 < sizeAfterPing ? 1 : 0) != 0);
        server.shutdown();
        int sizeAfterShutDown = bos.size();
        for (int i = 0; i < 60 && sizeAfterShutDown == sizeAfterPing; ++i) {
            Thread.sleep(500L);
            sizeAfterShutDown = bos.size();
        }
        bos.close();
        bos = null;
        writer.close();
        DerbyNetNewServerTest.assertTrue((String)"Num of log item should add", (sizeAfterShutDown > sizeAfterPing ? 1 : 0) != 0);
    }

    public void testStartWithoutPrintWriter() throws UnknownHostException, Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getByName(TestConfiguration.getCurrent().getHostName()), TestConfiguration.getCurrent().getPort());
        server.start(null);
        NetworkServerTestSetup.waitForServerStart(server);
        server.shutdown();
        DerbyNetNewServerTest.assertTrue((boolean)true);
    }
}

