/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.XML;

public final class SecurityManagerSetup
extends TestSetup {
    static final String NO_POLICY = "<NONE>";
    public static final boolean JVM_HAS_SUBJECT_AUTHORIZATION = JDBC.haveClass("javax.security.auth.Subject");
    private static final Properties classPathSet = new Properties();
    static boolean isJars;
    private static final boolean externalSecurityManagerInstalled;
    static final boolean jacocoEnabled;
    private final String decoratorPolicyResource;
    private final String additionalPolicyResource;
    private SecurityManager decoratorSecurityManager = null;

    private static boolean checkIfJacocoIsRunning() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Class.forName("org.jacoco.agent.rt.RT");
                    System.setProperty("jacoco.active", "");
                    return true;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
                catch (LinkageError e) {
                    return false;
                }
            }
        });
    }

    public SecurityManagerSetup(Test test, String policyResource) {
        this(test, policyResource, false);
    }

    public SecurityManagerSetup(Test test, String policyResource, boolean mergePolicies) {
        super(test);
        if (mergePolicies) {
            this.decoratorPolicyResource = SecurityManagerSetup.getDefaultPolicy();
            this.additionalPolicyResource = policyResource;
        } else {
            this.decoratorPolicyResource = policyResource != null ? policyResource : SecurityManagerSetup.getDefaultPolicy();
            this.additionalPolicyResource = null;
        }
    }

    public SecurityManagerSetup(Test test, String policyResource, SecurityManager securityManager) {
        this(test, policyResource, false);
        this.decoratorSecurityManager = securityManager;
    }

    public static Test noSecurityManager(Test test) {
        if (externalSecurityManagerInstalled) {
            return new BaseTestSuite("skipped due to external security manager " + test.toString());
        }
        return new SecurityManagerSetup(test, NO_POLICY);
    }

    static void noSecurityManager() {
        SecurityManagerSetup.installSecurityManager(NO_POLICY);
    }

    protected void setUp() throws IOException {
        String resource = SecurityManagerSetup.getEffectivePolicyResource(this.decoratorPolicyResource, this.additionalPolicyResource);
        SecurityManagerSetup.installSecurityManager(resource, this.decoratorSecurityManager);
    }

    protected void tearDown() throws Exception {
        if (NO_POLICY.equals(this.decoratorPolicyResource)) {
            BaseTestCase.setSystemProperty("java.security.policy", "");
        } else if (!externalSecurityManagerInstalled) {
            SecurityManagerSetup.uninstallSecurityManager();
        }
    }

    private static String getDefaultPolicy() {
        return "org/apache/derbyTesting/functionTests/util/derby_tests.policy";
    }

    static void installSecurityManager() {
        SecurityManagerSetup.installSecurityManager(SecurityManagerSetup.getDefaultPolicy());
    }

    private static void installSecurityManager(String policyFile) {
        SecurityManagerSetup.installSecurityManager(policyFile, System.getSecurityManager());
    }

    private static void installSecurityManager(String policyFile, final SecurityManager sm) {
        if (externalSecurityManagerInstalled) {
            return;
        }
        Properties set = new Properties(classPathSet);
        SecurityManagerSetup.setSecurityPolicy(set, policyFile);
        SecurityManager currentsm = System.getSecurityManager();
        if (currentsm != null) {
            String newPolicyProperty = set.getProperty("java.security.policy");
            if (newPolicyProperty == null) {
                newPolicyProperty = "";
            }
            String oldPolicyProperty = BaseTestCase.getSystemProperty("java.security.policy");
            SecurityManager oldSecMan = System.getSecurityManager();
            if (oldPolicyProperty == null) {
                oldPolicyProperty = "";
            }
            if (newPolicyProperty.equals(oldPolicyProperty) && oldSecMan == sm) {
                return;
            }
            SecurityManagerSetup.uninstallSecurityManager();
        }
        Enumeration<?> e = set.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            BaseTestCase.setSystemProperty(key, set.getProperty(key));
        }
        if (NO_POLICY.equals(set.getProperty("java.security.policy"))) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (sm == null) {
                    System.setSecurityManager(new SecurityManager());
                } else {
                    System.setSecurityManager(sm);
                }
                Policy.getPolicy().refresh();
                return null;
            }
        });
        SecurityManagerSetup.println("installed policy " + policyFile);
    }

    private static void setSecurityPolicy(Properties set, String policyResource) {
        if (NO_POLICY.equals(policyResource)) {
            set.setProperty("java.security.policy", policyResource);
            return;
        }
        try {
            URL policyURL = SecurityManagerSetup.getResourceURL(policyResource);
            set.setProperty("java.security.policy", policyURL.toExternalForm());
        }
        catch (MalformedURLException mue) {
            BaseTestCase.alarm("Unreadable policy URL: " + policyResource);
        }
    }

    private static boolean determineClasspath() {
        URL client;
        boolean isClasspath;
        String jaxp;
        URL emma;
        URL luceneCore;
        URL ant;
        URL antjunit;
        if (System.getSecurityManager() != null) {
            return true;
        }
        URL junit = SecurityManagerSetup.getURL(Test.class);
        if (junit != null) {
            classPathSet.setProperty("derbyTesting.junit", junit.toExternalForm());
        }
        if ((antjunit = SecurityManagerSetup.getURL("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner")) != null) {
            classPathSet.setProperty("derbyTesting.antjunit", antjunit.toExternalForm());
        }
        if ((ant = SecurityManagerSetup.getURL("org.apache.tools.ant.Task")) != null) {
            classPathSet.setProperty("derbyTesting.ant", ant.toExternalForm());
        }
        if ((luceneCore = SecurityManagerSetup.getURL("org.apache.lucene.store.FSDirectory")) != null) {
            classPathSet.setProperty("derbyTesting.lucene.core", luceneCore.toExternalForm());
            classPathSet.setProperty("derbyTesting.lucene.core.jar.file", luceneCore.getFile());
        }
        if ((emma = SecurityManagerSetup.getURL("com.vladium.emma.EMMAException")) != null) {
            classPathSet.setProperty("emma.active", "");
        }
        if ((jaxp = XML.getJAXPParserLocation()) != null) {
            classPathSet.setProperty("derbyTesting.jaxpjar", jaxp);
        }
        URL testing = SecurityManagerSetup.getURL(SecurityManagerSetup.class);
        URL ppTesting = null;
        if (BaseTestCase.getClassVersionMajor() >= 49) {
            ppTesting = SecurityManagerSetup.getURL("org.apache.derby.PackagePrivateTestSuite");
        }
        if (isClasspath = testing.toExternalForm().endsWith("/")) {
            classPathSet.setProperty("derbyTesting.codeclasses", testing.toExternalForm());
            if (ppTesting != null) {
                classPathSet.setProperty("derbyTesting.ppcodeclasses", ppTesting.toExternalForm());
            }
            isJars = false;
            return false;
        }
        classPathSet.setProperty("derbyTesting.testjar", SecurityManagerSetup.stripJar(testing));
        if (testing.getProtocol().equals("file")) {
            File f = new File(testing.getPath());
            classPathSet.setProperty("derbyTesting.testjarpath", f.getAbsolutePath());
        }
        isJars = true;
        URL derby = SecurityManagerSetup.getURL("org.apache.derby.jdbc.BasicEmbeddedDataSource40");
        if (derby != null) {
            classPathSet.setProperty("derbyTesting.codejar", SecurityManagerSetup.stripJar(derby));
        }
        if (!JDBC.vmSupportsJSR169() && (client = SecurityManagerSetup.getURL(JDBC.vmSupportsJNDI() ? "org.apache.derby.jdbc.ClientDataSource" : "org.apache.derby.jdbc.BasicClientDataSource40")) != null) {
            classPathSet.setProperty("derbyTesting.clientjar", SecurityManagerSetup.stripJar(client));
        }
        return false;
    }

    public static Properties getPolicyFilePropertiesForOldHarness() {
        return classPathSet;
    }

    private static String stripJar(URL url) {
        String ef = url.toExternalForm();
        return ef.substring(0, ef.lastIndexOf(47) + 1);
    }

    public static URL getURL(String className) {
        try {
            return SecurityManagerSetup.getURL(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    static URL getURL(final Class cl) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                if (cl.getProtectionDomain().getCodeSource() == null) {
                    return null;
                }
                return cl.getProtectionDomain().getCodeSource().getLocation();
            }
        });
    }

    private static void uninstallSecurityManager() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setSecurityManager(null);
                return null;
            }
        });
    }

    private static String getEffectivePolicyResource(String policy1, String policy2) throws IOException {
        String resource = policy1;
        if (!NO_POLICY.equals(resource)) {
            URL url1 = SecurityManagerSetup.getResourceURL(policy1);
            resource = url1.toExternalForm();
            if (policy2 != null) {
                URL url2 = SecurityManagerSetup.getResourceURL(policy2);
                if (!url1.toExternalForm().equals(url2.toExternalForm())) {
                    resource = SecurityManagerSetup.mergePolicies(url1, url2);
                }
            }
        }
        return resource;
    }

    private static URL getResourceURL(String policy) throws MalformedURLException {
        URL url = BaseTestCase.getTestResource(policy);
        if (url == null) {
            url = new URL(policy);
        }
        return url;
    }

    private static String mergePolicies(URL policy1, URL policy2) throws IOException {
        int read;
        String sytemHome = BaseTestCase.getSystemProperty("derby.system.home");
        File sysDir = new File(sytemHome == null ? "system" : sytemHome);
        File varDir = new File(sysDir, "var");
        SecurityManagerSetup.mkdir(sysDir);
        SecurityManagerSetup.mkdir(varDir);
        final File mergedPF = new File(varDir, new File(policy2.getPath()).getName() + "-MERGED_WITH-" + new File(policy1.getPath()).getName());
        FileOutputStream o = PrivilegedFileOpsForTests.getFileOutputStream(mergedPF);
        byte[] buf = new byte[1024];
        InputStream i1 = SecurityManagerSetup.openStream(policy1);
        while ((read = i1.read(buf)) != -1) {
            ((OutputStream)o).write(buf, 0, read);
        }
        i1.close();
        InputStream i2 = SecurityManagerSetup.openStream(policy2);
        while ((read = i2.read(buf)) != -1) {
            ((OutputStream)o).write(buf, 0, read);
        }
        i2.close();
        ((OutputStream)o).close();
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws MalformedURLException {
                    return mergedPF.toURI().toURL().toExternalForm();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (MalformedURLException)pae.getException();
        }
    }

    private static InputStream openStream(final URL resource) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return resource.openStream();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private static void mkdir(final File dir) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (!dir.exists() && !dir.mkdir()) {
                    Assert.fail((String)("failed to create directory: " + dir.getPath()));
                }
                return null;
            }
        });
    }

    private static void println(String msg) {
        BaseTestCase.println("{SecurityManagerSetup} " + msg);
    }

    static {
        externalSecurityManagerInstalled = SecurityManagerSetup.determineClasspath();
        if (BaseTestCase.isJ9Platform()) {
            BaseTestCase.setSystemProperty("emma.active", "");
            BaseTestCase.setSystemProperty("jacoco.active", "");
        }
        jacocoEnabled = SecurityManagerSetup.checkIfJacocoIsRunning();
    }
}

