/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTreeScan;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;
import org.apache.derby.shared.common.sanity.SanityManager;

public class BTreeRowPosition
extends RowPosition {
    public DataValueDescriptor[] current_positionKey;
    public LeafControlRow current_leaf;
    protected LeafControlRow next_leaf;
    public DataValueDescriptor[] current_lock_template;
    public RowLocation current_lock_row_loc;
    private final BTreeScan parent;
    long versionWhenSaved;
    private DataValueDescriptor[] positionKey_template;
    private FetchDescriptor savedFetchDescriptor;

    public BTreeRowPosition(BTreeScan parent) {
        this.parent = parent;
    }

    @Override
    public void init() {
        super.init();
        this.current_leaf = null;
        this.current_positionKey = null;
    }

    @Override
    public final void unlatch() {
        SanityManager.THROWASSERT("Did you really call me?!?");
        if (this.current_leaf != null) {
            this.current_leaf.release();
            this.current_leaf = null;
        }
        this.current_slot = -1;
    }

    public void saveMeAndReleasePage() throws StandardException {
        SanityManager.ASSERT(this.parent.scan_position == this);
        this.parent.savePositionAndReleasePage();
    }

    DataValueDescriptor[] getKeyTemplate() throws StandardException {
        if (this.positionKey_template == null) {
            this.positionKey_template = this.parent.getRuntimeMem().get_row_for_export(this.parent.getRawTran());
        }
        return this.positionKey_template;
    }

    FetchDescriptor getFetchDescriptorForSaveKey(int[] vcols, int fullLength) {
        FormatableBitSet fetchCols;
        int i;
        if (this.savedFetchDescriptor == null) {
            FormatableBitSet columns = new FormatableBitSet(fullLength);
            for (i = 0; i < vcols.length; ++i) {
                if (vcols[i] != 0) continue;
                columns.set(i);
            }
            for (i = vcols.length; i < fullLength; ++i) {
                columns.set(i);
            }
            this.savedFetchDescriptor = new FetchDescriptor(fullLength, columns, null);
        }
        SanityManager.ASSERT(fullLength == (fetchCols = this.savedFetchDescriptor.getValidColumns()).size());
        for (i = 0; i < vcols.length; ++i) {
            SanityManager.ASSERT(vcols[i] == 0 == fetchCols.get(i));
        }
        for (i = vcols.length; i < fullLength; ++i) {
            SanityManager.ASSERT(fetchCols.get(i));
        }
        return this.savedFetchDescriptor;
    }

    @Override
    public final String toString() {
        String ret_string = null;
        ret_string = super.toString() + "current_positionKey = " + this.current_positionKey + ";key = " + RowUtil.toString(this.current_positionKey) + ";next_leaf" + this.next_leaf + ";current_leaf" + this.current_leaf;
        return ret_string;
    }
}

