/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Version;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Changes10_11
extends UpgradeChange {
    private static final String SYNTAX_ERROR = "42X01";
    private static final String HARD_UPGRADE_REQUIRED = "XCL47";
    private static final String NOT_IMPLEMENTED = "0A000";
    private static final String NO_ROWS_AFFECTED = "02000";
    private static final String UNKNOWN_OPTIONAL_TOOL = "X0Y88";
    private static final String UNRECOGNIZED_PROCEDURE = "42Y03";

    public Changes10_11(String name) {
        super(name);
    }

    public static Test suite(int phase) {
        return new BaseTestSuite(Changes10_11.class, "Upgrade test for 10.11");
    }

    public void testTriggerWhenClause() throws SQLException {
        String createTrigger = "create trigger d534_tr1 after insert on d534_t1 referencing new as new for each row mode db2sql when (new.x <> 2) insert into d534_t2 values new.x";
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                s.execute("create table d534_t1(x int)");
                s.execute("create table d534_t2(y int)");
                this.assertCompileError(SYNTAX_ERROR, createTrigger);
                break;
            }
            case 1: {
                this.assertCompileError(HARD_UPGRADE_REQUIRED, createTrigger);
                break;
            }
            case 2: {
                this.assertCompileError(SYNTAX_ERROR, createTrigger);
                break;
            }
            case 3: {
                s.execute(createTrigger);
                s.execute("insert into d534_t1 values 1, 2, 3");
                JDBC.assertFullResultSet(s.executeQuery("select * from d534_t2 order by y"), new String[][]{{"1"}, {"3"}});
            }
        }
    }

    public void testDropTriggerDependencies() throws SQLException {
        if (!this.oldAtLeast(10, 2)) {
            return;
        }
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                s.execute("create table d2041_t(x int)");
                s.execute("create table d2041_table(x int)");
                s.execute("create table d2041_synonym_table(x int)");
                s.execute("create synonym d2041_synonym for d2041_synonym_table");
                s.execute("create view d2041_view(x) as values 1");
                s.execute("create function d2041_func(i int) returns int language java parameter style java external name 'java.lang.Math.abs' no sql");
                s.execute("create procedure d2041_proc() language java parameter style java external name 'java.lang.Thread.yield' no sql");
                this.createDerby2041Triggers(s);
                this.commit();
                break;
            }
            case 1: {
                this.dropDerby2041TriggerDeps(s, false);
                this.dropDerby2041Triggers(s);
                this.rollback();
                this.dropDerby2041Triggers(s);
                this.createDerby2041Triggers(s);
                this.commit();
                this.dropDerby2041TriggerDeps(s, true);
                break;
            }
            case 2: {
                Changes10_11.assertStatementError("X0Y25", s, "drop table d2041_table");
                Changes10_11.assertStatementError("X0Y25", s, "drop synonym d2041_synonym");
                s.execute("drop view d2041_view");
                s.execute("drop function d2041_func");
                s.execute("drop procedure d2041_proc");
                this.rollback();
                break;
            }
            case 3: {
                this.dropDerby2041TriggerDeps(s, true);
            }
        }
    }

    private void createDerby2041Triggers(Statement s) throws SQLException {
        s.execute("create trigger d2041_tr1 after insert on d2041_t for each row mode db2sql insert into d2041_table values 1");
        s.execute("create trigger d2041_tr2 after insert on d2041_t for each row mode db2sql insert into d2041_synonym values 1");
        s.execute("create trigger d2041_tr3 after insert on d2041_t for each row mode db2sql select * from d2041_view");
        s.execute("create trigger d2041_tr4 after insert on d2041_t for each row mode db2sql values d2041_func(1)");
        s.execute("create trigger d2041_tr5 after insert on d2041_t for each row mode db2sql call d2041_proc()");
    }

    private void dropDerby2041Triggers(Statement s) throws SQLException {
        for (int i = 1; i <= 5; ++i) {
            s.execute("drop trigger d2041_tr" + i);
        }
    }

    private void dropDerby2041TriggerDeps(Statement s, boolean expectFailure) throws SQLException {
        String[] stmts;
        for (String stmt : stmts = new String[]{"drop table d2041_table", "drop synonym d2041_synonym", "drop view d2041_view", "drop function d2041_func", "drop procedure d2041_proc"}) {
            if (expectFailure) {
                Changes10_11.assertStatementError("X0Y25", s, stmt);
                continue;
            }
            Changes10_11.assertUpdateCount(s, 0, stmt);
        }
    }

    public void testDerby5866TriggerExecutionOrder() throws SQLException {
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                s.execute("create table d5866_t1(x int)");
                s.execute("create table d5866_t2(x int generated always as identity, y varchar(100))");
                s.execute("create trigger d5866_create after insert on d5866_t1 for each statement mode db2sql insert into d5866_t2(y) values 'CREATE'");
                break;
            }
            case 1: {
                s.execute("create trigger d5866_soft after insert on d5866_t1 insert into d5866_t2(y) values 'SOFT UPGRADE'");
                break;
            }
            case 2: {
                s.execute("create trigger d5866_post_soft after insert on d5866_t1 for each statement mode db2sql insert into d5866_t2(y) values 'POST SOFT UPGRADE'");
                break;
            }
            case 3: {
                s.execute("create trigger d5866_hard after insert on d5866_t1 insert into d5866_t2(y) values 'HARD UPGRADE'");
                s.execute("insert into d5866_t1 values 1,2,3");
                JDBC.assertFullResultSet(s.executeQuery("select y from d5866_t2 order by x"), new String[][]{{"CREATE"}, {"SOFT UPGRADE"}, {"POST SOFT UPGRADE"}, {"HARD UPGRADE"}});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeferrableConstraints() throws SQLException {
        if (!this.oldAtLeast(10, 4)) {
            return;
        }
        this.setAutoCommit(false);
        Statement st = this.createStatement();
        String[] cDeferrableCol = new String[]{"create table t532(i int not null primary key deferrable)", "create table t532(i int unique deferrable)", "create table t532(i int not null unique deferrable)", "create table t532(i int check (i > 0) deferrable)", "create table t532(i int references referenced(i) deferrable)"};
        String[] cDeferrableTab = new String[]{"create table t532(i int not null, constraint c primary key(i) deferrable)", "create table t532(i int, constraint c unique(i) deferrable)", "create table t532(i int not null, constraint c unique(i) deferrable)", "create table t532(i int, constraint c check (i > 0) deferrable)", "create table t532(i int, constraint c foreign key(i) references referenced(i) deferrable)"};
        st.executeUpdate("create table referenced(i int primary key)");
        this.commit();
        try {
            switch (this.getPhase()) {
                case 0: {
                    String[] stringArray = cDeferrableCol;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        Changes10_11.assertStatementError(SYNTAX_ERROR, st, s);
                        Changes10_11.assertStatementError(SYNTAX_ERROR, st, s);
                        ++n2;
                    }
                    return;
                }
                case 2: {
                    String[] stringArray = cDeferrableCol;
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String s = stringArray[n3];
                        Changes10_11.assertStatementError(SYNTAX_ERROR, st, s);
                        Changes10_11.assertStatementError(SYNTAX_ERROR, st, s);
                        ++n3;
                    }
                    return;
                }
                case 1: {
                    String[] stringArray = cDeferrableCol;
                    int n = stringArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        String s = stringArray[n4];
                        Changes10_11.assertStatementError(HARD_UPGRADE_REQUIRED, st, s);
                        Changes10_11.assertStatementError(HARD_UPGRADE_REQUIRED, st, s);
                        ++n4;
                    }
                    return;
                }
                case 3: {
                    String[] stringArray = cDeferrableCol;
                    int n = stringArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        String s = stringArray[n5];
                        st.execute(s);
                        this.rollback();
                        st.execute(s);
                        this.rollback();
                        ++n5;
                    }
                    return;
                }
            }
            return;
        }
        finally {
            st.executeUpdate("drop table referenced");
            this.commit();
        }
    }

    public void testMerge() throws Exception {
        String mergeStatement = "merge into targetTable t using sourceTable s on t.a = s.a\nwhen matched then delete\n";
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                s.execute("create table targetTable( a int )");
                s.execute("create table sourceTable( a int )");
                this.assertCompileError(SYNTAX_ERROR, mergeStatement);
                break;
            }
            case 1: {
                this.assertCompileError(HARD_UPGRADE_REQUIRED, mergeStatement);
                break;
            }
            case 2: {
                this.assertCompileError(SYNTAX_ERROR, mergeStatement);
                break;
            }
            case 3: {
                this.expectExecutionWarning(this.getConnection(), NO_ROWS_AFFECTED, mergeStatement);
            }
        }
    }

    public void test_derby6692() throws Exception {
        Connection conn = this.getConnection();
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                boolean originalAutoCommit = conn.getAutoCommit();
                try {
                    conn.setAutoCommit(false);
                    conn.prepareStatement("create table t_6692(i int generated always as identity)").execute();
                    conn.prepareStatement("insert into t_6692 values (default)").execute();
                    conn.rollback();
                    break;
                }
                finally {
                    conn.setAutoCommit(originalAutoCommit);
                }
            }
        }
    }

    public void testLuceneSupport() throws Exception {
        boolean hasOptionalTools;
        Properties properties = TestConfiguration.getSystemProperties();
        if (Changes10_11.getBooleanProperty(properties, "derby.tests.omitLucene")) {
            return;
        }
        Version initialVersion = new Version(this.getOldMajor(), this.getOldMinor(), 0, 0);
        Version firstVersionHavingBooleanType = new Version(10, 7, 0, 0);
        Version firstVersionHavingOptionalTools = new Version(10, 10, 0, 0);
        boolean hasBooleanDatatype = initialVersion.compareTo(firstVersionHavingBooleanType) >= 0;
        boolean bl = hasOptionalTools = initialVersion.compareTo(firstVersionHavingOptionalTools) >= 0;
        String originalSQLState = !hasBooleanDatatype ? SYNTAX_ERROR : (!hasOptionalTools ? UNRECOGNIZED_PROCEDURE : UNKNOWN_OPTIONAL_TOOL);
        String softUpgradeSQLState = !hasOptionalTools ? UNRECOGNIZED_PROCEDURE : HARD_UPGRADE_REQUIRED;
        String loadTool = "call syscs_util.syscs_register_tool( 'luceneSupport', true )";
        String unloadTool = "call syscs_util.syscs_register_tool( 'luceneSupport', false )";
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                Changes10_11.assertStatementError(originalSQLState, statement, loadTool);
                break;
            }
            case 1: {
                Changes10_11.assertStatementError(softUpgradeSQLState, statement, loadTool);
                break;
            }
            case 3: {
                statement.executeUpdate(loadTool);
                statement.executeUpdate(unloadTool);
            }
        }
    }

    public void testIdentitySequence() throws Exception {
        Version firstVersionHavingSequences;
        Properties properties = TestConfiguration.getSystemProperties();
        if (Changes10_11.getBooleanProperty(properties, "derby.tests.omitLucene")) {
            return;
        }
        Version initialVersion = new Version(this.getOldMajor(), this.getOldMinor(), 0, 0);
        boolean hasSequences = initialVersion.compareTo(firstVersionHavingSequences = new Version(10, 6, 0, 0)) >= 0;
        Statement statement = this.createStatement();
        String peek = "values syscs_util.syscs_peek_at_identity( 'APP', 'IDSEQ1' )";
        switch (this.getPhase()) {
            case 0: {
                statement.executeUpdate("create function uuidToSequenceName( uuid char( 36 ) ) returns varchar( 128 )\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.IdentitySequenceTest.uuidToSequenceName'\n");
                statement.executeUpdate("create table idseq1( a int generated always as identity ( start with 10, increment by 20 ), b int )");
                statement.executeUpdate("insert into idseq1( b ) values ( 1 ), ( 20 )");
                if (hasSequences) {
                    Changes10_11.assertEquals((int)0, (int)this.countSequences(statement));
                }
                Changes10_11.assertStatementError(UNRECOGNIZED_PROCEDURE, statement, peek);
                break;
            }
            case 2: {
                statement.executeUpdate("create table idseq2( a int generated always as identity, b int )");
                if (hasSequences) {
                    Changes10_11.assertEquals((int)0, (int)this.countSequences(statement));
                }
                Changes10_11.assertStatementError(UNRECOGNIZED_PROCEDURE, statement, peek);
                break;
            }
            case 1: {
                statement.executeUpdate("create table idseq3( a int generated always as identity, b int )");
                if (hasSequences) {
                    Changes10_11.assertEquals((int)0, (int)this.countSequences(statement));
                }
                Changes10_11.assertStatementError(UNRECOGNIZED_PROCEDURE, statement, peek);
                break;
            }
            case 3: {
                statement.executeUpdate("create table idseq4( a int generated always as identity, b int )");
                Changes10_11.assertEquals((int)4, (int)this.count(statement, "select count(*)\nfrom sys.systables t, sys.syssequences s\nwhere uuidToSequenceName( t.tableid ) = s.sequencename\nand t.tablename like 'IDSEQ%'"));
                JDBC.assertFullResultSet(statement.executeQuery(peek), new String[][]{{"50"}});
                JDBC.assertFullResultSet(statement.executeQuery("select sch.schemaName,\ns.currentvalue, s.startvalue, s.minimumvalue, s.maximumvalue, s.increment, s.cycleoption\nfrom sys.sysschemas sch, sys.systables t, sys.syssequences s\nwhere t.tablename = 'IDSEQ1'\nand uuidToSequenceName( t.tableid ) = s.sequencename\nand sch.schemaid = s.schemaid\n"), new String[][]{{"SYS", "50", "10", "-2147483648", "2147483647", "20", "N"}});
            }
        }
    }

    private int countSequences(Statement statement) throws Exception {
        return this.count(statement, "select count(*) from sys.syssequences");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int count(Statement statement, String query) throws Exception {
        ResultSet rs = statement.executeQuery(query);
        rs.next();
        try {
            int n = rs.getInt(1);
            return n;
        }
        finally {
            rs.close();
        }
    }

    private static boolean getBooleanProperty(Properties properties, String key) {
        return Boolean.valueOf(properties.getProperty(key));
    }

    private void expectExecutionWarning(Connection conn, String sqlState, String query) throws Exception {
        this.expectExecutionWarnings(conn, new String[]{sqlState}, query);
    }

    private void expectExecutionWarnings(Connection conn, String[] sqlStates, String query) throws Exception {
        Changes10_11.println("\nExpecting warnings " + this.fill(sqlStates).toString() + " when executing:\n\t");
        PreparedStatement ps = this.chattyPrepare(conn, query);
        ps.execute();
        int idx = 0;
        for (SQLWarning sqlWarning = ps.getWarnings(); sqlWarning != null; sqlWarning = sqlWarning.getNextWarning()) {
            String actualSQLState = sqlWarning.getSQLState();
            if (idx >= sqlStates.length) {
                Changes10_11.fail((String)"Got more warnings than we expected.");
            }
            String expectedSqlState = sqlStates[idx++];
            Changes10_11.assertEquals((String)expectedSqlState, (String)actualSQLState);
        }
        Changes10_11.assertEquals((int)idx, (int)sqlStates.length);
        ps.close();
    }

    protected <T> ArrayList<T> fill(T[] raw) {
        return new ArrayList<T>(Arrays.asList(raw));
    }
}

