/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.quantiles.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetPMF", value="_FUNC_(sketch, [inclusive,] split points...)", extended="Returns an approximation to the Probability Mass Function (PMF) from a sketch given a set of split points (values). The optional boolean parameter 'inclusive' (default: true) determines whether the rank of an item includes its own weight. If true, such items are included in the interval to the left of the split point; otherwise they are included in the interval to the right of the split point. Split points are an array of M unique, monotonically increasing values that divide the real number line into M+1 consecutive disjoint intervals. The function returns an array of M+1 doubles, each of which is an approximation to the fraction of the values that fell into one of those intervals. The definition of an interval is inclusive of the left split point and exclusive of the right split point")
public class GetPmfFromDoublesSketchUDF
extends UDF {
    public List<Double> evaluate(BytesWritable serializedSketch, Double ... splitPoints) {
        return this.evaluate(serializedSketch, true, splitPoints);
    }

    public List<Double> evaluate(BytesWritable serializedSketch, Boolean inclusive, Double ... splitPoints) {
        if (serializedSketch == null) {
            return null;
        }
        DoublesSketch sketch = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch));
        if (sketch.isEmpty()) {
            return null;
        }
        double[] pmf = sketch.getPMF(Util.objectsToPrimitives(splitPoints), inclusive != false ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE);
        if (pmf == null) {
            return null;
        }
        return Util.primitivesToList(pmf);
    }
}

