/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.quantiles.DataToDoublesSketchUDAFTest;
import org.apache.datasketches.hive.quantiles.ItemsUnionState;
import org.apache.datasketches.hive.quantiles.UnionStringsSketchUDAF;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionStringsSketchUDAFTest {
    static final Comparator<String> comparator = Comparator.naturalOrder();
    static final ArrayOfItemsSerDe<String> serDe = new ArrayOfStringsSerDe();
    static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    static final ObjectInspector intInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT);
    static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("a"), Arrays.asList(binaryInspector));

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorTooFewInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorTooManyInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector, binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongCategoryArg1() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{structInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongTypeArg1() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongCategoryArg2() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, structInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongTypeArg2() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test
    public void partial1ModeDefaultKDownsizeInput() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            ItemsUnionState state = (ItemsUnionState)eval.getNewAggregationBuffer();
            ItemsSketch sketch1 = ItemsSketch.getInstance(String.class, (int)256, comparator);
            sketch1.update((Object)"a");
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.toByteArray(serDe))});
            ItemsSketch sketch2 = ItemsSketch.getInstance(String.class, (int)256, comparator);
            sketch2.update((Object)"b");
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.toByteArray(serDe))});
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            ItemsSketch resultSketch = ItemsSketch.getInstance(String.class, (Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes), comparator, serDe);
            Assert.assertEquals((int)resultSketch.getK(), (int)128);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((String)((String)resultSketch.getMinItem()), (String)"a");
            Assert.assertEquals((String)((String)resultSketch.getMaxItem()), (String)"b");
        }
    }

    @Test
    public void partial1ModeGivenK() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            ItemsUnionState state = (ItemsUnionState)eval.getNewAggregationBuffer();
            ItemsSketch sketch1 = ItemsSketch.getInstance(String.class, (int)256, comparator);
            sketch1.update((Object)"a");
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.toByteArray(serDe)), new IntWritable(256)});
            ItemsSketch sketch2 = ItemsSketch.getInstance(String.class, (int)256, comparator);
            sketch2.update((Object)"b");
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.toByteArray(serDe)), new IntWritable(256)});
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            ItemsSketch resultSketch = ItemsSketch.getInstance(String.class, (Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes), comparator, serDe);
            Assert.assertEquals((int)resultSketch.getK(), (int)256);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((String)((String)resultSketch.getMinItem()), (String)"a");
            Assert.assertEquals((String)((String)resultSketch.getMaxItem()), (String)"b");
        }
    }

    @Test
    public void partial2Mode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            ItemsUnionState state = (ItemsUnionState)eval.getNewAggregationBuffer();
            ItemsSketch sketch1 = ItemsSketch.getInstance(String.class, (int)256, comparator);
            sketch1.update((Object)"a");
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch1.toByteArray(serDe)));
            ItemsSketch sketch2 = ItemsSketch.getInstance(String.class, (int)256, comparator);
            sketch2.update((Object)"b");
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch2.toByteArray(serDe)));
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            ItemsSketch resultSketch = ItemsSketch.getInstance(String.class, (Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes), comparator, serDe);
            Assert.assertEquals((int)resultSketch.getK(), (int)256);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((String)((String)resultSketch.getMinItem()), (String)"a");
            Assert.assertEquals((String)((String)resultSketch.getMaxItem()), (String)"b");
        }
    }

    @Test
    public void finalMode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.FINAL, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            ItemsUnionState state = (ItemsUnionState)eval.getNewAggregationBuffer();
            ItemsSketch sketch1 = ItemsSketch.getInstance(String.class, (int)256, comparator);
            sketch1.update((Object)"a");
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch1.toByteArray(serDe)));
            ItemsSketch sketch2 = ItemsSketch.getInstance(String.class, (int)256, comparator);
            sketch2.update((Object)"b");
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch2.toByteArray(serDe)));
            BytesWritable bytes = (BytesWritable)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            ItemsSketch resultSketch = ItemsSketch.getInstance(String.class, (Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes), comparator, serDe);
            Assert.assertEquals((int)resultSketch.getK(), (int)256);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((String)((String)resultSketch.getMinItem()), (String)"a");
            Assert.assertEquals((String)((String)resultSketch.getMaxItem()), (String)"b");
        }
    }

    @Test
    public void complete1ModeDefaultK() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToDoublesSketchUDAFTest.checkResultInspector(resultInspector);
            ItemsUnionState state = (ItemsUnionState)eval.getNewAggregationBuffer();
            ItemsSketch sketch1 = ItemsSketch.getInstance(String.class, comparator);
            sketch1.update((Object)"a");
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.toByteArray(serDe))});
            ItemsSketch sketch2 = ItemsSketch.getInstance(String.class, comparator);
            sketch2.update((Object)"b");
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.toByteArray(serDe))});
            BytesWritable bytes = (BytesWritable)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            ItemsSketch resultSketch = ItemsSketch.getInstance(String.class, (Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes), comparator, serDe);
            Assert.assertEquals((int)resultSketch.getK(), (int)128);
            Assert.assertEquals((int)resultSketch.getNumRetained(), (int)2);
            Assert.assertEquals((String)((String)resultSketch.getMinItem()), (String)"a");
            Assert.assertEquals((String)((String)resultSketch.getMaxItem()), (String)"b");
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state));
        }
    }
}

