/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.cpc;

import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.hive.cpc.GetEstimateUDF;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetEstimateUDFTest {
    @Test
    public void nullSketch() {
        Double result = new GetEstimateUDF().evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptySketch() {
        CpcSketch sketch = new CpcSketch(12);
        Double result = new GetEstimateUDF().evaluate(new BytesWritable(sketch.toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)0.0);
    }

    @Test
    public void normalCase() {
        CpcSketch sketch = new CpcSketch(12);
        sketch.update(1L);
        sketch.update(2L);
        Double result = new GetEstimateUDF().evaluate(new BytesWritable(sketch.toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)2.0, (double)0.01);
    }

    @Test
    public void customSeed() {
        long seed = 123L;
        CpcSketch sketch = new CpcSketch(12, 123L);
        sketch.update(1L);
        sketch.update(2L);
        Double result = new GetEstimateUDF().evaluate(new BytesWritable(sketch.toByteArray()), 123L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)2.0, (double)0.01);
    }
}

