/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.transfer.dialect.fragment;

import jakarta.annotation.Resource;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.ws.WebServiceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.ws.transfer.Create;
import org.apache.cxf.ws.transfer.Delete;
import org.apache.cxf.ws.transfer.Get;
import org.apache.cxf.ws.transfer.Put;
import org.apache.cxf.ws.transfer.Representation;
import org.apache.cxf.ws.transfer.dialect.Dialect;
import org.apache.cxf.ws.transfer.dialect.fragment.ExpressionType;
import org.apache.cxf.ws.transfer.dialect.fragment.Fragment;
import org.apache.cxf.ws.transfer.dialect.fragment.ObjectFactory;
import org.apache.cxf.ws.transfer.dialect.fragment.ValueType;
import org.apache.cxf.ws.transfer.dialect.fragment.faults.InvalidExpression;
import org.apache.cxf.ws.transfer.dialect.fragment.faults.UnsupportedLanguage;
import org.apache.cxf.ws.transfer.dialect.fragment.faults.UnsupportedMode;
import org.apache.cxf.ws.transfer.dialect.fragment.language.FragmentDialectLanguage;
import org.apache.cxf.ws.transfer.dialect.fragment.language.FragmentDialectLanguageQName;
import org.apache.cxf.ws.transfer.dialect.fragment.language.FragmentDialectLanguageXPath10;
import org.apache.cxf.ws.transfer.shared.faults.InvalidRepresentation;
import org.apache.cxf.ws.transfer.shared.faults.UnknownDialect;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FragmentDialect
implements Dialect {
    @Resource
    WebServiceContext context;
    private final Map<String, FragmentDialectLanguage> languages = new HashMap<String, FragmentDialectLanguage>();
    private final Pattern badXPathPattern = Pattern.compile("//@?" + FragmentDialectLanguageQName.getQNamePatternString() + "$");
    private final Pattern goodXPathPattern = Pattern.compile("/@?" + FragmentDialectLanguageQName.getQNamePatternString() + "$");

    public FragmentDialect() {
        this.languages.put("http://www.w3.org/2011/03/ws-fra/QName", new FragmentDialectLanguageQName());
        this.languages.put("http://www.w3.org/2011/03/ws-fra/XPath10", new FragmentDialectLanguageXPath10());
    }

    public JAXBElement<ValueType> processGet(Get body, Representation representation) {
        for (Object o : body.getAny()) {
            if (!(o instanceof JAXBElement) || ((JAXBElement)o).getDeclaredType() != ExpressionType.class) continue;
            ExpressionType expression = (ExpressionType)((JAXBElement)o).getValue();
            String languageIRI = expression.getLanguage();
            String string = languageIRI = languageIRI == null ? "http://www.w3.org/2011/03/ws-fra/XPath10" : languageIRI;
            if (this.languages.containsKey(languageIRI)) {
                FragmentDialectLanguage language = this.languages.get(languageIRI);
                return this.generateGetResponse(language.getResourceFragment(representation, expression));
            }
            throw new UnsupportedLanguage();
        }
        throw new SoapFault("wsf:Expression is not present.", this.getSoapVersion().getSender());
    }

    @Override
    public Representation processPut(Put body, Representation representation) {
        for (Object o : body.getAny()) {
            String languageIRI;
            if (!(o instanceof Fragment)) continue;
            Fragment fragment = (Fragment)o;
            ExpressionType expression = fragment.getExpression();
            ValueType value = fragment.getValue();
            if (expression == null) {
                throw new SoapFault("wsf:Expression is not present.", this.getSoapVersion().getSender());
            }
            if (value == null) {
                value = new ValueType();
            }
            String string = languageIRI = (languageIRI = expression.getLanguage()) == null ? "http://www.w3.org/2011/03/ws-fra/XPath10" : languageIRI;
            if (this.languages.containsKey(languageIRI)) {
                FragmentDialectLanguage language = this.languages.get(languageIRI);
                Object resourceFragment = language.getResourceFragment(representation, expression);
                String mode = expression.getMode();
                String string2 = mode = mode == null ? "http://www.w3.org/2011/03/ws-fra/Modes/Replace" : mode;
                if (resourceFragment == null && "http://www.w3.org/2011/03/ws-fra/Modes/Replace".equals(mode) && "http://www.w3.org/2011/03/ws-fra/XPath10".equals(languageIRI)) {
                    resourceFragment = language.getResourceFragment(representation, this.getParentXPath(expression));
                    mode = "http://www.w3.org/2011/03/ws-fra/Modes/Add";
                }
                return this.modifyRepresentation(resourceFragment, mode, value);
            }
            throw new UnsupportedLanguage();
        }
        throw new SoapFault("wsf:Fragment is not present.", this.getSoapVersion().getSender());
    }

    @Override
    public boolean processDelete(Delete body, Representation representation) {
        throw new UnknownDialect();
    }

    @Override
    public Representation processCreate(Create body) {
        throw new UnknownDialect();
    }

    public void registerLanguage(String iri, FragmentDialectLanguage language) {
        if (this.languages.containsKey(iri)) {
            throw new IllegalArgumentException(String.format("IRI \"%s\" is already registered", iri));
        }
        this.languages.put(iri, language);
    }

    public void unregisterLanguage(String iri) {
        if (!this.languages.containsKey(iri)) {
            throw new IllegalArgumentException(String.format("IRI \"%s\" is not registered", iri));
        }
        this.languages.remove(iri);
    }

    private JAXBElement<ValueType> generateGetResponse(Object value) {
        if (value instanceof Node) {
            return this.generateGetResponseNode((Node)value);
        }
        if (value instanceof NodeList) {
            return this.generateGetResponseNodeList((NodeList)value);
        }
        if (value instanceof String) {
            return this.generateGetResponseString((String)value);
        }
        ObjectFactory objectFactory = new ObjectFactory();
        return objectFactory.createValue(new ValueType());
    }

    private JAXBElement<ValueType> generateGetResponseNodeList(NodeList nodeList) {
        ValueType resultValue = new ValueType();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            resultValue.getContent().add(nodeList.item(i));
        }
        ObjectFactory objectFactory = new ObjectFactory();
        return objectFactory.createValue(resultValue);
    }

    private JAXBElement<ValueType> generateGetResponseNode(Node node) {
        Document doc = DOMUtils.getEmptyDocument();
        ValueType resultValue = new ValueType();
        if (node.getNodeType() == 2) {
            Element attrNodeEl = doc.createElementNS("http://www.w3.org/2011/03/ws-fra", "AttributeNode");
            attrNodeEl.setAttribute("name", node.getNodeName());
            attrNodeEl.setTextContent(node.getNodeValue());
            resultValue.getContent().add(attrNodeEl);
        } else if (node.getNodeType() == 3) {
            Element textNodeEl = doc.createElementNS("http://www.w3.org/2011/03/ws-fra", "TextNode");
            textNodeEl.setNodeValue(node.getNodeValue());
            resultValue.getContent().add(textNodeEl);
        } else if (node.getNodeType() == 1) {
            resultValue.getContent().add(node);
        }
        ObjectFactory objectFactory = new ObjectFactory();
        return objectFactory.createValue(resultValue);
    }

    private JAXBElement<ValueType> generateGetResponseString(String value) {
        ValueType resultValue = new ValueType();
        resultValue.getContent().add(value);
        ObjectFactory objectFactory = new ObjectFactory();
        return objectFactory.createValue(resultValue);
    }

    private ExpressionType getParentXPath(ExpressionType expression) {
        if (expression.getContent().size() != 1) {
            throw new InvalidExpression();
        }
        String expr = (String)expression.getContent().get(0);
        if (this.badXPathPattern.matcher(expr).find()) {
            throw new InvalidExpression();
        }
        if (this.goodXPathPattern.matcher(expr).find()) {
            expression.getContent().clear();
            expr = expr.replaceFirst(this.goodXPathPattern.pattern(), "");
            if (expr.isEmpty()) {
                expr = "/";
            }
            expression.getContent().add(expr);
            return expression;
        }
        throw new InvalidExpression();
    }

    private Representation modifyRepresentation(Object resourceFragment, String mode, ValueType value) {
        if (resourceFragment instanceof Node) {
            ArrayList<Node> nodeList = new ArrayList<Node>();
            nodeList.add((Node)resourceFragment);
            return this.modifyRepresentationMode(nodeList, mode, value);
        }
        if (resourceFragment instanceof NodeList) {
            NodeList rfNodeList = (NodeList)resourceFragment;
            ArrayList<Node> nodeList = new ArrayList<Node>();
            for (int i = 0; i < rfNodeList.getLength(); ++i) {
                nodeList.add(rfNodeList.item(i));
            }
            return this.modifyRepresentationMode(nodeList, mode, value);
        }
        throw new InvalidExpression();
    }

    private Representation modifyRepresentationMode(List<Node> nodeList, String mode, ValueType value) {
        switch (mode) {
            case "http://www.w3.org/2011/03/ws-fra/Modes/Replace": {
                return this.modifyRepresentationModeReplace(nodeList, value);
            }
            case "http://www.w3.org/2011/03/ws-fra/Modes/Add": {
                return this.modifyRepresentationModeAdd(nodeList, value);
            }
            case "http://www.w3.org/2011/03/ws-fra/Modes/InsertBefore": {
                return this.modifyRepresentationModeInsertBefore(nodeList, value);
            }
            case "http://www.w3.org/2011/03/ws-fra/Modes/InsertAfter": {
                return this.modifyRepresentationModeInsertAfter(nodeList, value);
            }
            case "http://www.w3.org/2011/03/ws-fra/Modes/Remove": {
                return this.modifyRepresentationModeRemove(nodeList, value);
            }
        }
        throw new UnsupportedMode();
    }

    private Representation modifyRepresentationModeReplace(List<Node> nodeList, ValueType value) {
        if (nodeList.isEmpty()) {
            throw new InvalidExpression();
        }
        Node firstNode = nodeList.get(0);
        Document ownerDocument = firstNode.getOwnerDocument();
        ownerDocument = ownerDocument == null ? (Document)firstNode : ownerDocument;
        Node nextSibling = null;
        Node parent = null;
        for (Node node : nodeList) {
            nextSibling = node.getNextSibling();
            parent = this.removeNode(node);
        }
        this.addNode(ownerDocument, parent, nextSibling, value);
        Representation representation = new Representation();
        representation.setAny(ownerDocument.getDocumentElement());
        return representation;
    }

    private Representation modifyRepresentationModeAdd(List<Node> nodeList, ValueType value) {
        if (nodeList.isEmpty()) {
            throw new InvalidExpression();
        }
        Node firstNode = nodeList.get(0);
        Document ownerDocument = firstNode.getOwnerDocument();
        ownerDocument = ownerDocument == null ? (Document)firstNode : ownerDocument;
        for (Node node : nodeList) {
            this.addNode(ownerDocument, node, null, value);
        }
        Representation representation = new Representation();
        representation.setAny(ownerDocument.getDocumentElement());
        return representation;
    }

    private Representation modifyRepresentationModeInsertBefore(List<Node> nodeList, ValueType value) {
        if (nodeList.isEmpty()) {
            throw new InvalidExpression();
        }
        Node firstNode = nodeList.get(0);
        Document ownerDocument = firstNode.getOwnerDocument();
        ownerDocument = ownerDocument == null ? (Document)firstNode : ownerDocument;
        Node parent = firstNode.getParentNode();
        if (parent == null && firstNode.getNodeType() != 9) {
            throw new InvalidExpression();
        }
        if (parent == null && ((Document)(parent = firstNode)).getDocumentElement() != null) {
            throw new InvalidExpression();
        }
        for (Node node : nodeList) {
            if (node.getNodeType() == 2) {
                throw new InvalidRepresentation();
            }
            this.insertBefore(ownerDocument, parent, node, value);
        }
        Representation representation = new Representation();
        representation.setAny(ownerDocument.getDocumentElement());
        return representation;
    }

    private Representation modifyRepresentationModeInsertAfter(List<Node> nodeList, ValueType value) {
        if (nodeList.isEmpty()) {
            throw new InvalidExpression();
        }
        Node firstNode = nodeList.get(0);
        Document ownerDocument = firstNode.getOwnerDocument();
        ownerDocument = ownerDocument == null ? (Document)firstNode : ownerDocument;
        Node parent = firstNode.getParentNode();
        if (parent == null && firstNode.getNodeType() != 9) {
            throw new InvalidExpression();
        }
        if (parent == null && ((Document)(parent = firstNode)).getDocumentElement() != null) {
            throw new InvalidExpression();
        }
        for (Node node : nodeList) {
            if (node.getNodeType() == 2) {
                throw new InvalidRepresentation();
            }
            this.insertAfter(ownerDocument, parent, node, value);
        }
        Representation representation = new Representation();
        representation.setAny(ownerDocument.getDocumentElement());
        return representation;
    }

    private Representation modifyRepresentationModeRemove(List<Node> nodeList, ValueType value) {
        if (nodeList.isEmpty()) {
            throw new InvalidExpression();
        }
        Node firstNode = nodeList.get(0);
        Document ownerDocument = firstNode.getOwnerDocument();
        ownerDocument = ownerDocument == null ? (Document)firstNode : ownerDocument;
        for (Node node : nodeList) {
            this.removeNode(node);
        }
        Representation representation = new Representation();
        representation.setAny(ownerDocument.getDocumentElement());
        return representation;
    }

    private Node removeNode(Node resourceFragment) {
        Node parent = resourceFragment.getNodeType() == 2 ? ((Attr)resourceFragment).getOwnerElement() : resourceFragment.getParentNode();
        if (parent == null) {
            parent = resourceFragment;
        }
        if (resourceFragment.getNodeType() == 2) {
            ((Element)parent).removeAttributeNode((Attr)resourceFragment);
        } else if (parent != resourceFragment) {
            parent.removeChild(resourceFragment);
        } else {
            Document doc = (Document)parent;
            if (doc.getDocumentElement() != null) {
                doc.removeChild(doc.getDocumentElement());
            }
        }
        return parent;
    }

    private void insertAfter(Document ownerDocument, Node parent, Node refChild, ValueType value) {
        for (Object o : value.getContent()) {
            if (o instanceof Node) {
                Node node = (Node)o;
                if ("http://www.w3.org/2011/03/ws-fra".equals(node.getNamespaceURI()) && "AttributeNode".equals(node.getLocalName())) {
                    throw new InvalidRepresentation();
                }
                Node importedNode = ownerDocument.importNode(node, true);
                if (parent.getNodeType() == 9) {
                    parent.appendChild(importedNode);
                    continue;
                }
                Node nextSibling = refChild.getNextSibling();
                if (nextSibling == null) {
                    parent.appendChild(importedNode);
                    continue;
                }
                parent.insertBefore(importedNode, nextSibling);
                continue;
            }
            throw new InvalidExpression();
        }
    }

    private void insertBefore(Document ownerDocument, Node parent, Node refChild, ValueType value) {
        for (Object o : value.getContent()) {
            if (o instanceof Node) {
                Node node = (Node)o;
                if ("http://www.w3.org/2011/03/ws-fra".equals(node.getNamespaceURI()) && "AttributeNode".equals(node.getLocalName())) {
                    throw new InvalidRepresentation();
                }
                Node importedNode = ownerDocument.importNode(node, true);
                if (parent.getNodeType() == 9) {
                    parent.appendChild(importedNode);
                    continue;
                }
                parent.insertBefore(importedNode, refChild);
                continue;
            }
            throw new InvalidExpression();
        }
    }

    private void addNode(Document ownerDocument, Node parent, Node nextSibling, ValueType value) {
        if (ownerDocument == parent && ownerDocument.getDocumentElement() != null) {
            throw new InvalidRepresentation();
        }
        for (Object o : value.getContent()) {
            if (o instanceof String) {
                parent.setTextContent(parent.getTextContent() + (String)o);
                continue;
            }
            if (o instanceof Node) {
                Node node = (Node)o;
                if ("http://www.w3.org/2011/03/ws-fra".equals(node.getNamespaceURI()) && "AttributeNode".equals(node.getLocalName())) {
                    String attrName = ((Element)node).getAttributeNS("http://www.w3.org/2011/03/ws-fra", "name");
                    String attrValue = node.getTextContent();
                    if (attrName == null) {
                        throw new SoapFault("wsf:AttributeNode@name is not present.", this.getSoapVersion().getSender());
                    }
                    if (((Element)parent).hasAttribute(attrName)) {
                        throw new InvalidRepresentation();
                    }
                    ((Element)parent).setAttribute(attrName, attrValue);
                    continue;
                }
                Node importedNode = ownerDocument.importNode((Node)o, true);
                if (nextSibling == null) {
                    parent.appendChild(importedNode);
                    continue;
                }
                parent.insertBefore(importedNode, nextSibling);
                continue;
            }
            throw new InvalidExpression();
        }
    }

    private SoapVersion getSoapVersion() {
        WrappedMessageContext wmc = (WrappedMessageContext)this.context.getMessageContext();
        SoapMessage message = (SoapMessage)wmc.getWrappedMessage();
        return message.getVersion();
    }
}

