/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.odata;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.jaxrs.ext.search.AbstractSearchConditionParser;
import org.apache.cxf.jaxrs.ext.search.AndSearchCondition;
import org.apache.cxf.jaxrs.ext.search.Beanspector;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.OrSearchCondition;
import org.apache.cxf.jaxrs.ext.search.PrimitiveSearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchParseException;
import org.apache.cxf.jaxrs.ext.search.collections.CollectionCheckCondition;
import org.apache.cxf.jaxrs.ext.search.collections.CollectionCheckInfo;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataMessageException;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.BinaryOperator;
import org.apache.olingo.odata2.api.uri.expression.ExpressionVisitor;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.LiteralExpression;
import org.apache.olingo.odata2.api.uri.expression.MemberExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodOperator;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;
import org.apache.olingo.odata2.api.uri.expression.SortOrder;
import org.apache.olingo.odata2.api.uri.expression.UnaryExpression;
import org.apache.olingo.odata2.api.uri.expression.UnaryOperator;
import org.apache.olingo.odata2.core.uri.expression.FilterParser;
import org.apache.olingo.odata2.core.uri.expression.FilterParserImpl;

public class ODataParser<T>
extends AbstractSearchConditionParser<T> {
    private final FilterParser parser = new FilterParserImpl(null);

    public ODataParser(Class<T> conditionClass) {
        this(conditionClass, Collections.emptyMap());
    }

    public ODataParser(Class<T> tclass, Map<String, String> contextProperties) {
        this(tclass, contextProperties, null);
    }

    public ODataParser(Class<T> tclass, Map<String, String> contextProperties, Map<String, String> beanProperties) {
        super(tclass, contextProperties, beanProperties);
    }

    @Override
    public SearchCondition<T> parse(String searchExpression) throws SearchParseException {
        try {
            Object condition = this.conditionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            FilterExpression expression = this.parser.parseFilterString(searchExpression);
            FilterExpressionVisitor visitor = new FilterExpressionVisitor(condition);
            return (SearchCondition)expression.accept((ExpressionVisitor)visitor);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | ODataApplicationException | ODataMessageException ex) {
            throw new SearchParseException(ex);
        }
    }

    private class FilterExpressionVisitor
    implements ExpressionVisitor {
        private final T condition;

        FilterExpressionVisitor(T condition) {
            this.condition = condition;
        }

        public Object visitFilterExpression(FilterExpression filterExpression, String expressionString, Object expression) {
            return expression;
        }

        public Object visitBinary(BinaryExpression binaryExpression, BinaryOperator operator, Object leftSide, Object rightSide) {
            Object typedValue;
            TypedValue value;
            TypedProperty property;
            if (operator == BinaryOperator.AND || operator == BinaryOperator.OR) {
                if (leftSide instanceof SearchCondition && rightSide instanceof SearchCondition) {
                    ArrayList conditions = new ArrayList(2);
                    conditions.add((SearchCondition)leftSide);
                    conditions.add((SearchCondition)rightSide);
                    if (operator == BinaryOperator.AND) {
                        return new AndSearchCondition(conditions);
                    }
                    if (operator == BinaryOperator.OR) {
                        return new OrSearchCondition(conditions);
                    }
                } else {
                    throw new SearchParseException("Unsupported binary operation arguments (SearchCondition expected): " + String.valueOf(leftSide) + ", " + String.valueOf(rightSide));
                }
            }
            if (leftSide instanceof TypedProperty && rightSide instanceof TypedValue) {
                property = (TypedProperty)leftSide;
                value = (TypedValue)rightSide;
            } else if (rightSide instanceof TypedProperty && leftSide instanceof TypedValue) {
                property = (TypedProperty)rightSide;
                value = (TypedValue)leftSide;
            } else {
                throw new SearchParseException("Unsupported binary operation arguments (TypedValue or TypedProperty expected): " + String.valueOf(leftSide) + ", " + String.valueOf(rightSide));
            }
            ConditionType conditionType = null;
            switch (operator) {
                case EQ: {
                    conditionType = ConditionType.EQUALS;
                    break;
                }
                case NE: {
                    conditionType = ConditionType.NOT_EQUALS;
                    break;
                }
                case LT: {
                    conditionType = ConditionType.LESS_THAN;
                    break;
                }
                case LE: {
                    conditionType = ConditionType.LESS_OR_EQUALS;
                    break;
                }
                case GT: {
                    conditionType = ConditionType.GREATER_THAN;
                    break;
                }
                case GE: {
                    conditionType = ConditionType.GREATER_OR_EQUALS;
                    break;
                }
                default: {
                    throw new SearchParseException("Unsupported binary operation: " + String.valueOf(operator));
                }
            }
            if (property.typeInfo.getWrappedTypeClass().isAssignableFrom(value.typeClass)) {
                typedValue = value.value;
            } else {
                String valueStr = value.literal;
                if (ODataParser.this.isDecodeQueryValues().booleanValue()) {
                    valueStr = UrlUtils.urlDecode((String)valueStr);
                }
                typedValue = ODataParser.this.parseType(property.propertyName, null, null, property.propertyName, property.typeInfo, valueStr);
            }
            CollectionCheckInfo checkInfo = property.typeInfo.getCollectionCheckInfo();
            if (checkInfo != null) {
                return new CollectionCheckCondition(property.propertyName, typedValue, property.typeInfo.getGenericType(), conditionType, this.condition, checkInfo);
            }
            return new PrimitiveSearchCondition(property.propertyName, typedValue, property.typeInfo.getGenericType(), conditionType, this.condition);
        }

        public Object visitLiteral(LiteralExpression literal, EdmLiteral edmLiteral) {
            try {
                EdmSimpleType type = edmLiteral.getType();
                Object value = type.valueOfString(edmLiteral.getLiteral(), EdmLiteralKind.DEFAULT, null, type.getDefaultType());
                return new TypedValue(type.getDefaultType(), edmLiteral.getLiteral(), value);
            }
            catch (EdmSimpleTypeException ex) {
                throw new SearchParseException("Failed to convert literal to a typed form: " + String.valueOf(literal), ex);
            }
        }

        public Object visitProperty(PropertyExpression propertyExpression, String uriLiteral, EdmTyped edmProperty) {
            String setter = ODataParser.this.getActualSetterName(uriLiteral);
            Beanspector.TypeInfo typeInfo = ODataParser.this.getTypeInfo(setter, null);
            return new TypedProperty(typeInfo, setter);
        }

        public Object visitMethod(MethodExpression methodExpression, MethodOperator method, List<Object> parameters) {
            throw new SearchParseException("Unsupported operation visitMethod: " + String.valueOf(methodExpression) + "," + String.valueOf(method) + "," + String.valueOf(parameters));
        }

        public Object visitMember(MemberExpression memberExpression, Object path, Object property) {
            throw new SearchParseException("Unsupported operation visitMember: " + String.valueOf(memberExpression) + "," + String.valueOf(path) + "," + String.valueOf(property));
        }

        public Object visitUnary(UnaryExpression unaryExpression, UnaryOperator operator, Object operand) {
            throw new SearchParseException("Unsupported operation visitUnary: " + String.valueOf(unaryExpression) + "," + String.valueOf(operator) + "," + String.valueOf(operand));
        }

        public Object visitOrderByExpression(OrderByExpression orderByExpression, String expressionString, List<Object> orders) {
            throw new SearchParseException("Unsupported operation visitOrderByExpression: " + String.valueOf(orderByExpression) + "," + expressionString + "," + String.valueOf(orders));
        }

        public Object visitOrder(OrderExpression orderExpression, Object filterResult, SortOrder sortOrder) {
            throw new SearchParseException("Unsupported operation visitOrder: " + String.valueOf(orderExpression) + "," + String.valueOf(filterResult) + "," + String.valueOf(sortOrder));
        }
    }

    private static class TypedValue {
        private final Object value;
        private final String literal;
        private final Class<?> typeClass;

        TypedValue(Class<?> typeClass, String literal, Object value) {
            this.literal = literal;
            this.value = value;
            this.typeClass = typeClass;
        }
    }

    private static class TypedProperty {
        private final Beanspector.TypeInfo typeInfo;
        private final String propertyName;

        TypedProperty(Beanspector.TypeInfo typeInfo, String propertyName) {
            this.typeInfo = typeInfo;
            this.propertyName = propertyName;
        }
    }
}

