/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.support;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.MultiValueMap;

public final class Netty5HeadersAdapter
implements MultiValueMap<String, String> {
    private final io.netty5.handler.codec.http.headers.HttpHeaders headers;

    public Netty5HeadersAdapter(io.netty5.handler.codec.http.headers.HttpHeaders headers) {
        Assert.notNull((Object)headers, (String)"Headers must not be null");
        this.headers = headers;
    }

    @Nullable
    public String getFirst(String key) {
        CharSequence value = this.headers.get((CharSequence)key);
        return value != null ? value.toString() : null;
    }

    public void add(String key, @Nullable String value) {
        if (value != null) {
            this.headers.add((CharSequence)key, (CharSequence)value);
        }
    }

    public void addAll(String key, List<? extends String> values) {
        this.headers.add((CharSequence)key, values);
    }

    public void addAll(MultiValueMap<String, String> values) {
        values.forEach((arg_0, arg_1) -> ((io.netty5.handler.codec.http.headers.HttpHeaders)this.headers).add(arg_0, arg_1));
    }

    public void set(String key, @Nullable String value) {
        if (value != null) {
            this.headers.set((CharSequence)key, (CharSequence)value);
        }
    }

    public void setAll(Map<String, String> values) {
        values.forEach((arg_0, arg_1) -> ((io.netty5.handler.codec.http.headers.HttpHeaders)this.headers).set(arg_0, arg_1));
    }

    public Map<String, String> toSingleValueMap() {
        LinkedCaseInsensitiveMap singleValueMap = new LinkedCaseInsensitiveMap(this.headers.size(), Locale.ROOT);
        this.headers.forEach(arg_0 -> Netty5HeadersAdapter.lambda$toSingleValueMap$0((Map)singleValueMap, arg_0));
        return singleValueMap;
    }

    public int size() {
        return this.headers.names().size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean containsKey(Object key) {
        String headerName;
        return key instanceof String && this.headers.contains((CharSequence)(headerName = (String)key));
    }

    public boolean containsValue(Object value) {
        return value instanceof String && StreamSupport.stream(this.headers.spliterator(), false).anyMatch(entry -> value.equals(entry.getValue()));
    }

    @Nullable
    public List<String> get(Object key) {
        Iterator iterator = this.headers.valuesIterator((CharSequence)key);
        if (iterator.hasNext()) {
            ArrayList<String> result = new ArrayList<String>();
            iterator.forEachRemaining(value -> result.add(value.toString()));
            return result;
        }
        return null;
    }

    @Nullable
    public List<String> put(String key, @Nullable List<String> value) {
        Object previousValues = this.get(key);
        this.headers.set((CharSequence)key, value);
        return previousValues;
    }

    @Nullable
    public List<String> remove(Object key) {
        if (key instanceof String) {
            String headerName = (String)key;
            Object previousValues = this.get(headerName);
            this.headers.remove((CharSequence)headerName);
            return previousValues;
        }
        return null;
    }

    public void putAll(Map<? extends String, ? extends List<String>> map) {
        map.forEach((arg_0, arg_1) -> ((io.netty5.handler.codec.http.headers.HttpHeaders)this.headers).set(arg_0, arg_1));
    }

    public void clear() {
        this.headers.clear();
    }

    public Set<String> keySet() {
        return new HeaderNames();
    }

    public Collection<List<String>> values() {
        ArrayList<List<String>> result = new ArrayList<List<String>>(this.headers.size());
        this.forEach((key, value) -> result.add((List<String>)value));
        return result;
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return Netty5HeadersAdapter.this.headers.size();
            }
        };
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    private static /* synthetic */ void lambda$toSingleValueMap$0(Map singleValueMap, Map.Entry entry) {
        singleValueMap.putIfAbsent(((CharSequence)entry.getKey()).toString(), ((CharSequence)entry.getValue()).toString());
    }

    private class HeaderNames
    extends AbstractSet<String> {
        private HeaderNames() {
        }

        @Override
        public Iterator<String> iterator() {
            return new HeaderNamesIterator(Netty5HeadersAdapter.this.headers.names().iterator());
        }

        @Override
        public int size() {
            return Netty5HeadersAdapter.this.headers.names().size();
        }
    }

    private final class HeaderNamesIterator
    implements Iterator<String> {
        private final Iterator<CharSequence> iterator;
        @Nullable
        private CharSequence currentName;

        private HeaderNamesIterator(Iterator<CharSequence> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            this.currentName = this.iterator.next();
            return this.currentName.toString();
        }

        @Override
        public void remove() {
            if (this.currentName == null) {
                throw new IllegalStateException("No current Header in iterator");
            }
            if (!Netty5HeadersAdapter.this.headers.contains(this.currentName)) {
                throw new IllegalStateException("Header not present: " + String.valueOf(this.currentName));
            }
            Netty5HeadersAdapter.this.headers.remove(this.currentName);
        }
    }

    private class HeaderEntry
    implements Map.Entry<String, List<String>> {
        private final CharSequence key;

        HeaderEntry(CharSequence key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key.toString();
        }

        @Override
        public List<String> getValue() {
            List<String> values = Netty5HeadersAdapter.this.get(this.key);
            return values != null ? values : Collections.emptyList();
        }

        @Override
        public List<String> setValue(List<String> value) {
            Object previousValues = this.getValue();
            Netty5HeadersAdapter.this.headers.set(this.key, value);
            return previousValues;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private final Iterator<CharSequence> names;

        private EntryIterator() {
            this.names = Netty5HeadersAdapter.this.headers.names().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.names.hasNext();
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return new HeaderEntry(this.names.next());
        }
    }
}

