/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.HpackDecoder;
import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2HeaderBlockParser;
import java.nio.ByteBuffer;
import org.xnio.Bits;

class Http2PushPromiseParser
extends Http2HeaderBlockParser {
    private int paddingLength = 0;
    private int promisedStreamId;
    private static final int STREAM_MASK = -129;

    Http2PushPromiseParser(int frameLength, HpackDecoder hpackDecoder, boolean client, int maxHeaders, int streamId, int maxHeaderListSize) {
        super(frameLength, hpackDecoder, client, maxHeaders, streamId, maxHeaderListSize);
    }

    @Override
    protected boolean handleBeforeHeader(ByteBuffer resource, Http2FrameHeaderParser headerParser) {
        boolean hasPadding = Bits.anyAreSet((int)headerParser.flags, (int)8);
        int reqLength = (hasPadding ? 1 : 0) + 4;
        if (resource.remaining() < reqLength) {
            return false;
        }
        if (hasPadding) {
            this.paddingLength = resource.get() & 0xFF;
        }
        this.promisedStreamId = (resource.get() & 0xFFFFFF7F) << 24;
        this.promisedStreamId += (resource.get() & 0xFF) << 16;
        this.promisedStreamId += (resource.get() & 0xFF) << 8;
        this.promisedStreamId += resource.get() & 0xFF;
        return true;
    }

    @Override
    protected int getPaddingLength() {
        return this.paddingLength;
    }

    public int getPromisedStreamId() {
        return this.promisedStreamId;
    }
}

