/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.IOCase;
import org.apache.commons.vfs2.filter.RegexFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RegexFileFilterTest
extends BaseFilterTest {
    @Test
    public void testPatternNullArgConstruction() {
        try {
            new RegexFileFilter((Pattern)null);
            Assertions.fail();
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertEquals((Object)"Pattern is missing", (Object)ex.getMessage());
        }
    }

    @Test
    public void testRegex() throws Exception {
        RegexFileFilter filter = new RegexFileFilter("^.*[tT]est(-\\d+)?\\.java$");
        Assertions.assertTrue((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("Test.java"))));
        Assertions.assertTrue((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("test-10.java"))));
        Assertions.assertFalse((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("test-.java"))));
        filter = new RegexFileFilter("^[Tt]est.java$");
        Assertions.assertTrue((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("Test.java"))));
        Assertions.assertTrue((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("test.java"))));
        Assertions.assertFalse((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("tEST.java"))));
        filter = new RegexFileFilter(Pattern.compile("^test.java$", 2));
        Assertions.assertTrue((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("Test.java"))));
        Assertions.assertTrue((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("test.java"))));
        Assertions.assertTrue((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("tEST.java"))));
        filter = new RegexFileFilter("^test.java$", 2);
        Assertions.assertTrue((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("Test.java"))));
        Assertions.assertTrue((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("test.java"))));
        Assertions.assertTrue((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("tEST.java"))));
        filter = new RegexFileFilter("^test.java$", IOCase.INSENSITIVE);
        Assertions.assertTrue((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("Test.java"))));
        Assertions.assertTrue((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("test.java"))));
        Assertions.assertTrue((boolean)filter.accept(RegexFileFilterTest.createFileSelectInfo(new File("tEST.java"))));
    }

    @Test
    public void testStringIOCaseNullArgConstruction() {
        try {
            new RegexFileFilter((String)null, IOCase.INSENSITIVE);
            Assertions.fail();
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertEquals((Object)"Pattern is missing", (Object)ex.getMessage());
        }
    }

    @Test
    public void testStringNullArgConstruction() {
        try {
            new RegexFileFilter((String)null);
            Assertions.fail();
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertEquals((Object)"Pattern is missing", (Object)ex.getMessage());
        }
    }

    @Test
    public void testStringPatternNullArgConstruction() {
        try {
            new RegexFileFilter((String)null, 2);
            Assertions.fail();
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertEquals((Object)"Pattern is missing", (Object)ex.getMessage());
        }
    }
}

