/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.genetics;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.OutOfRangeException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.genetics.AbstractListChromosome;
import org.apache.commons.math4.legacy.genetics.Chromosome;
import org.apache.commons.math4.legacy.genetics.ChromosomePair;
import org.apache.commons.math4.legacy.genetics.CrossoverPolicy;
import org.apache.commons.math4.legacy.genetics.GeneticAlgorithm;
import org.apache.commons.rng.UniformRandomProvider;

public class UniformCrossover<T>
implements CrossoverPolicy {
    private final double ratio;

    public UniformCrossover(double ratio) throws OutOfRangeException {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.CROSSOVER_RATE, (Number)ratio, (Number)0.0, (Number)1.0);
        }
        this.ratio = ratio;
    }

    public double getRatio() {
        return this.ratio;
    }

    @Override
    public ChromosomePair crossover(Chromosome first, Chromosome second) throws DimensionMismatchException, MathIllegalArgumentException {
        if (!(first instanceof AbstractListChromosome) || !(second instanceof AbstractListChromosome)) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.INVALID_FIXED_LENGTH_CHROMOSOME, new Object[0]);
        }
        return this.mate((AbstractListChromosome)first, (AbstractListChromosome)second);
    }

    private ChromosomePair mate(AbstractListChromosome<T> first, AbstractListChromosome<T> second) throws DimensionMismatchException {
        int length = first.getLength();
        if (length != second.getLength()) {
            throw new DimensionMismatchException(second.getLength(), length);
        }
        List<T> parent1Rep = first.getRepresentation();
        List<T> parent2Rep = second.getRepresentation();
        ArrayList<T> child1Rep = new ArrayList<T>(length);
        ArrayList<T> child2Rep = new ArrayList<T>(length);
        UniformRandomProvider random = GeneticAlgorithm.getRandomGenerator();
        for (int index = 0; index < length; ++index) {
            if (random.nextDouble() < this.ratio) {
                child1Rep.add(parent2Rep.get(index));
                child2Rep.add(parent1Rep.get(index));
                continue;
            }
            child1Rep.add(parent1Rep.get(index));
            child2Rep.add(parent2Rep.get(index));
        }
        return new ChromosomePair(first.newFixedLengthChromosome(child1Rep), second.newFixedLengthChromosome(child2Rep));
    }
}

