/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration;

import org.apache.commons.math3.analysis.QuinticFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.Sin;
import org.apache.commons.math3.analysis.integration.TrapezoidIntegrator;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public final class TrapezoidIntegratorTest {
    @Test
    public void testSinFunction() {
        Sin f = new Sin();
        TrapezoidIntegrator integrator = new TrapezoidIntegrator();
        double min = 0.0;
        double max = Math.PI;
        double expected = 2.0;
        double tolerance = FastMath.abs((double)(expected * integrator.getRelativeAccuracy()));
        double result = integrator.integrate(10000, (UnivariateFunction)f, min, max);
        Assert.assertTrue((integrator.getEvaluations() < 2500 ? 1 : 0) != 0);
        Assert.assertTrue((integrator.getIterations() < 15 ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        min = -1.0471975511965976;
        max = 0.0;
        expected = -0.5;
        tolerance = FastMath.abs((double)(expected * integrator.getRelativeAccuracy()));
        result = integrator.integrate(10000, (UnivariateFunction)f, min, max);
        Assert.assertTrue((integrator.getEvaluations() < 2500 ? 1 : 0) != 0);
        Assert.assertTrue((integrator.getIterations() < 15 ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
    }

    @Test
    public void testQuinticFunction() {
        QuinticFunction f = new QuinticFunction();
        TrapezoidIntegrator integrator = new TrapezoidIntegrator();
        double min = 0.0;
        double max = 1.0;
        double expected = -0.020833333333333332;
        double tolerance = FastMath.abs((double)(expected * integrator.getRelativeAccuracy()));
        double result = integrator.integrate(10000, (UnivariateFunction)f, min, max);
        Assert.assertTrue((integrator.getEvaluations() < 5000 ? 1 : 0) != 0);
        Assert.assertTrue((integrator.getIterations() < 15 ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        min = 0.0;
        max = 0.5;
        expected = 0.014322916666666666;
        tolerance = FastMath.abs((double)(expected * integrator.getRelativeAccuracy()));
        result = integrator.integrate(10000, (UnivariateFunction)f, min, max);
        Assert.assertTrue((integrator.getEvaluations() < 2500 ? 1 : 0) != 0);
        Assert.assertTrue((integrator.getIterations() < 15 ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        min = -1.0;
        max = 4.0;
        expected = 604.6875;
        tolerance = FastMath.abs((double)(expected * integrator.getRelativeAccuracy()));
        result = integrator.integrate(10000, (UnivariateFunction)f, min, max);
        Assert.assertTrue((integrator.getEvaluations() < 5000 ? 1 : 0) != 0);
        Assert.assertTrue((integrator.getIterations() < 15 ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
    }

    @Test
    public void testParameters() {
        Sin f = new Sin();
        try {
            new TrapezoidIntegrator().integrate(1000, (UnivariateFunction)f, 1.0, -1.0);
            Assert.fail((String)"Expecting NumberIsTooLargeException - bad interval");
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            // empty catch block
        }
        try {
            new TrapezoidIntegrator(5, 4);
            Assert.fail((String)"Expecting NumberIsTooSmallException - bad iteration limits");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            new TrapezoidIntegrator(10, 99);
            Assert.fail((String)"Expecting NumberIsTooLargeException - bad iteration limits");
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            // empty catch block
        }
    }
}

