/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.bean;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.impl.TagFactory;
import org.apache.commons.jelly.impl.TagScript;
import org.apache.commons.jelly.tags.bean.BeanPropertyTag;
import org.apache.commons.jelly.tags.bean.BeanTag;
import org.apache.commons.jelly.tags.bean.BeandefTag;
import org.xml.sax.Attributes;

public class BeanTagLibrary
extends TagLibrary {
    private Map beanTypes = new Hashtable();
    private Map invokeMethods = new Hashtable();

    public BeanTagLibrary() {
        this.registerTagFactory("beandef", new TagFactory(){

            public Tag createTag(String name, Attributes attributes) throws JellyException {
                return new BeandefTag(BeanTagLibrary.this);
            }
        });
    }

    public void registerBean(String name, Class type) {
        this.beanTypes.put(name, type);
    }

    public void registerBean(String name, Class type, Method method) {
        this.registerBean(name, type);
        if (method != null) {
            this.invokeMethods.put(name, method);
        } else {
            this.invokeMethods.remove(name);
        }
    }

    public void registerBean(String name, Class type, String methodName) {
        Method method = MethodUtils.getAccessibleMethod((Class)type, (String)methodName, (Class[])BeandefTag.EMPTY_ARGUMENT_TYPES);
        this.registerBean(name, type, method);
    }

    public TagScript createTagScript(String name, Attributes attributes) throws JellyException {
        TagScript answer = super.createTagScript(name, attributes);
        if (answer != null) {
            return answer;
        }
        return new TagScript(this.createTagFactory(name, attributes));
    }

    protected TagFactory createTagFactory(String name, Attributes attributes) throws JellyException {
        return new TagFactory(){

            public Tag createTag(String name, Attributes attributes) throws JellyException {
                return BeanTagLibrary.this.createBeanTag(name, attributes);
            }
        };
    }

    protected Tag createBeanTag(String name, Attributes attributes) throws JellyException {
        Class beanType = this.getBeanType(name, attributes);
        if (beanType != null) {
            Method invokeMethod = (Method)this.invokeMethods.get(name);
            return new BeanTag(beanType, name, invokeMethod);
        }
        return new BeanPropertyTag(name);
    }

    protected Class getBeanType(String name, Attributes attributes) {
        return (Class)this.beanTypes.get(name);
    }
}

