/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.bean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.impl.BeanSource;
import org.apache.commons.jelly.impl.CollectionTag;
import org.apache.commons.jelly.tags.core.UseBeanTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanTag
extends UseBeanTag {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$tags$bean$BeanTag == null ? (class$org$apache$commons$jelly$tags$bean$BeanTag = BeanTag.class$("org.apache.commons.jelly.tags.bean.BeanTag")) : class$org$apache$commons$jelly$tags$bean$BeanTag));
    protected static final Object[] EMPTY_ARGUMENTS = new Object[0];
    private String tagName;
    protected String addMethodName;
    private Method invokeMethod;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$bean$BeanTag;
    static /* synthetic */ Class class$org$apache$commons$jelly$impl$BeanSource;

    public BeanTag() {
        this(null, "bean", null);
    }

    public BeanTag(Class defaultClass, String tagName) {
        this(defaultClass, tagName, null);
    }

    public BeanTag(Class defaultClass, String tagName, Method invokeMethod) {
        super(defaultClass);
        this.tagName = tagName;
        this.invokeMethod = invokeMethod;
        if (tagName.length() > 0) {
            this.addMethodName = "add" + tagName.substring(0, 1).toUpperCase() + tagName.substring(1);
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    protected void processBean(String var, Object bean) throws JellyTagException {
        if (var != null) {
            ((TagSupport)this).context.setVariable(var, bean);
        }
        if (bean != null) {
            BeanTag parent = this;
            while ((parent = parent.getParent()) != null) {
                if (parent instanceof BeanSource) {
                    BeanSource source = (BeanSource)parent;
                    Object parentObject = source.getBean();
                    if (parentObject != null) {
                        if (parentObject instanceof Collection) {
                            Collection collection = (Collection)parentObject;
                            collection.add(bean);
                            break;
                        }
                        Method method = this.findAddMethod(parentObject.getClass(), bean.getClass());
                        if (method != null) {
                            Object[] args = new Object[]{bean};
                            try {
                                method.invoke(parentObject, args);
                                break;
                            }
                            catch (Exception e) {
                                throw new JellyTagException("failed to invoke method: " + method + " on bean: " + parentObject + " reason: " + e, (Throwable)e);
                            }
                        }
                        try {
                            BeanUtils.setProperty((Object)parentObject, (String)this.tagName, (Object)bean);
                            break;
                        }
                        catch (IllegalAccessException e) {
                            throw new JellyTagException((Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            throw new JellyTagException((Throwable)e);
                        }
                    }
                    log.warn((Object)("Cannot process null bean for tag: " + (Object)((Object)parent)));
                    break;
                }
                if (!(parent instanceof CollectionTag)) continue;
                CollectionTag tag = (CollectionTag)parent;
                tag.addItem(bean);
                break;
            }
            if (this.invokeMethod != null) {
                Object[] args = new Object[]{bean};
                try {
                    this.invokeMethod.invoke(bean, EMPTY_ARGUMENTS);
                }
                catch (Exception e) {
                    throw new JellyTagException("failed to invoke method: " + this.invokeMethod + " on bean: " + bean + " reason: " + e, (Throwable)e);
                }
            } else if (parent == null && var == null) {
                log.warn((Object)("Could not add bean to parent for bean: " + bean));
            }
        }
    }

    protected Method findAddMethod(Class beanClass, Class valueClass) {
        if (this.addMethodName == null) {
            return null;
        }
        Class[] argTypes = new Class[]{valueClass};
        return MethodUtils.getAccessibleMethod((Class)beanClass, (String)this.addMethodName, (Class[])argTypes);
    }

    protected Object getParentObject() throws JellyTagException {
        BeanSource tag = (BeanSource)this.findAncestorWithClass(class$org$apache$commons$jelly$impl$BeanSource == null ? (class$org$apache$commons$jelly$impl$BeanSource = BeanTag.class$("org.apache.commons.jelly.impl.BeanSource")) : class$org$apache$commons$jelly$impl$BeanSource);
        if (tag != null) {
            return tag.getBean();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

