/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.geometry.euclidean.threed;

import org.apache.commons.geometry.euclidean.threed.line.Line3D;
import org.apache.commons.geometry.euclidean.threed.line.LineConvexSubset3D;

/** Abstract base class for {@link PlaneSubset} implementations.
 */
abstract class AbstractPlaneSubset implements PlaneSubset {

    /** {@inheritDoc} */
    @Override
    public Plane getHyperplane() {
        return getPlane();
    }

    /** {@inheritDoc} */
    @Override
    public Vector3D intersection(final Line3D line) {
        return Planes.intersection(this, line);
    }

    /** {@inheritDoc} */
    @Override
    public Vector3D intersection(final LineConvexSubset3D lineSubset) {
        return Planes.intersection(this, lineSubset);
    }
}
