/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.List;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.euclidean.threed.AbstractEmbeddedRegionPlaneSubset;
import org.apache.commons.geometry.euclidean.threed.Bounds3D;
import org.apache.commons.geometry.euclidean.threed.EmbeddingPlane;
import org.apache.commons.geometry.euclidean.threed.Plane;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.twod.AffineTransformMatrix2D;
import org.apache.commons.geometry.euclidean.twod.ConvexArea;
import org.apache.commons.geometry.euclidean.twod.Vector2D;

final class EmbeddedAreaPlaneConvexSubset
extends AbstractEmbeddedRegionPlaneSubset
implements PlaneConvexSubset,
PlaneConvexSubset.Embedded {
    private final ConvexArea area;

    EmbeddedAreaPlaneConvexSubset(EmbeddingPlane plane, ConvexArea area) {
        super(plane);
        this.area = area;
    }

    @Override
    public PlaneConvexSubset.Embedded getEmbedded() {
        return this;
    }

    @Override
    public ConvexArea getSubspaceRegion() {
        return this.area;
    }

    @Override
    public List<Vector3D> getVertices() {
        return this.getPlane().toSpace(this.area.getVertices());
    }

    @Override
    public Bounds3D getBounds() {
        return this.getBoundsFromSubspace(this.area);
    }

    @Override
    public List<Triangle3D> toTriangles() {
        if (this.isInfinite()) {
            throw new IllegalStateException("Cannot convert infinite plane subset to triangles: " + this);
        }
        EmbeddingPlane plane = this.getPlane();
        List vertices = plane.toSpace(this.area.getVertices());
        return Planes.convexPolygonToTriangleFan(plane, vertices);
    }

    @Override
    public EmbeddedAreaPlaneConvexSubset transform(Transform<Vector3D> transform) {
        EmbeddingPlane.SubspaceTransform st = this.getPlane().subspaceTransform(transform);
        ConvexArea tArea = this.area.transform(st.getTransform());
        return new EmbeddedAreaPlaneConvexSubset(st.getPlane().getEmbedding(), tArea);
    }

    @Override
    public EmbeddedAreaPlaneConvexSubset reverse() {
        EmbeddingPlane plane = this.getPlane();
        EmbeddingPlane rPlane = plane.reverse();
        Vector2D rU = rPlane.toSubspace(plane.toSpace(Vector2D.Unit.PLUS_X));
        Vector2D rV = rPlane.toSubspace(plane.toSpace(Vector2D.Unit.PLUS_Y));
        AffineTransformMatrix2D transform = AffineTransformMatrix2D.fromColumnVectors(rU, rV);
        return new EmbeddedAreaPlaneConvexSubset(rPlane, this.area.transform(transform));
    }

    @Override
    public Split<PlaneConvexSubset> split(Hyperplane<Vector3D> splitter) {
        return Planes.subspaceSplit((Plane)splitter, this, (p, r) -> Planes.subsetFromConvexArea(p, (ConvexArea)r));
    }
}

