/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;

public abstract class BaseResultSetHandler<T>
implements ResultSetHandler<T> {
    private ResultSet resultSet;

    protected final boolean absolute(int row) throws SQLException {
        return this.resultSet.absolute(row);
    }

    protected final void afterLast() throws SQLException {
        this.resultSet.afterLast();
    }

    protected final void beforeFirst() throws SQLException {
        this.resultSet.beforeFirst();
    }

    protected final void cancelRowUpdates() throws SQLException {
        this.resultSet.cancelRowUpdates();
    }

    protected final void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    protected final void close() throws SQLException {
        this.resultSet.close();
    }

    protected final void deleteRow() throws SQLException {
        this.resultSet.deleteRow();
    }

    protected final int findColumn(String columnLabel) throws SQLException {
        return this.resultSet.findColumn(columnLabel);
    }

    protected final boolean first() throws SQLException {
        return this.resultSet.first();
    }

    protected final ResultSet getAdaptedResultSet() {
        return this.resultSet;
    }

    protected final Array getArray(int columnIndex) throws SQLException {
        return this.resultSet.getArray(columnIndex);
    }

    protected final Array getArray(String columnLabel) throws SQLException {
        return this.resultSet.getArray(columnLabel);
    }

    protected final InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.resultSet.getAsciiStream(columnIndex);
    }

    protected final InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.resultSet.getAsciiStream(columnLabel);
    }

    protected final BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.resultSet.getBigDecimal(columnIndex);
    }

    @Deprecated
    protected final BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.resultSet.getBigDecimal(columnIndex, scale);
    }

    protected final BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.resultSet.getBigDecimal(columnLabel);
    }

    @Deprecated
    protected final BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.resultSet.getBigDecimal(columnLabel, scale);
    }

    protected final InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.resultSet.getBinaryStream(columnIndex);
    }

    protected final InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.resultSet.getBinaryStream(columnLabel);
    }

    protected final Blob getBlob(int columnIndex) throws SQLException {
        return this.resultSet.getBlob(columnIndex);
    }

    protected final Blob getBlob(String columnLabel) throws SQLException {
        return this.resultSet.getBlob(columnLabel);
    }

    protected final boolean getBoolean(int columnIndex) throws SQLException {
        return this.resultSet.getBoolean(columnIndex);
    }

    protected final boolean getBoolean(String columnLabel) throws SQLException {
        return this.resultSet.getBoolean(columnLabel);
    }

    protected final byte getByte(int columnIndex) throws SQLException {
        return this.resultSet.getByte(columnIndex);
    }

    protected final byte getByte(String columnLabel) throws SQLException {
        return this.resultSet.getByte(columnLabel);
    }

    protected final byte[] getBytes(int columnIndex) throws SQLException {
        return this.resultSet.getBytes(columnIndex);
    }

    protected final byte[] getBytes(String columnLabel) throws SQLException {
        return this.resultSet.getBytes(columnLabel);
    }

    protected final Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.resultSet.getCharacterStream(columnIndex);
    }

    protected final Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.resultSet.getCharacterStream(columnLabel);
    }

    protected final Clob getClob(int columnIndex) throws SQLException {
        return this.resultSet.getClob(columnIndex);
    }

    protected final Clob getClob(String columnLabel) throws SQLException {
        return this.resultSet.getClob(columnLabel);
    }

    protected final int getConcurrency() throws SQLException {
        return this.resultSet.getConcurrency();
    }

    protected final String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    protected final Date getDate(int columnIndex) throws SQLException {
        return this.resultSet.getDate(columnIndex);
    }

    protected final Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.resultSet.getDate(columnIndex, cal);
    }

    protected final Date getDate(String columnLabel) throws SQLException {
        return this.resultSet.getDate(columnLabel);
    }

    protected final Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.resultSet.getDate(columnLabel, cal);
    }

    protected final double getDouble(int columnIndex) throws SQLException {
        return this.resultSet.getDouble(columnIndex);
    }

    protected final double getDouble(String columnLabel) throws SQLException {
        return this.resultSet.getDouble(columnLabel);
    }

    protected final int getFetchDirection() throws SQLException {
        return this.resultSet.getFetchDirection();
    }

    protected final int getFetchSize() throws SQLException {
        return this.resultSet.getFetchSize();
    }

    protected final float getFloat(int columnIndex) throws SQLException {
        return this.resultSet.getFloat(columnIndex);
    }

    protected final float getFloat(String columnLabel) throws SQLException {
        return this.resultSet.getFloat(columnLabel);
    }

    protected final int getHoldability() throws SQLException {
        return this.resultSet.getHoldability();
    }

    protected final int getInt(int columnIndex) throws SQLException {
        return this.resultSet.getInt(columnIndex);
    }

    protected final int getInt(String columnLabel) throws SQLException {
        return this.resultSet.getInt(columnLabel);
    }

    protected final long getLong(int columnIndex) throws SQLException {
        return this.resultSet.getLong(columnIndex);
    }

    protected final long getLong(String columnLabel) throws SQLException {
        return this.resultSet.getLong(columnLabel);
    }

    protected final ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSet.getMetaData();
    }

    protected final Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.resultSet.getNCharacterStream(columnIndex);
    }

    protected final Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.resultSet.getNCharacterStream(columnLabel);
    }

    protected final NClob getNClob(int columnIndex) throws SQLException {
        return this.resultSet.getNClob(columnIndex);
    }

    protected final NClob getNClob(String columnLabel) throws SQLException {
        return this.resultSet.getNClob(columnLabel);
    }

    protected final String getNString(int columnIndex) throws SQLException {
        return this.resultSet.getNString(columnIndex);
    }

    protected final String getNString(String columnLabel) throws SQLException {
        return this.resultSet.getNString(columnLabel);
    }

    protected final Object getObject(int columnIndex) throws SQLException {
        return this.resultSet.getObject(columnIndex);
    }

    protected final Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.resultSet.getObject(columnIndex, map);
    }

    protected final Object getObject(String columnLabel) throws SQLException {
        return this.resultSet.getObject(columnLabel);
    }

    protected final Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.resultSet.getObject(columnLabel, map);
    }

    protected final Ref getRef(int columnIndex) throws SQLException {
        return this.resultSet.getRef(columnIndex);
    }

    protected final Ref getRef(String columnLabel) throws SQLException {
        return this.resultSet.getRef(columnLabel);
    }

    protected final int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    protected final RowId getRowId(int columnIndex) throws SQLException {
        return this.resultSet.getRowId(columnIndex);
    }

    protected final RowId getRowId(String columnLabel) throws SQLException {
        return this.resultSet.getRowId(columnLabel);
    }

    protected final short getShort(int columnIndex) throws SQLException {
        return this.resultSet.getShort(columnIndex);
    }

    protected final short getShort(String columnLabel) throws SQLException {
        return this.resultSet.getShort(columnLabel);
    }

    protected final SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.resultSet.getSQLXML(columnIndex);
    }

    protected final SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.resultSet.getSQLXML(columnLabel);
    }

    protected final Statement getStatement() throws SQLException {
        return this.resultSet.getStatement();
    }

    protected final String getString(int columnIndex) throws SQLException {
        return this.resultSet.getString(columnIndex);
    }

    protected final String getString(String columnLabel) throws SQLException {
        return this.resultSet.getString(columnLabel);
    }

    protected final Time getTime(int columnIndex) throws SQLException {
        return this.resultSet.getTime(columnIndex);
    }

    protected final Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.resultSet.getTime(columnIndex, cal);
    }

    protected final Time getTime(String columnLabel) throws SQLException {
        return this.resultSet.getTime(columnLabel);
    }

    protected final Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.resultSet.getTime(columnLabel, cal);
    }

    protected final Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.resultSet.getTimestamp(columnIndex);
    }

    protected final Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.resultSet.getTimestamp(columnIndex, cal);
    }

    protected final Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.resultSet.getTimestamp(columnLabel);
    }

    protected final Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.resultSet.getTimestamp(columnLabel, cal);
    }

    protected final int getType() throws SQLException {
        return this.resultSet.getType();
    }

    @Deprecated
    protected final InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.resultSet.getUnicodeStream(columnIndex);
    }

    @Deprecated
    protected final InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.resultSet.getUnicodeStream(columnLabel);
    }

    protected final URL getURL(int columnIndex) throws SQLException {
        return this.resultSet.getURL(columnIndex);
    }

    protected final URL getURL(String columnLabel) throws SQLException {
        return this.resultSet.getURL(columnLabel);
    }

    protected final SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    protected abstract T handle() throws SQLException;

    @Override
    public final T handle(ResultSet rs) throws SQLException {
        if (this.resultSet != null) {
            throw new IllegalStateException("Re-entry not allowed!");
        }
        this.resultSet = rs;
        try {
            T t = this.handle();
            return t;
        }
        finally {
            this.resultSet = null;
        }
    }

    protected final void insertRow() throws SQLException {
        this.resultSet.insertRow();
    }

    protected final boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    protected final boolean isBeforeFirst() throws SQLException {
        return this.resultSet.isBeforeFirst();
    }

    protected final boolean isClosed() throws SQLException {
        return this.resultSet.isClosed();
    }

    protected final boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    protected final boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    protected final boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.resultSet.isWrapperFor(iface);
    }

    protected final boolean last() throws SQLException {
        return this.resultSet.last();
    }

    protected final void moveToCurrentRow() throws SQLException {
        this.resultSet.moveToCurrentRow();
    }

    protected final void moveToInsertRow() throws SQLException {
        this.resultSet.moveToInsertRow();
    }

    protected final boolean next() throws SQLException {
        return this.resultSet.next();
    }

    protected final boolean previous() throws SQLException {
        return this.resultSet.previous();
    }

    protected final void refreshRow() throws SQLException {
        this.resultSet.refreshRow();
    }

    protected final boolean relative(int rows) throws SQLException {
        return this.resultSet.relative(rows);
    }

    protected final boolean rowDeleted() throws SQLException {
        return this.resultSet.rowDeleted();
    }

    protected final boolean rowInserted() throws SQLException {
        return this.resultSet.rowInserted();
    }

    protected final boolean rowUpdated() throws SQLException {
        return this.resultSet.rowUpdated();
    }

    protected final void setFetchDirection(int direction) throws SQLException {
        this.resultSet.setFetchDirection(direction);
    }

    protected final void setFetchSize(int rows) throws SQLException {
        this.resultSet.setFetchSize(rows);
    }

    protected final <E> E unwrap(Class<E> iface) throws SQLException {
        return this.resultSet.unwrap(iface);
    }

    protected final void updateArray(int columnIndex, Array x) throws SQLException {
        this.resultSet.updateArray(columnIndex, x);
    }

    protected final void updateArray(String columnLabel, Array x) throws SQLException {
        this.resultSet.updateArray(columnLabel, x);
    }

    protected final void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.resultSet.updateAsciiStream(columnIndex, x);
    }

    protected final void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.resultSet.updateAsciiStream(columnIndex, x, length);
    }

    protected final void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.resultSet.updateAsciiStream(columnIndex, x, length);
    }

    protected final void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.resultSet.updateAsciiStream(columnLabel, x);
    }

    protected final void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.resultSet.updateAsciiStream(columnLabel, x, length);
    }

    protected final void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.resultSet.updateAsciiStream(columnLabel, x, length);
    }

    protected final void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.resultSet.updateBigDecimal(columnIndex, x);
    }

    protected final void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.resultSet.updateBigDecimal(columnLabel, x);
    }

    protected final void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.resultSet.updateBinaryStream(columnIndex, x);
    }

    protected final void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.resultSet.updateBinaryStream(columnIndex, x, length);
    }

    protected final void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.resultSet.updateBinaryStream(columnIndex, x, length);
    }

    protected final void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.resultSet.updateBinaryStream(columnLabel, x);
    }

    protected final void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.resultSet.updateBinaryStream(columnLabel, x, length);
    }

    protected final void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.resultSet.updateBinaryStream(columnLabel, x, length);
    }

    protected final void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.resultSet.updateBlob(columnIndex, x);
    }

    protected final void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.resultSet.updateBlob(columnIndex, inputStream);
    }

    protected final void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.resultSet.updateBlob(columnIndex, inputStream, length);
    }

    protected final void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.resultSet.updateBlob(columnLabel, x);
    }

    protected final void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.resultSet.updateBlob(columnLabel, inputStream);
    }

    protected final void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.resultSet.updateBlob(columnLabel, inputStream, length);
    }

    protected final void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.resultSet.updateBoolean(columnIndex, x);
    }

    protected final void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.resultSet.updateBoolean(columnLabel, x);
    }

    protected final void updateByte(int columnIndex, byte x) throws SQLException {
        this.resultSet.updateByte(columnIndex, x);
    }

    protected final void updateByte(String columnLabel, byte x) throws SQLException {
        this.resultSet.updateByte(columnLabel, x);
    }

    protected final void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.resultSet.updateBytes(columnIndex, x);
    }

    protected final void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.resultSet.updateBytes(columnLabel, x);
    }

    protected final void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.resultSet.updateCharacterStream(columnIndex, x);
    }

    protected final void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.resultSet.updateCharacterStream(columnIndex, x, length);
    }

    protected final void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.resultSet.updateCharacterStream(columnIndex, x, length);
    }

    protected final void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.resultSet.updateCharacterStream(columnLabel, reader);
    }

    protected final void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.resultSet.updateCharacterStream(columnLabel, reader, length);
    }

    protected final void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.resultSet.updateCharacterStream(columnLabel, reader, length);
    }

    protected final void updateClob(int columnIndex, Clob x) throws SQLException {
        this.resultSet.updateClob(columnIndex, x);
    }

    protected final void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.resultSet.updateClob(columnIndex, reader);
    }

    protected final void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.resultSet.updateClob(columnIndex, reader, length);
    }

    protected final void updateClob(String columnLabel, Clob x) throws SQLException {
        this.resultSet.updateClob(columnLabel, x);
    }

    protected final void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.resultSet.updateClob(columnLabel, reader);
    }

    protected final void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.resultSet.updateClob(columnLabel, reader, length);
    }

    protected final void updateDate(int columnIndex, Date x) throws SQLException {
        this.resultSet.updateDate(columnIndex, x);
    }

    protected final void updateDate(String columnLabel, Date x) throws SQLException {
        this.resultSet.updateDate(columnLabel, x);
    }

    protected final void updateDouble(int columnIndex, double x) throws SQLException {
        this.resultSet.updateDouble(columnIndex, x);
    }

    protected final void updateDouble(String columnLabel, double x) throws SQLException {
        this.resultSet.updateDouble(columnLabel, x);
    }

    protected final void updateFloat(int columnIndex, float x) throws SQLException {
        this.resultSet.updateFloat(columnIndex, x);
    }

    protected final void updateFloat(String columnLabel, float x) throws SQLException {
        this.resultSet.updateFloat(columnLabel, x);
    }

    protected final void updateInt(int columnIndex, int x) throws SQLException {
        this.resultSet.updateInt(columnIndex, x);
    }

    protected final void updateInt(String columnLabel, int x) throws SQLException {
        this.resultSet.updateInt(columnLabel, x);
    }

    protected final void updateLong(int columnIndex, long x) throws SQLException {
        this.resultSet.updateLong(columnIndex, x);
    }

    protected final void updateLong(String columnLabel, long x) throws SQLException {
        this.resultSet.updateLong(columnLabel, x);
    }

    protected final void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.resultSet.updateNCharacterStream(columnIndex, x);
    }

    protected final void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.resultSet.updateNCharacterStream(columnIndex, x, length);
    }

    protected final void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.resultSet.updateNCharacterStream(columnLabel, reader);
    }

    protected final void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.resultSet.updateNCharacterStream(columnLabel, reader, length);
    }

    protected final void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.resultSet.updateNClob(columnIndex, nClob);
    }

    protected final void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.resultSet.updateNClob(columnIndex, reader);
    }

    protected final void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.resultSet.updateNClob(columnIndex, reader, length);
    }

    protected final void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.resultSet.updateNClob(columnLabel, nClob);
    }

    protected final void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.resultSet.updateNClob(columnLabel, reader);
    }

    protected final void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.resultSet.updateNClob(columnLabel, reader, length);
    }

    protected final void updateNString(int columnIndex, String nString) throws SQLException {
        this.resultSet.updateNString(columnIndex, nString);
    }

    protected final void updateNString(String columnLabel, String nString) throws SQLException {
        this.resultSet.updateNString(columnLabel, nString);
    }

    protected final void updateNull(int columnIndex) throws SQLException {
        this.resultSet.updateNull(columnIndex);
    }

    protected final void updateNull(String columnLabel) throws SQLException {
        this.resultSet.updateNull(columnLabel);
    }

    protected final void updateObject(int columnIndex, Object x) throws SQLException {
        this.resultSet.updateObject(columnIndex, x);
    }

    protected final void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.resultSet.updateObject(columnIndex, x, scaleOrLength);
    }

    protected final void updateObject(String columnLabel, Object x) throws SQLException {
        this.resultSet.updateObject(columnLabel, x);
    }

    protected final void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.resultSet.updateObject(columnLabel, x, scaleOrLength);
    }

    protected final void updateRef(int columnIndex, Ref x) throws SQLException {
        this.resultSet.updateRef(columnIndex, x);
    }

    protected final void updateRef(String columnLabel, Ref x) throws SQLException {
        this.resultSet.updateRef(columnLabel, x);
    }

    protected final void updateRow() throws SQLException {
        this.resultSet.updateRow();
    }

    protected final void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.resultSet.updateRowId(columnIndex, x);
    }

    protected final void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.resultSet.updateRowId(columnLabel, x);
    }

    protected final void updateShort(int columnIndex, short x) throws SQLException {
        this.resultSet.updateShort(columnIndex, x);
    }

    protected final void updateShort(String columnLabel, short x) throws SQLException {
        this.resultSet.updateShort(columnLabel, x);
    }

    protected final void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.resultSet.updateSQLXML(columnIndex, xmlObject);
    }

    protected final void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.resultSet.updateSQLXML(columnLabel, xmlObject);
    }

    protected final void updateString(int columnIndex, String x) throws SQLException {
        this.resultSet.updateString(columnIndex, x);
    }

    protected final void updateString(String columnLabel, String x) throws SQLException {
        this.resultSet.updateString(columnLabel, x);
    }

    protected final void updateTime(int columnIndex, Time x) throws SQLException {
        this.resultSet.updateTime(columnIndex, x);
    }

    protected final void updateTime(String columnLabel, Time x) throws SQLException {
        this.resultSet.updateTime(columnLabel, x);
    }

    protected final void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.resultSet.updateTimestamp(columnIndex, x);
    }

    protected final void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.resultSet.updateTimestamp(columnLabel, x);
    }

    protected final boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }
}

