/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.bug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BugCLI266Test {
    private final List<String> insertedOrder = Arrays.asList("h", "d", "f", "x", "s", "p", "t", "w", "o");
    private final List<String> sortOrder = Arrays.asList("d", "f", "h", "o", "p", "s", "t", "w", "x");

    BugCLI266Test() {
    }

    private void buildOptionsGroup(Options options) {
        OptionGroup optionGroup1 = new OptionGroup();
        OptionGroup optionGroup2 = new OptionGroup();
        optionGroup1.setRequired(true);
        optionGroup2.setRequired(true);
        optionGroup1.addOption(Option.builder((String)"d").longOpt("db").hasArg().argName("table-name").get());
        optionGroup1.addOption(Option.builder((String)"f").longOpt("flat-file").hasArg().argName("input.csv").get());
        options.addOptionGroup(optionGroup1);
        optionGroup2.addOption(Option.builder((String)"x").hasArg().argName("arg1").get());
        optionGroup2.addOption(Option.builder((String)"s").get());
        optionGroup2.addOption(Option.builder((String)"p").hasArg().argName("arg1").get());
        options.addOptionGroup(optionGroup2);
    }

    private Options getOptions() {
        Options options = new Options();
        Option help = Option.builder((String)"h").longOpt("help").desc("Prints this help message").get();
        options.addOption(help);
        this.buildOptionsGroup(options);
        Option t = Option.builder((String)"t").required().hasArg().argName("file").get();
        Option w = Option.builder((String)"w").required().hasArg().argName("word").get();
        Option o = Option.builder((String)"o").hasArg().argName("directory").get();
        options.addOption(t);
        options.addOption(w);
        options.addOption(o);
        return options;
    }

    @Test
    void testOptionComparatorDefaultOrder() {
        HelpFormatter formatter = new HelpFormatter();
        ArrayList options = new ArrayList(this.getOptions().getOptions());
        Collections.sort(options, formatter.getOptionComparator());
        int i = 0;
        for (Option o : options) {
            Assertions.assertEquals((Object)o.getOpt(), (Object)this.sortOrder.get(i));
            ++i;
        }
    }

    @Test
    void testOptionComparatorInsertedOrder() {
        Collection options = this.getOptions().getOptions();
        int i = 0;
        for (Option o : options) {
            Assertions.assertEquals((Object)o.getOpt(), (Object)this.insertedOrder.get(i));
            ++i;
        }
    }
}

