/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.awt.Dimension;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils2.converters.AbstractConverter;

public class DimensionConverter
extends AbstractConverter<Dimension> {
    private static final Pattern DIMENSION_PATTERN = Pattern.compile("(\\d+)(?:x(\\d+))?");

    public DimensionConverter() {
    }

    public DimensionConverter(Dimension defaultValue) {
        super(defaultValue);
    }

    @Override
    protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
        if (Dimension.class.isAssignableFrom(type)) {
            String stringValue = DimensionConverter.toString(value);
            if (stringValue.isEmpty()) {
                throw new IllegalArgumentException("Dimensions cannot be empty.");
            }
            Matcher matcher = DIMENSION_PATTERN.matcher(stringValue);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Dimension doesn't match format: {width/height} or {width}x{height}");
            }
            String x = matcher.group(1);
            String y = matcher.group(2);
            int xValue = Integer.parseInt(x);
            int yValue = y == null || x.equals(y) ? xValue : Integer.parseInt(y);
            return type.cast(new Dimension(xValue, yValue));
        }
        throw this.conversionException(type, value);
    }

    @Override
    protected Class<Dimension> getDefaultType() {
        return Dimension.class;
    }
}

