/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.A;
import org.apache.commons.beanutils.AlphaBean;
import org.apache.commons.beanutils.BetaBean;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PrimitiveBean;
import org.apache.commons.beanutils.TestBean;
import org.apache.commons.beanutils.priv.PrivateBeanFactory;
import org.apache.commons.beanutils.priv.PublicSubBean;

public class MethodUtilsTestCase
extends TestCase {
    private static void assertMethod(Method method, String methodName) {
        MethodUtilsTestCase.assertNotNull((Object)method);
        MethodUtilsTestCase.assertEquals((String)"Method is not named correctly", (String)methodName, (String)method.getName());
        MethodUtilsTestCase.assertTrue((String)"Method is not public", (boolean)Modifier.isPublic(method.getModifiers()));
    }

    public static Test suite() {
        return new TestSuite(MethodUtilsTestCase.class);
    }

    public MethodUtilsTestCase(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testClearCache() throws Exception {
        MethodUtils.clearCache();
        PublicSubBean bean = new PublicSubBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setFoo", (Object)"alpha");
        MethodUtilsTestCase.assertEquals((int)1, (int)MethodUtils.clearCache());
        MethodUtilsTestCase.assertEquals((int)0, (int)MethodUtils.clearCache());
    }

    public void testGetAccessibleMethod() {
        Method method = MethodUtils.getAccessibleMethod(TestBean.class, (String)"setStringProperty", String.class);
        MethodUtilsTestCase.assertMethod(method, "setStringProperty");
    }

    public void testGetAccessibleMethodFromInterface() {
        Method method = MethodUtils.getAccessibleMethod(PrivateBeanFactory.create().getClass(), (String)"methodBar", String.class);
        MethodUtilsTestCase.assertMethod(method, "methodBar");
    }

    public void testGetAccessibleMethodIndirectInterface() {
        Method method = MethodUtils.getAccessibleMethod(PrivateBeanFactory.createSubclass().getClass(), (String)"methodBaz", String.class);
        MethodUtilsTestCase.assertMethod(method, "methodBaz");
    }

    public void testInvokeExactMethod() throws Exception {
        TestBean bean = new TestBean();
        Object ret = MethodUtils.invokeExactMethod((Object)bean, (String)"setStringProperty", (Object)"TEST");
        MethodUtilsTestCase.assertNull((Object)ret);
        MethodUtilsTestCase.assertEquals((String)"Method ONE was invoked", (String)"TEST", (String)bean.getStringProperty());
    }

    public void testInvokeExactMethodFromInterface() throws Exception {
        Object ret = MethodUtils.invokeExactMethod((Object)PrivateBeanFactory.create(), (String)"methodBar", (Object)"ANOTHER TEST");
        MethodUtilsTestCase.assertEquals((String)"Method TWO wasn't invoked correctly", (Object)"ANOTHER TEST", (Object)ret);
    }

    public void testInvokeExactMethodIndirectInterface() throws Exception {
        Object ret = MethodUtils.invokeExactMethod((Object)PrivateBeanFactory.createSubclass(), (String)"methodBaz", (Object)"YET ANOTHER TEST");
        MethodUtilsTestCase.assertEquals((String)"Method TWO was invoked correctly", (Object)"YET ANOTHER TEST", (Object)ret);
    }

    public void testInvokeExactMethodNull() throws Exception {
        Object object = new Object();
        Object result = MethodUtils.invokeExactMethod((Object)object, (String)"toString", null);
        MethodUtilsTestCase.assertEquals((Object)object.toString(), (Object)result);
    }

    public void testInvokeExactMethodNullArray() throws Exception {
        Object result = MethodUtils.invokeExactMethod((Object)new AlphaBean("parent"), (String)"getName", null);
        MethodUtilsTestCase.assertEquals((Object)"parent", (Object)result);
    }

    public void testInvokeExactMethodNullArrayNullArray() throws Exception {
        Object result = MethodUtils.invokeExactMethod((Object)new AlphaBean("parent"), (String)"getName", null, null);
        MethodUtilsTestCase.assertEquals((Object)"parent", (Object)result);
    }

    public void testInvokeExactStaticMethodNull() throws Exception {
        int current = TestBean.currentCounter();
        Object value = MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"currentCounter", null);
        MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)current, (int)((Integer)value));
    }

    public void testInvokeMethod() throws Exception {
        AlphaBean parent = new AlphaBean("parent");
        BetaBean childOne = new BetaBean("ChildOne");
        MethodUtilsTestCase.assertEquals((String)"Cannot invoke through abstract class (1)", (Object)"ChildOne", (Object)MethodUtils.invokeMethod((Object)parent, (String)"testAddChild", (Object)childOne));
    }

    public void testInvokeMethodArray() throws Exception {
        AlphaBean parent = new AlphaBean("parent");
        AlphaBean childTwo = new AlphaBean("ChildTwo");
        Object[] params = new Object[]{"parameter", childTwo};
        MethodUtilsTestCase.assertEquals((String)"Cannot invoke through abstract class", (Object)"ChildTwo", (Object)MethodUtils.invokeMethod((Object)parent, (String)"testAddChild2", (Object[])params));
    }

    public void testInvokeMethodNull() throws Exception {
        Object object = new Object();
        Object result = MethodUtils.invokeMethod((Object)object, (String)"toString", null);
        MethodUtilsTestCase.assertEquals((Object)object.toString(), (Object)result);
    }

    public void testInvokeMethodNullArray() throws Exception {
        Object result = MethodUtils.invokeMethod((Object)new AlphaBean("parent"), (String)"getName", null);
        MethodUtilsTestCase.assertEquals((Object)"parent", (Object)result);
    }

    public void testInvokeMethodNullArrayNullArray() throws Exception {
        Object result = MethodUtils.invokeMethod((Object)new AlphaBean("parent"), (String)"getName", null, null);
        MethodUtilsTestCase.assertEquals((Object)"parent", (Object)result);
    }

    public void testInvokeMethodObject() throws Exception {
        AlphaBean parent = new AlphaBean("parent");
        AlphaBean childTwo = new AlphaBean("ChildTwo");
        MethodUtilsTestCase.assertEquals((String)"Cannot invoke through interface (1)", (Object)"ChildTwo", (Object)MethodUtils.invokeMethod((Object)parent, (String)"testAddChild", (Object)childTwo));
    }

    public void testInvokeMethodPrimitiveBoolean() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setBoolean", (Object)Boolean.FALSE);
        MethodUtilsTestCase.assertEquals((String)"Call boolean property using invokeMethod", (boolean)false, (boolean)bean.getBoolean());
    }

    public void testInvokeMethodPrimitiveDouble() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setDouble", (Object)25.5);
        MethodUtilsTestCase.assertEquals((String)"Set double property using invokeMethod", (double)25.5, (double)bean.getDouble(), (double)0.01);
    }

    public void testInvokeMethodPrimitiveFloat() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setFloat", (Object)Float.valueOf(20.0f));
        MethodUtilsTestCase.assertEquals((String)"Call float property using invokeMethod", (float)20.0f, (float)bean.getFloat(), (float)0.01f);
    }

    public void testInvokeMethodPrimitiveInt() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setInt", (Object)12);
        MethodUtilsTestCase.assertEquals((String)"Set int property using invokeMethod", (int)12, (int)bean.getInt());
    }

    public void testInvokeMethodPrimitiveLong() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setLong", (Object)10L);
        MethodUtilsTestCase.assertEquals((String)"Call long property using invokeMethod", (long)10L, (long)bean.getLong());
    }

    public void testInvokeMethodUnknown() throws Exception {
        try {
            AlphaBean parent = new AlphaBean("parent");
            BetaBean childOne = new BetaBean("ChildOne");
            MethodUtils.invokeMethod((Object)parent, (String)"bogus", (Object)childOne);
            MethodUtilsTestCase.fail((String)"No exception thrown when no appropriate method exists");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testInvokeStaticMethodNull() throws Exception {
        int current = TestBean.currentCounter();
        Object value = MethodUtils.invokeStaticMethod(TestBean.class, (String)"currentCounter", null);
        MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)current, (int)((Integer)value));
    }

    public void testNoCaching() throws Exception {
        MethodUtils.setCacheMethods((boolean)false);
        PublicSubBean bean = new PublicSubBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setFoo", (Object)"alpha");
        MethodUtilsTestCase.assertEquals((int)0, (int)MethodUtils.clearCache());
        MethodUtils.setCacheMethods((boolean)true);
    }

    public void testParentMethod() throws Exception {
        PrintStream os = new PrintStream(System.out);
        PrintStream ps = new PrintStream(System.out);
        A a = new A();
        MethodUtils.invokeMethod((Object)a, (String)"foo", (Object)os);
        MethodUtilsTestCase.assertTrue((String)"Method Invoked(1)", (boolean)a.called);
        a = new A();
        MethodUtils.invokeMethod((Object)a, (String)"foo", (Object)ps);
        MethodUtilsTestCase.assertTrue((String)"Method Invoked(2)", (boolean)a.called);
    }

    public void testPublicSub() throws Exception {
        PublicSubBean bean = new PublicSubBean();
        MethodUtilsTestCase.assertEquals((String)"Start value (foo)", (String)bean.getFoo(), (String)"This is foo");
        MethodUtilsTestCase.assertEquals((String)"Start value (bar)", (String)bean.getBar(), (String)"This is bar");
        bean.setFoo("new foo");
        bean.setBar("new bar");
        MethodUtilsTestCase.assertEquals((String)"Set value (foo)", (String)bean.getFoo(), (String)"new foo");
        MethodUtilsTestCase.assertEquals((String)"Set value (bar)", (String)bean.getBar(), (String)"new bar");
        MethodUtils.invokeMethod((Object)bean, (String)"setFoo", (Object)"alpha");
        MethodUtilsTestCase.assertEquals((String)"Set value (foo:2)", (String)bean.getFoo(), (String)"alpha");
        MethodUtils.invokeMethod((Object)bean, (String)"setBar", (Object)"beta");
        MethodUtilsTestCase.assertEquals((String)"Set value (bar:2)", (String)bean.getBar(), (String)"beta");
        Method method = null;
        try {
            method = MethodUtils.getAccessibleMethod(PublicSubBean.class, (String)"setFoo", String.class);
        }
        catch (Throwable t) {
            MethodUtilsTestCase.fail((String)("getAccessibleMethod() setFoo threw " + t));
        }
        MethodUtilsTestCase.assertNotNull((String)"getAccessibleMethod() setFoo is Null", (Object)method);
        try {
            method.invoke((Object)bean, "1111");
        }
        catch (Throwable t) {
            MethodUtilsTestCase.fail((String)("Invoking setFoo threw " + t));
        }
        MethodUtilsTestCase.assertEquals((String)"Set value (foo:3)", (String)"1111", (String)bean.getFoo());
        try {
            method = MethodUtils.getAccessibleMethod(PublicSubBean.class, (String)"setBar", String.class);
        }
        catch (Throwable t) {
            MethodUtilsTestCase.fail((String)("getAccessibleMethod() setBar threw " + t));
        }
        MethodUtilsTestCase.assertNotNull((String)"getAccessibleMethod() setBar is Null", (Object)method);
        try {
            method.invoke((Object)bean, "2222");
        }
        catch (Throwable t) {
            MethodUtilsTestCase.fail((String)("Invoking setBar threw " + t));
        }
        MethodUtilsTestCase.assertEquals((String)"Set value (bar:3)", (String)"2222", (String)bean.getBar());
    }

    public void testSetCacheMethods() throws Exception {
        MethodUtils.setCacheMethods((boolean)true);
        MethodUtils.clearCache();
        PublicSubBean bean = new PublicSubBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setFoo", (Object)"alpha");
        MethodUtilsTestCase.assertEquals((int)1, (int)MethodUtils.clearCache());
        MethodUtilsTestCase.assertEquals((int)0, (int)MethodUtils.clearCache());
    }

    public void testSimpleStatic1() {
        TestBean bean = new TestBean();
        Object value = null;
        int current = TestBean.currentCounter();
        try {
            value = MethodUtils.invokeMethod((Object)bean, (String)"currentCounter", (Object[])new Object[0], (Class[])new Class[0]);
            MethodUtilsTestCase.assertNotNull((String)"currentCounter exists", (Object)value);
            MethodUtilsTestCase.assertTrue((String)"currentCounter type", (boolean)(value instanceof Integer));
            MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)current, (int)((Integer)value));
            MethodUtils.invokeMethod((Object)bean, (String)"incrementCounter", (Object[])new Object[0], (Class[])new Class[0]);
            value = MethodUtils.invokeMethod((Object)bean, (String)"currentCounter", (Object[])new Object[0], (Class[])new Class[0]);
            MethodUtilsTestCase.assertNotNull((String)"currentCounter exists", (Object)value);
            MethodUtilsTestCase.assertTrue((String)"currentCounter type", (boolean)(value instanceof Integer));
            MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)(++current), (int)((Integer)value));
            MethodUtils.invokeMethod((Object)bean, (String)"incrementCounter", (Object[])new Object[]{5}, (Class[])new Class[]{Integer.TYPE});
            value = MethodUtils.invokeMethod((Object)bean, (String)"currentCounter", (Object[])new Object[0], (Class[])new Class[0]);
            MethodUtilsTestCase.assertNotNull((String)"currentCounter exists", (Object)value);
            MethodUtilsTestCase.assertTrue((String)"currentCounter type", (boolean)(value instanceof Integer));
            MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)(current += 5), (int)((Integer)value));
        }
        catch (Exception e) {
            MethodUtilsTestCase.fail((String)("Threw exception" + e));
        }
    }

    public void testSimpleStatic2() {
        TestBean bean = new TestBean();
        Object value = null;
        int current = TestBean.currentCounter();
        try {
            value = MethodUtils.invokeExactMethod((Object)bean, (String)"currentCounter", (Object[])new Object[0], (Class[])new Class[0]);
            MethodUtilsTestCase.assertNotNull((String)"currentCounter exists", (Object)value);
            MethodUtilsTestCase.assertTrue((String)"currentCounter type", (boolean)(value instanceof Integer));
            MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)current, (int)((Integer)value));
            MethodUtils.invokeExactMethod((Object)bean, (String)"incrementCounter", (Object[])new Object[0], (Class[])new Class[0]);
            value = MethodUtils.invokeExactMethod((Object)bean, (String)"currentCounter", (Object[])new Object[0], (Class[])new Class[0]);
            MethodUtilsTestCase.assertNotNull((String)"currentCounter exists", (Object)value);
            MethodUtilsTestCase.assertTrue((String)"currentCounter type", (boolean)(value instanceof Integer));
            MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)(++current), (int)((Integer)value));
            MethodUtils.invokeExactMethod((Object)bean, (String)"incrementCounter", (Object[])new Object[]{5}, (Class[])new Class[]{Integer.TYPE});
            value = MethodUtils.invokeExactMethod((Object)bean, (String)"currentCounter", (Object[])new Object[0], (Class[])new Class[0]);
            MethodUtilsTestCase.assertNotNull((String)"currentCounter exists", (Object)value);
            MethodUtilsTestCase.assertTrue((String)"currentCounter type", (boolean)(value instanceof Integer));
            MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)(current += 5), (int)((Integer)value));
        }
        catch (Exception e) {
            MethodUtilsTestCase.fail((String)("Threw exception" + e));
        }
    }

    public void testSimpleStatic3() {
        Object value = null;
        int current = TestBean.currentCounter();
        try {
            Method currentCounterMethod = MethodUtils.getAccessibleMethod(TestBean.class, (String)"currentCounter", (Class[])new Class[0]);
            MethodUtilsTestCase.assertNotNull((String)"currentCounterMethod exists", (Object)currentCounterMethod);
            MethodUtilsTestCase.assertEquals((String)"currentCounterMethod name", (String)"currentCounter", (String)currentCounterMethod.getName());
            MethodUtilsTestCase.assertEquals((String)"currentCounterMethod args", (int)0, (int)currentCounterMethod.getParameterTypes().length);
            MethodUtilsTestCase.assertTrue((String)"currentCounterMethod public", (boolean)Modifier.isPublic(currentCounterMethod.getModifiers()));
            MethodUtilsTestCase.assertTrue((String)"currentCounterMethod static", (boolean)Modifier.isStatic(currentCounterMethod.getModifiers()));
            Method incrementCounterMethod1 = MethodUtils.getAccessibleMethod(TestBean.class, (String)"incrementCounter", (Class[])new Class[0]);
            MethodUtilsTestCase.assertNotNull((String)"incrementCounterMethod1 exists", (Object)incrementCounterMethod1);
            MethodUtilsTestCase.assertEquals((String)"incrementCounterMethod1 name", (String)"incrementCounter", (String)incrementCounterMethod1.getName());
            MethodUtilsTestCase.assertEquals((String)"incrementCounterMethod1 args", (int)0, (int)incrementCounterMethod1.getParameterTypes().length);
            MethodUtilsTestCase.assertTrue((String)"incrementCounterMethod1 public", (boolean)Modifier.isPublic(incrementCounterMethod1.getModifiers()));
            MethodUtilsTestCase.assertTrue((String)"incrementCounterMethod1 static", (boolean)Modifier.isStatic(incrementCounterMethod1.getModifiers()));
            Method incrementCounterMethod2 = MethodUtils.getAccessibleMethod(TestBean.class, (String)"incrementCounter", (Class[])new Class[]{Integer.TYPE});
            MethodUtilsTestCase.assertNotNull((String)"incrementCounterMethod2 exists", (Object)incrementCounterMethod2);
            MethodUtilsTestCase.assertEquals((String)"incrementCounterMethod2 name", (String)"incrementCounter", (String)incrementCounterMethod2.getName());
            MethodUtilsTestCase.assertEquals((String)"incrementCounterMethod2 args", (int)1, (int)incrementCounterMethod2.getParameterTypes().length);
            MethodUtilsTestCase.assertTrue((String)"incrementCounterMethod2 public", (boolean)Modifier.isPublic(incrementCounterMethod2.getModifiers()));
            MethodUtilsTestCase.assertTrue((String)"incrementCounterMethod2 static", (boolean)Modifier.isStatic(incrementCounterMethod2.getModifiers()));
            value = currentCounterMethod.invoke(null, new Object[0]);
            MethodUtilsTestCase.assertNotNull((String)"currentCounter exists", (Object)value);
            MethodUtilsTestCase.assertTrue((String)"currentCounter type", (boolean)(value instanceof Integer));
            MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)current, (int)((Integer)value));
            incrementCounterMethod1.invoke(null, new Object[0]);
            value = currentCounterMethod.invoke(null, new Object[0]);
            MethodUtilsTestCase.assertNotNull((String)"currentCounter exists", (Object)value);
            MethodUtilsTestCase.assertTrue((String)"currentCounter type", (boolean)(value instanceof Integer));
            MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)(++current), (int)((Integer)value));
            incrementCounterMethod2.invoke(null, 5);
            value = currentCounterMethod.invoke(null, new Object[0]);
            MethodUtilsTestCase.assertNotNull((String)"currentCounter exists", (Object)value);
            MethodUtilsTestCase.assertTrue((String)"currentCounter type", (boolean)(value instanceof Integer));
            MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)(current += 5), (int)((Integer)value));
        }
        catch (Exception e) {
            MethodUtilsTestCase.fail((String)("Threw exception" + e));
        }
    }

    public void testStaticInvokeMethod() throws Exception {
        Object value = null;
        int current = TestBean.currentCounter();
        value = MethodUtils.invokeStaticMethod(TestBean.class, (String)"currentCounter", (Object[])new Object[0]);
        MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)current, (int)((Integer)value));
        MethodUtils.invokeStaticMethod(TestBean.class, (String)"incrementCounter", (Object[])new Object[0]);
        value = MethodUtils.invokeStaticMethod(TestBean.class, (String)"currentCounter", (Object[])new Object[0]);
        MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)(++current), (int)((Integer)value));
        MethodUtils.invokeStaticMethod(TestBean.class, (String)"incrementCounter", (Object[])new Object[]{8});
        value = MethodUtils.invokeStaticMethod(TestBean.class, (String)"currentCounter", (Object[])new Object[0]);
        MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)(current += 8), (int)((Integer)value));
        MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"incrementCounter", (Object[])new Object[]{8}, (Class[])new Class[]{Number.class});
        value = MethodUtils.invokeStaticMethod(TestBean.class, (String)"currentCounter", (Object[])new Object[0]);
        MethodUtilsTestCase.assertEquals((String)"currentCounter value", (int)(current += 16), (int)((Integer)value));
    }
}

