/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import java.beans.PropertyDescriptor;
import junit.framework.TestCase;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.FluentIntrospectionTestBean;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class Jira456TestCase
extends TestCase {
    private static final String TEST_PROP = "fluentGetProperty";
    private PropertyUtilsBean pub;

    private FluentIntrospectionTestBean clearWriteMethodRef() throws Exception {
        FluentIntrospectionTestBean bean = new FluentIntrospectionTestBean();
        PropertyDescriptor pd = this.pub.getPropertyDescriptor((Object)bean, TEST_PROP);
        pd.setWriteMethod(null);
        return bean;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.pub = new PropertyUtilsBean();
        this.pub.addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospector());
    }

    public void testPropertyIsWritable() throws Exception {
        FluentIntrospectionTestBean bean = this.clearWriteMethodRef();
        Jira456TestCase.assertTrue((String)"Not writable", (boolean)this.pub.isWriteable((Object)bean, TEST_PROP));
    }

    public void testWriteMethodRecover() throws Exception {
        FluentIntrospectionTestBean bean = this.clearWriteMethodRef();
        String value = "Test value";
        this.pub.setProperty((Object)bean, TEST_PROP, (Object)"Test value");
        Jira456TestCase.assertEquals((String)"Property not set", (String)"Test value", (String)bean.getFluentGetProperty());
    }
}

