/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.ClientGSIContext;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.ClientHAProxyFactory;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.hdfs.server.namenode.ha.ReadOnly;
import org.apache.hadoop.io.retry.AtMostOnce;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.Idempotent;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ObserverRetryOnActiveException;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RpcInvocationHandler;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ObserverReadProxyProvider<T extends ClientProtocol>
extends AbstractNNFailoverProxyProvider<T> {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(ObserverReadProxyProvider.class);
    static final String AUTO_MSYNC_PERIOD_KEY_PREFIX = "dfs.client.failover.observer.auto-msync-period";
    static final long AUTO_MSYNC_PERIOD_DEFAULT = -1L;
    private final AlignmentContext alignmentContext;
    private final AbstractNNFailoverProxyProvider<T> failoverProxy;
    private final List<AbstractNNFailoverProxyProvider.NNProxyInfo<T>> nameNodeProxies;
    private final RetryPolicy observerRetryPolicy;
    private final FailoverProxyProvider.ProxyInfo<T> combinedProxy;
    private boolean observerReadEnabled;
    private final long autoMsyncPeriodMs;
    private volatile long lastMsyncTimeMs = -1L;
    private volatile boolean msynced = false;
    private int currentIndex = -1;
    private AbstractNNFailoverProxyProvider.NNProxyInfo<T> currentProxy;
    private volatile FailoverProxyProvider.ProxyInfo<T> lastProxy = null;

    public ObserverReadProxyProvider(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory) {
        this(conf, uri, xface, factory, new ConfiguredFailoverProxyProvider<T>(conf, uri, xface, factory));
    }

    public ObserverReadProxyProvider(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory, AbstractNNFailoverProxyProvider<T> failoverProxy) {
        super(conf, uri, xface, factory);
        this.failoverProxy = failoverProxy;
        this.alignmentContext = new ClientGSIContext();
        ((ClientHAProxyFactory)factory).setAlignmentContext(this.alignmentContext);
        this.observerRetryPolicy = RetryPolicies.failoverOnNetworkException(RetryPolicies.TRY_ONCE_THEN_FAIL, 1);
        this.nameNodeProxies = this.getProxyAddresses(uri, "dfs.namenode.rpc-address");
        StringBuilder combinedInfo = new StringBuilder("[");
        for (int i = 0; i < this.nameNodeProxies.size(); ++i) {
            if (i > 0) {
                combinedInfo.append(",");
            }
            combinedInfo.append(this.nameNodeProxies.get((int)i).proxyInfo);
        }
        combinedInfo.append(']');
        ClientProtocol wrappedProxy = (ClientProtocol)Proxy.newProxyInstance(ObserverReadInvocationHandler.class.getClassLoader(), new Class[]{xface}, (InvocationHandler)new ObserverReadInvocationHandler());
        this.combinedProxy = new FailoverProxyProvider.ProxyInfo<ClientProtocol>(wrappedProxy, combinedInfo.toString());
        this.autoMsyncPeriodMs = conf.getTimeDuration("dfs.client.failover.observer.auto-msync-period." + uri.getHost(), -1L, TimeUnit.MILLISECONDS);
        this.observerReadEnabled = true;
    }

    public AlignmentContext getAlignmentContext() {
        return this.alignmentContext;
    }

    @Override
    public FailoverProxyProvider.ProxyInfo<T> getProxy() {
        return this.combinedProxy;
    }

    @Override
    public void performFailover(T currentProxy) {
        this.failoverProxy.performFailover(currentProxy);
    }

    private static boolean isRead(Method method) {
        if (!method.isAnnotationPresent(ReadOnly.class)) {
            return false;
        }
        return !((ReadOnly[])method.getAnnotationsByType(ReadOnly.class))[0].activeOnly();
    }

    @VisibleForTesting
    void setObserverReadEnabled(boolean flag) {
        this.observerReadEnabled = flag;
    }

    @VisibleForTesting
    FailoverProxyProvider.ProxyInfo<T> getLastProxy() {
        return this.lastProxy;
    }

    private AbstractNNFailoverProxyProvider.NNProxyInfo<T> getCurrentProxy() {
        return this.changeProxy(null);
    }

    private synchronized AbstractNNFailoverProxyProvider.NNProxyInfo<T> changeProxy(AbstractNNFailoverProxyProvider.NNProxyInfo<T> initial) {
        if (this.currentProxy != initial) {
            return this.currentProxy;
        }
        this.currentIndex = (this.currentIndex + 1) % this.nameNodeProxies.size();
        this.currentProxy = this.createProxyIfNeeded(this.nameNodeProxies.get(this.currentIndex));
        this.currentProxy.setCachedState(this.getHAServiceState(this.currentProxy));
        LOG.debug("Changed current proxy from {} to {}", (Object)(initial == null ? "none" : initial.proxyInfo), (Object)this.currentProxy.proxyInfo);
        return this.currentProxy;
    }

    private HAServiceProtocol.HAServiceState getHAServiceState(AbstractNNFailoverProxyProvider.NNProxyInfo<T> proxyInfo) {
        IOException ioe;
        try {
            return ((ClientProtocol)proxyInfo.proxy).getHAServiceState();
        }
        catch (RemoteException re) {
            if (re.unwrapRemoteException() instanceof StandbyException) {
                LOG.debug("NameNode {} threw StandbyException when fetching HAState", (Object)proxyInfo.getAddress());
                return HAServiceProtocol.HAServiceState.STANDBY;
            }
            ioe = re;
        }
        catch (IOException e) {
            ioe = e;
        }
        LOG.info("Failed to connect to {}. Assuming Standby state", (Object)proxyInfo.getAddress(), (Object)ioe);
        return HAServiceProtocol.HAServiceState.STANDBY;
    }

    private synchronized void initializeMsync() throws IOException {
        if (this.msynced) {
            return;
        }
        ((ClientProtocol)this.failoverProxy.getProxy().proxy).msync();
        this.msynced = true;
        this.lastMsyncTimeMs = Time.monotonicNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoMsyncIfNecessary() throws IOException {
        if (this.autoMsyncPeriodMs == 0L) {
            ((ClientProtocol)this.failoverProxy.getProxy().proxy).msync();
        } else if (this.autoMsyncPeriodMs > 0L && Time.monotonicNow() - this.lastMsyncTimeMs > this.autoMsyncPeriodMs) {
            ObserverReadProxyProvider observerReadProxyProvider = this;
            synchronized (observerReadProxyProvider) {
                if (Time.monotonicNow() - this.lastMsyncTimeMs > this.autoMsyncPeriodMs) {
                    ((ClientProtocol)this.failoverProxy.getProxy().proxy).msync();
                    this.lastMsyncTimeMs = Time.monotonicNow();
                }
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        for (FailoverProxyProvider.ProxyInfo proxyInfo : this.nameNodeProxies) {
            if (proxyInfo.proxy == null) continue;
            if (proxyInfo.proxy instanceof Closeable) {
                ((Closeable)proxyInfo.proxy).close();
            } else {
                RPC.stopProxy(proxyInfo.proxy);
            }
            proxyInfo.proxy = null;
        }
        this.failoverProxy.close();
    }

    @Override
    public boolean useLogicalURI() {
        return this.failoverProxy.useLogicalURI();
    }

    private class ObserverReadInvocationHandler
    implements RpcInvocationHandler {
        private ObserverReadInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object retVal;
            ObserverReadProxyProvider.this.lastProxy = null;
            if (ObserverReadProxyProvider.this.observerReadEnabled && ObserverReadProxyProvider.isRead(method)) {
                if (!ObserverReadProxyProvider.this.msynced) {
                    ObserverReadProxyProvider.this.initializeMsync();
                } else {
                    ObserverReadProxyProvider.this.autoMsyncIfNecessary();
                }
                int failedObserverCount = 0;
                int activeCount = 0;
                int standbyCount = 0;
                for (int i = 0; i < ObserverReadProxyProvider.this.nameNodeProxies.size(); ++i) {
                    AbstractNNFailoverProxyProvider.NNProxyInfo current = ObserverReadProxyProvider.this.getCurrentProxy();
                    HAServiceProtocol.HAServiceState currState = current.getCachedState();
                    if (currState != HAServiceProtocol.HAServiceState.OBSERVER) {
                        if (currState == HAServiceProtocol.HAServiceState.ACTIVE) {
                            ++activeCount;
                        } else if (currState == HAServiceProtocol.HAServiceState.STANDBY) {
                            ++standbyCount;
                        }
                        LOG.debug("Skipping proxy {} for {} because it is in state {}", new Object[]{current.proxyInfo, method.getName(), currState});
                        ObserverReadProxyProvider.this.changeProxy(current);
                        continue;
                    }
                    LOG.debug("Attempting to service {} using proxy {}", (Object)method.getName(), (Object)current.proxyInfo);
                    try {
                        Object retVal2 = method.invoke(current.proxy, args);
                        ObserverReadProxyProvider.this.lastProxy = current;
                        LOG.debug("Invocation of {} using {} was successful", (Object)method.getName(), (Object)current.proxyInfo);
                        return retVal2;
                    }
                    catch (InvocationTargetException ite) {
                        RemoteException re;
                        IOException unwrapped;
                        if (!(ite.getCause() instanceof Exception)) {
                            throw ite.getCause();
                        }
                        Exception e = (Exception)ite.getCause();
                        if (e instanceof RemoteException && (unwrapped = (re = (RemoteException)e).unwrapRemoteException(ObserverRetryOnActiveException.class)) instanceof ObserverRetryOnActiveException) {
                            LOG.info("Encountered ObserverRetryOnActiveException from {}. Retry active namenode directly.", (Object)current.proxyInfo);
                            break;
                        }
                        RetryPolicy.RetryAction retryInfo = ObserverReadProxyProvider.this.observerRetryPolicy.shouldRetry(e, 0, 0, method.isAnnotationPresent(Idempotent.class) || method.isAnnotationPresent(AtMostOnce.class));
                        if (retryInfo.action == RetryPolicy.RetryAction.RetryDecision.FAIL) {
                            throw e;
                        }
                        LOG.warn("Invocation returned exception on [{}]; {} failure(s) so far", new Object[]{current.proxyInfo, ++failedObserverCount, e});
                        ObserverReadProxyProvider.this.changeProxy(current);
                    }
                }
                LOG.warn("{} observers have failed for read request {}; also found {} standby and {} active. Falling back to active.", new Object[]{failedObserverCount, method.getName(), standbyCount, activeCount});
            }
            LOG.debug("Using failoverProxy to service {}", (Object)method.getName());
            FailoverProxyProvider.ProxyInfo activeProxy = ObserverReadProxyProvider.this.failoverProxy.getProxy();
            try {
                retVal = method.invoke(activeProxy.proxy, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            ObserverReadProxyProvider.this.msynced = true;
            ObserverReadProxyProvider.this.lastMsyncTimeMs = Time.monotonicNow();
            ObserverReadProxyProvider.this.lastProxy = activeProxy;
            return retVal;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public Client.ConnectionId getConnectionId() {
            return RPC.getConnectionIdForProxy(((ObserverReadProxyProvider)ObserverReadProxyProvider.this).getCurrentProxy().proxy);
        }
    }
}

