/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.grpc.inprocess;

import com.google.errorprone.annotations.DoNotCall;
import java.net.SocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.ratis.thirdparty.com.google.common.base.Preconditions;
import org.apache.ratis.thirdparty.io.grpc.ChannelCredentials;
import org.apache.ratis.thirdparty.io.grpc.ChannelLogger;
import org.apache.ratis.thirdparty.io.grpc.ExperimentalApi;
import org.apache.ratis.thirdparty.io.grpc.Internal;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.inprocess.InProcessSocketAddress;
import org.apache.ratis.thirdparty.io.grpc.inprocess.InProcessTransport;
import org.apache.ratis.thirdparty.io.grpc.internal.AbstractManagedChannelImplBuilder;
import org.apache.ratis.thirdparty.io.grpc.internal.ClientTransportFactory;
import org.apache.ratis.thirdparty.io.grpc.internal.ConnectionClientTransport;
import org.apache.ratis.thirdparty.io.grpc.internal.GrpcUtil;
import org.apache.ratis.thirdparty.io.grpc.internal.ManagedChannelImplBuilder;
import org.apache.ratis.thirdparty.io.grpc.internal.SharedResourceHolder;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1783")
public final class InProcessChannelBuilder
extends AbstractManagedChannelImplBuilder<InProcessChannelBuilder> {
    private final ManagedChannelImplBuilder managedChannelImplBuilder;
    private ScheduledExecutorService scheduledExecutorService;
    private int maxInboundMetadataSize = Integer.MAX_VALUE;
    private boolean transportIncludeStatusCause = false;

    public static InProcessChannelBuilder forName(String name) {
        return InProcessChannelBuilder.forAddress(new InProcessSocketAddress(Preconditions.checkNotNull(name, "name")));
    }

    public static InProcessChannelBuilder forTarget(String target) {
        return new InProcessChannelBuilder(null, Preconditions.checkNotNull(target, "target"));
    }

    public static InProcessChannelBuilder forAddress(SocketAddress address) {
        return new InProcessChannelBuilder(Preconditions.checkNotNull(address, "address"), null);
    }

    @DoNotCall(value="Unsupported. Use forName() instead")
    public static InProcessChannelBuilder forAddress(String name, int port) {
        throw new UnsupportedOperationException("call forName() instead");
    }

    private InProcessChannelBuilder(@Nullable SocketAddress directAddress, @Nullable String target) {
        final class InProcessChannelTransportFactoryBuilder
        implements ManagedChannelImplBuilder.ClientTransportFactoryBuilder {
            InProcessChannelTransportFactoryBuilder() {
            }

            @Override
            public ClientTransportFactory buildClientTransportFactory() {
                return InProcessChannelBuilder.this.buildTransportFactory();
            }
        }
        this.managedChannelImplBuilder = directAddress != null ? new ManagedChannelImplBuilder(directAddress, "localhost", new InProcessChannelTransportFactoryBuilder(), null) : new ManagedChannelImplBuilder(target, new InProcessChannelTransportFactoryBuilder(), null);
        this.managedChannelImplBuilder.setStatsRecordStartedRpcs(false);
        this.managedChannelImplBuilder.setStatsRecordFinishedRpcs(false);
        this.managedChannelImplBuilder.setStatsRecordRetryMetrics(false);
        this.managedChannelImplBuilder.disableRetry();
    }

    @Override
    @Internal
    protected ManagedChannelBuilder<?> delegate() {
        return this.managedChannelImplBuilder;
    }

    @Override
    public InProcessChannelBuilder maxInboundMessageSize(int max) {
        return (InProcessChannelBuilder)super.maxInboundMessageSize(max);
    }

    @Override
    public InProcessChannelBuilder useTransportSecurity() {
        return this;
    }

    @Override
    public InProcessChannelBuilder usePlaintext() {
        return this;
    }

    @Override
    public InProcessChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        return this;
    }

    @Override
    public InProcessChannelBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        return this;
    }

    @Override
    public InProcessChannelBuilder keepAliveWithoutCalls(boolean enable) {
        return this;
    }

    public InProcessChannelBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = Preconditions.checkNotNull(scheduledExecutorService, "scheduledExecutorService");
        return this;
    }

    @Override
    public InProcessChannelBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument(bytes > 0, "maxInboundMetadataSize must be > 0");
        this.maxInboundMetadataSize = bytes;
        return this;
    }

    public InProcessChannelBuilder propagateCauseWithStatus(boolean enable) {
        this.transportIncludeStatusCause = enable;
        return this;
    }

    ClientTransportFactory buildTransportFactory() {
        return new InProcessClientTransportFactory(this.scheduledExecutorService, this.maxInboundMetadataSize, this.transportIncludeStatusCause);
    }

    void setStatsEnabled(boolean value) {
        this.managedChannelImplBuilder.setStatsEnabled(value);
    }

    static final class InProcessClientTransportFactory
    implements ClientTransportFactory {
        private final ScheduledExecutorService timerService;
        private final boolean useSharedTimer;
        private final int maxInboundMetadataSize;
        private boolean closed;
        private final boolean includeCauseWithStatus;

        private InProcessClientTransportFactory(@Nullable ScheduledExecutorService scheduledExecutorService, int maxInboundMetadataSize, boolean includeCauseWithStatus) {
            this.useSharedTimer = scheduledExecutorService == null;
            this.timerService = this.useSharedTimer ? SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE) : scheduledExecutorService;
            this.maxInboundMetadataSize = maxInboundMetadataSize;
            this.includeCauseWithStatus = includeCauseWithStatus;
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress addr, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            return new InProcessTransport(addr, this.maxInboundMetadataSize, options.getAuthority(), options.getUserAgent(), options.getEagAttributes(), this.includeCauseWithStatus);
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.timerService;
        }

        @Override
        public ClientTransportFactory.SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials channelCreds) {
            return null;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.useSharedTimer) {
                SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.timerService);
            }
        }
    }
}

