/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.ProtoUtils;

class CommitInfoCache {
    private final ConcurrentMap<RaftPeerId, RaftProtos.CommitInfoProto> map = new ConcurrentHashMap<RaftPeerId, RaftProtos.CommitInfoProto>();

    CommitInfoCache() {
    }

    RaftProtos.CommitInfoProto get(RaftPeerId id) {
        return (RaftProtos.CommitInfoProto)this.map.get(id);
    }

    RaftProtos.CommitInfoProto update(RaftPeer peer, long newCommitIndex) {
        Objects.requireNonNull(peer, "peer == null");
        return this.map.compute(peer.getId(), (id, old) -> old == null || newCommitIndex > old.getCommitIndex() ? ProtoUtils.toCommitInfoProto((RaftPeer)peer, (long)newCommitIndex) : old);
    }

    RaftProtos.CommitInfoProto update(RaftProtos.CommitInfoProto newInfo) {
        return this.map.compute(RaftPeerId.valueOf((ByteString)newInfo.getServer().getId()), (id, old) -> old == null || newInfo.getCommitIndex() > old.getCommitIndex() ? newInfo : old);
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ":" + this.map.values();
    }
}

