/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import org.apache.celeborn.common.network.protocol.Encodable;

public final class StreamChunkSlice
implements Encodable {
    public final long streamId;
    public final int chunkIndex;
    public final int offset;
    public final int len;

    public StreamChunkSlice(long streamId, int chunkIndex) {
        this.streamId = streamId;
        this.chunkIndex = chunkIndex;
        this.offset = 0;
        this.len = Integer.MAX_VALUE;
    }

    public StreamChunkSlice(long streamId, int chunkIndex, int offset, int len) {
        this.streamId = streamId;
        this.chunkIndex = chunkIndex;
        this.offset = offset;
        this.len = len;
    }

    @Override
    public int encodedLength() {
        return 20;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeLong(this.streamId);
        buffer.writeInt(this.chunkIndex);
        buffer.writeInt(this.offset);
        buffer.writeInt(this.len);
    }

    public static StreamChunkSlice decode(ByteBuf buffer) {
        assert (buffer.readableBytes() >= 20);
        long streamId = buffer.readLong();
        int chunkIndex = buffer.readInt();
        int offset = buffer.readInt();
        int len = buffer.readInt();
        return new StreamChunkSlice(streamId, chunkIndex, offset, len);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.streamId, this.chunkIndex, this.offset, this.len});
    }

    public boolean equals(Object other) {
        if (other instanceof StreamChunkSlice) {
            StreamChunkSlice o = (StreamChunkSlice)other;
            return this.streamId == o.streamId && this.chunkIndex == o.chunkIndex && this.offset == o.offset && this.len == o.len;
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("streamId", this.streamId).add("chunkIndex", this.chunkIndex).add("offset", this.offset).add("len", this.len).toString();
    }
}

