/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceLocalizationRequest;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.LocalResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class ResourceLocalizationRequestPBImpl
extends ResourceLocalizationRequest {
    private YarnServiceProtos.ResourceLocalizationRequestProto proto = YarnServiceProtos.ResourceLocalizationRequestProto.getDefaultInstance();
    private YarnServiceProtos.ResourceLocalizationRequestProto.Builder builder = null;
    private boolean viaProto = false;
    private Map<String, LocalResource> localResources = null;
    private ContainerId containerId;

    public ResourceLocalizationRequestPBImpl() {
        this.builder = YarnServiceProtos.ResourceLocalizationRequestProto.newBuilder();
    }

    public ResourceLocalizationRequestPBImpl(YarnServiceProtos.ResourceLocalizationRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.containerId != null) {
            this.builder.setContainerId(this.convertToProtoFormat(this.containerId));
        }
        if (this.localResources != null) {
            this.addLocalResourcesToProto();
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.ResourceLocalizationRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void addLocalResourcesToProto() {
        this.maybeInitBuilder();
        this.builder.clearLocalResources();
        if (this.localResources == null) {
            return;
        }
        Iterable<YarnProtos.StringLocalResourceMapProto> iterable = new Iterable<YarnProtos.StringLocalResourceMapProto>(){

            @Override
            public Iterator<YarnProtos.StringLocalResourceMapProto> iterator() {
                return new Iterator<YarnProtos.StringLocalResourceMapProto>(){
                    Iterator<String> keyIter;
                    {
                        this.keyIter = ResourceLocalizationRequestPBImpl.this.localResources.keySet().iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public YarnProtos.StringLocalResourceMapProto next() {
                        String key = this.keyIter.next();
                        return YarnProtos.StringLocalResourceMapProto.newBuilder().setKey(key).setValue(ResourceLocalizationRequestPBImpl.this.convertToProtoFormat((LocalResource)ResourceLocalizationRequestPBImpl.this.localResources.get(key))).build();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIter.hasNext();
                    }
                };
            }
        };
        this.builder.addAllLocalResources((Iterable<? extends YarnProtos.StringLocalResourceMapProto>)iterable);
    }

    public YarnServiceProtos.ResourceLocalizationRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ResourceLocalizationRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void initLocalResources() {
        if (this.localResources != null) {
            return;
        }
        YarnServiceProtos.ResourceLocalizationRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.StringLocalResourceMapProto> list = p.getLocalResourcesList();
        this.localResources = new HashMap<String, LocalResource>();
        for (YarnProtos.StringLocalResourceMapProto c : list) {
            this.localResources.put(c.getKey(), this.convertFromProtoFormat(c.getValue()));
        }
    }

    private LocalResourcePBImpl convertFromProtoFormat(YarnProtos.LocalResourceProto p) {
        return new LocalResourcePBImpl(p);
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private YarnProtos.LocalResourceProto convertToProtoFormat(LocalResource t) {
        return ((LocalResourcePBImpl)t).getProto();
    }

    @Override
    public ContainerId getContainerId() {
        YarnServiceProtos.ResourceLocalizationRequestProtoOrBuilder p;
        YarnServiceProtos.ResourceLocalizationRequestProtoOrBuilder resourceLocalizationRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.containerId != null) {
            return this.containerId;
        }
        if (!p.hasContainerId()) {
            return null;
        }
        this.containerId = this.convertFromProtoFormat(p.getContainerId());
        return this.containerId;
    }

    @Override
    public void setContainerId(ContainerId containerId) {
        this.maybeInitBuilder();
        if (containerId == null) {
            this.builder.clearContainerId();
        }
        this.containerId = containerId;
    }

    @Override
    public Map<String, LocalResource> getLocalResources() {
        this.initLocalResources();
        return this.localResources;
    }

    @Override
    public void setLocalResources(Map<String, LocalResource> localResources) {
        if (localResources == null) {
            this.localResources = null;
            this.builder.clearLocalResources();
            return;
        }
        this.localResources = new HashMap<String, LocalResource>(localResources);
    }
}

