/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer;

import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.crypto.transformer.BindingsTransformer;
import org.apache.cayenne.crypto.transformer.bytes.BytesEncryptor;
import org.apache.cayenne.crypto.transformer.value.ValueEncryptor;

public class DefaultBindingsTransformer
implements BindingsTransformer {
    private int[] positions;
    private ValueEncryptor[] transformers;
    private BytesEncryptor encryptor;
    private ExtendedTypeMap extendedTypeMap;

    public DefaultBindingsTransformer(int[] positions, ValueEncryptor[] transformers, BytesEncryptor encryptor, ExtendedTypeMap extendedTypeMap) {
        this.positions = positions;
        this.transformers = transformers;
        this.encryptor = encryptor;
        this.extendedTypeMap = extendedTypeMap;
    }

    @Override
    public void transform(DbAttributeBinding[] bindings) {
        int len = this.positions.length;
        for (int i = 0; i < len; ++i) {
            DbAttributeBinding b = bindings[this.positions[i]];
            Object transformed = this.transformers[i].encrypt(this.encryptor, b.getValue());
            b.setValue(transformed);
            ExtendedType extendedType = transformed != null ? this.extendedTypeMap.getRegisteredType(transformed.getClass()) : this.extendedTypeMap.getDefaultType();
            b.setExtendedType(extendedType);
        }
    }
}

