/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import org.hyperic.sigar.win32.Win32;

public class LocaleInfo
extends Win32 {
    public static final int LOCALE_SENGLANGUAGE = 4097;
    public static final int LOCALE_SENGCOUNTRY = 4098;
    public static final int LANG_ENGLISH = 9;
    private int id;

    private static native int getSystemDefaultLCID();

    private static native String getAttribute(int var0, int var1);

    public LocaleInfo() {
        this(LocaleInfo.getSystemDefaultLCID());
    }

    public static final int makeLangId(int primary, int sub) {
        return sub << 10 | primary;
    }

    public LocaleInfo(Integer id) {
        this((int)id);
    }

    public LocaleInfo(int id) {
        this.id = id;
    }

    public LocaleInfo(int primary, int sub) {
        this(LocaleInfo.makeLangId(primary, sub));
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    private static int getPrimaryLangId(int id) {
        return id & 0x3FF;
    }

    public int getPrimaryLangId() {
        return LocaleInfo.getPrimaryLangId(this.id);
    }

    private static int getSubLangId(int id) {
        return id >> 10;
    }

    public int getSubLangId() {
        return LocaleInfo.getSubLangId(this.id);
    }

    public static boolean isEnglish() {
        int id = LocaleInfo.getSystemDefaultLCID();
        return LocaleInfo.getPrimaryLangId(id) == 9;
    }

    public String getPerflibLangId() {
        String id = Integer.toHexString(this.getPrimaryLangId()).toUpperCase();
        int pad = 3 - id.length();
        StringBuffer fid = new StringBuffer(3);
        while (pad-- > 0) {
            fid.append("0");
        }
        fid.append(id);
        return fid.toString();
    }

    public String getAttribute(int attr) {
        return LocaleInfo.getAttribute(this.id, attr);
    }

    public String getEnglishLanguageName() {
        return this.getAttribute(4097);
    }

    public String getEnglishCountryName() {
        return this.getAttribute(4098);
    }

    public String toString() {
        return this.getId() + ":" + this.getEnglishLanguageName() + " (" + this.getEnglishCountryName() + ")";
    }
}

